/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal;

import io.ballerina.runtime.api.types.AttachedFunctionType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.scheduling.Strand;
import io.ballerina.runtime.internal.types.AttachedFunction;
import io.ballerina.runtime.internal.types.BAnnotatableType;
import io.ballerina.runtime.internal.types.BObjectType;
import io.ballerina.runtime.internal.types.BServiceType;
import io.ballerina.runtime.internal.values.FPValue;
import io.ballerina.runtime.internal.values.MapValue;

public class AnnotationUtils {
    public static void processAnnotations(MapValue globalAnnotMap, Type bType) {
        if (!(bType instanceof BAnnotatableType)) {
            return;
        }
        BAnnotatableType type = (BAnnotatableType)bType;
        BString annotationKey = StringUtils.fromString(type.getAnnotationKey());
        if (globalAnnotMap.containsKey(annotationKey)) {
            type.setAnnotations((MapValue)globalAnnotMap.get(annotationKey));
        }
        if (type.getTag() != 35) {
            return;
        }
        BObjectType objectType = (BObjectType)type;
        for (AttachedFunctionType attachedFunction : objectType.getAttachedFunctions()) {
            annotationKey = StringUtils.fromString(attachedFunction.getAnnotationKey());
            if (!globalAnnotMap.containsKey(annotationKey)) continue;
            ((AttachedFunction)attachedFunction).setAnnotations((MapValue)globalAnnotMap.get(annotationKey));
        }
    }

    public static void processServiceAnnotations(MapValue globalAnnotMap, BServiceType bType, Strand strand) {
        BString annotationKey = StringUtils.fromString(bType.getAnnotationKey());
        if (globalAnnotMap.containsKey(annotationKey)) {
            bType.setAnnotations((MapValue)((FPValue)globalAnnotMap.get(annotationKey)).call(new Object[]{strand}));
        }
        for (AttachedFunctionType attachedFunction : bType.getAttachedFunctions()) {
            annotationKey = StringUtils.fromString(attachedFunction.getAnnotationKey());
            if (!globalAnnotMap.containsKey(annotationKey)) continue;
            ((AttachedFunction)attachedFunction).setAnnotations((MapValue)((FPValue)globalAnnotMap.get(annotationKey)).call(new Object[]{strand}));
        }
    }

    public static void processFPValueAnnotations(FPValue fpValue, MapValue globalAnnotMap, String name) {
        BAnnotatableType type = (BAnnotatableType)fpValue.getType();
        BString nameKey = StringUtils.fromString(name);
        if (globalAnnotMap.containsKey(nameKey)) {
            type.setAnnotations((MapValue)globalAnnotMap.get(nameKey));
        }
    }

    public static boolean isConcurrent(FPValue fpValue) {
        return fpValue.isConcurrent;
    }

    public static String getStrandName(FPValue fpValue, String defaultName) {
        if (fpValue.strandName != null) {
            return fpValue.strandName;
        }
        return defaultName;
    }
}

