/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal;

import io.ballerina.runtime.internal.scheduling.State;
import io.ballerina.runtime.internal.scheduling.Strand;
import java.util.ArrayDeque;

public class BLock {
    private ArrayDeque<Strand> current = new ArrayDeque();
    private ArrayDeque<Strand> waitingForLock = new ArrayDeque();

    public synchronized boolean lock(Strand strand) {
        if (this.isLockFree() || this.lockedBySameContext(strand)) {
            this.current.offerLast(strand);
            return true;
        }
        this.waitingForLock.offerLast(strand);
        strand.setState(State.BLOCK_AND_YIELD);
        strand.blockedOnExtern = false;
        return false;
    }

    public synchronized void unlock() {
        this.current.removeLast();
        if (!this.waitingForLock.isEmpty()) {
            Strand strand = this.waitingForLock.removeFirst();
            strand.scheduler.unblockStrand(strand);
        }
    }

    public boolean isLockFree() {
        return this.current.isEmpty();
    }

    public boolean lockedBySameContext(Strand ctx) {
        return this.current.getLast() == ctx;
    }
}

