/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.PredefinedTypes;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.runtime.internal.CycleUtils;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.XmlFactory;
import io.ballerina.runtime.internal.types.BAnyType;
import io.ballerina.runtime.internal.types.BAnydataType;
import io.ballerina.runtime.internal.types.BArrayType;
import io.ballerina.runtime.internal.types.BMapType;
import io.ballerina.runtime.internal.types.BTableType;
import io.ballerina.runtime.internal.types.BTupleType;
import io.ballerina.runtime.internal.types.BUnionType;
import io.ballerina.runtime.internal.values.ArrayValue;
import io.ballerina.runtime.internal.values.ArrayValueImpl;
import io.ballerina.runtime.internal.values.MapValueImpl;
import io.ballerina.runtime.internal.values.TableValueImpl;
import io.ballerina.runtime.internal.values.TupleValueImpl;
import io.ballerina.runtime.internal.values.XmlSequence;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BalStringUtils {
    private static final UnionType bUnionType = new BUnionType(Arrays.asList(PredefinedTypes.TYPE_ANYDATA, PredefinedTypes.TYPE_ERROR));
    private static boolean hasCycles = false;

    public static Object parseArrayExpressionStringValue(String exprValue, BLink parent) {
        Type type;
        List<String> list = BalStringUtils.getElements(exprValue);
        ArrayValueImpl arr = new ArrayValueImpl(new BArrayType(bUnionType));
        CycleUtils.Node node = new CycleUtils.Node(arr, parent);
        HashSet<Type> typeSet = new HashSet<Type>();
        for (int i = 0; i < list.size(); ++i) {
            String e = list.get(i);
            Object val = StringUtils.parseExpressionStringValue(e, node);
            Type type2 = TypeChecker.getType(val);
            typeSet.add(type2);
            arr.add((long)i, val);
        }
        int size = arr.size();
        if (hasCycles) {
            return arr;
        }
        if (typeSet.size() > 1) {
            type = new BUnionType(new ArrayList<Type>(typeSet));
            Object[] refValues = new Object[size];
            for (int i = 0; i < size; ++i) {
                refValues[i] = arr.get(i);
            }
            return ValueCreator.createArrayValue(refValues, new BArrayType(type));
        }
        type = (Type)typeSet.iterator().next();
        int tag = type.getTag();
        switch (tag) {
            case 1: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                long[] intValues = new long[size];
                for (int i = 0; i < size; ++i) {
                    intValues[i] = Long.parseLong(arr.get(i).toString());
                }
                return ValueCreator.createArrayValue(intValues);
            }
            case 2: {
                byte[] byteValues = new byte[size];
                for (int i = 0; i < size; ++i) {
                    byteValues[i] = Byte.parseByte(arr.get(i).toString());
                }
                return ValueCreator.createArrayValue(byteValues);
            }
            case 3: {
                double[] floatValues = new double[size];
                for (int i = 0; i < size; ++i) {
                    floatValues[i] = Double.parseDouble(arr.get(i).toString());
                }
                return ValueCreator.createArrayValue(floatValues);
            }
            case 5: 
            case 46: {
                BString[] bStringValues = new BString[size];
                for (int i = 0; i < size; ++i) {
                    bStringValues[i] = StringUtils.fromString(arr.get(i).toString());
                }
                return ValueCreator.createArrayValue(bStringValues);
            }
            case 6: {
                boolean[] booleanValues = new boolean[size];
                for (int i = 0; i < size; ++i) {
                    booleanValues[i] = Boolean.parseBoolean(arr.get(i).toString());
                }
                return ValueCreator.createArrayValue(booleanValues);
            }
        }
        Object[] refValues = new Object[size];
        for (int i = 0; i < size; ++i) {
            refValues[i] = arr.get(i);
        }
        return ValueCreator.createArrayValue(refValues, new BArrayType(type));
    }

    public static Object parseMapExpressionStringValue(String exprValue, BLink parent) {
        MapValueImpl<BString, Object> result;
        List<String> list = BalStringUtils.getElements(exprValue);
        MapValueImpl<BString, Object> eleMap = new MapValueImpl<BString, Object>(new BMapType(bUnionType));
        CycleUtils.Node node = new CycleUtils.Node(eleMap, parent);
        HashSet<Type> typeSet = new HashSet<Type>();
        for (int i = 0; i < list.size(); ++i) {
            String e = list.get(i);
            int colonIndex = e.indexOf(58);
            int quotesCount = 0;
            for (int j = 0; j < e.length(); ++j) {
                if (e.charAt(j) == '\"') {
                    ++quotesCount;
                    continue;
                }
                if (e.charAt(j) != ':' || quotesCount % 2 != 0) continue;
                colonIndex = j;
                break;
            }
            String key = e.substring(1, colonIndex - 1);
            String value = e.substring(colonIndex + 1);
            Object val = StringUtils.parseExpressionStringValue(value, node);
            eleMap.put(StringUtils.fromString(key), val);
            Type type = TypeChecker.getType(val);
            typeSet.add(type);
        }
        if (hasCycles) {
            return eleMap;
        }
        if (typeSet.size() > 1) {
            BUnionType type = new BUnionType(new ArrayList<Type>(typeSet));
            result = new MapValueImpl(new BMapType(type));
            result.putAll(eleMap);
            return result;
        }
        Type type = (Type)typeSet.iterator().next();
        result = new MapValueImpl<BString, Object>(new BMapType(type));
        result.putAll(eleMap);
        return result;
    }

    public static Object parseTableExpressionStringValue(String exprValue, BLink parent) {
        String[] keys = exprValue.substring(exprValue.indexOf(40) + 1, exprValue.indexOf(41)).split(",");
        ArrayValue fieldNames = (ArrayValue)StringUtils.fromStringArray(keys);
        ArrayValueImpl data = (ArrayValueImpl)StringUtils.parseExpressionStringValue(exprValue.substring(exprValue.indexOf(41) + 2), parent);
        BAnydataType typeAnydata = new BAnydataType("anydata", new Module(null, null, null), false);
        BAnyType typeAny = new BAnyType("any", new Module(null, null, null), false);
        BMapType typeMap = new BMapType("map", typeAny, new Module(null, null, null));
        return new TableValueImpl(new BTableType((Type)typeMap, typeAnydata, false), data, fieldNames);
    }

    public static Object parseTupleExpressionStringValue(String exprValue, BLink parent) {
        String[] stringElements = exprValue.split(" ");
        Object[] elements = new Object[stringElements.length];
        ArrayList<Type> typeList = new ArrayList<Type>();
        for (int i = 0; i < stringElements.length; ++i) {
            Object value;
            elements[i] = value = StringUtils.parseExpressionStringValue(stringElements[i], parent);
            Type type = TypeChecker.getType(value);
            typeList.add(type);
        }
        return new TupleValueImpl(elements, new BTupleType(typeList));
    }

    public static Object parseXmlExpressionStringValue(String exprValue, BLink parent) {
        if (exprValue.matches("<[\\!--](.*?)[\\-\\-\\!]>")) {
            String comment = exprValue.substring(exprValue.indexOf("<!--") + 4, exprValue.lastIndexOf("-->"));
            return XmlFactory.createXMLComment(comment);
        }
        if (exprValue.matches("<\\?(.*?)\\?>")) {
            String pi = exprValue.substring(exprValue.indexOf("<?") + 2, exprValue.lastIndexOf("?>"));
            String[] piArgs = pi.split(" ", 2);
            return XmlFactory.createXMLProcessingInstruction(StringUtils.fromString(piArgs[0]), StringUtils.fromString(piArgs[1]));
        }
        if (exprValue.matches("<(\\S+?)(.*?)>(.*?)</\\1>")) {
            return XmlFactory.parse(exprValue);
        }
        if (!(exprValue.startsWith("<?") || exprValue.startsWith("<!--") || exprValue.startsWith("<"))) {
            return XmlFactory.createXMLText(StringUtils.fromString(exprValue));
        }
        Pattern pattern = Pattern.compile("<(\\S+?)(.*?)>(.*?)</\\1>|<[\\!--](.*?)[\\-\\-\\!]>|<\\?(.*?)\\?>");
        Matcher matcher = pattern.matcher(exprValue);
        ArrayList<BXml> children = new ArrayList<BXml>();
        String part = exprValue;
        while (matcher.find()) {
            String item = matcher.group();
            String[] splitParts = part.split(item, 2);
            String splitItem = splitParts[0];
            if (splitItem.isEmpty()) {
                children.add((BXml)BalStringUtils.parseXmlExpressionStringValue(item, parent));
            } else {
                children.add((BXml)BalStringUtils.parseXmlExpressionStringValue(splitItem, parent));
                if (!item.equals(splitItem)) {
                    children.add((BXml)BalStringUtils.parseXmlExpressionStringValue(item, parent));
                }
            }
            if (splitParts.length != 2) continue;
            part = splitParts[1];
        }
        return new XmlSequence(children);
    }

    public static Object parseCycleDetectedExpressionStringValue(String exprValue, BLink parent) {
        hasCycles = true;
        int index = Integer.parseInt(exprValue.substring(4, exprValue.length() - 1));
        CycleUtils.Node mapParent = (CycleUtils.Node)parent;
        Object value = mapParent.obj;
        if (index == 0) {
            return value;
        }
        for (int j = 0; j < index; ++j) {
            value = mapParent.obj;
            if (mapParent.parent == null) continue;
            mapParent = (CycleUtils.Node)mapParent.parent;
        }
        return value;
    }

    public static List<String> getElements(String exprValue) {
        char[] strChars;
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder part = new StringBuilder();
        int balance = 0;
        int quotesCount = 0;
        for (char strChar : strChars = exprValue.substring(1, exprValue.length() - 1).toCharArray()) {
            part.append(strChar);
            if (strChar == '\"') {
                ++quotesCount;
                continue;
            }
            if (strChar == '[' && quotesCount % 2 == 0) {
                ++balance;
                continue;
            }
            if (strChar == '{' && quotesCount % 2 == 0) {
                ++balance;
                continue;
            }
            if (strChar == '(' && quotesCount % 2 == 0) {
                ++balance;
                continue;
            }
            if (strChar == ']' && quotesCount % 2 == 0) {
                --balance;
                continue;
            }
            if (strChar == '}' && quotesCount % 2 == 0) {
                --balance;
                continue;
            }
            if (strChar == ')' && quotesCount % 2 == 0) {
                --balance;
                continue;
            }
            if (strChar != ',' || balance != 0 || quotesCount % 2 != 0) continue;
            list.add(part.substring(0, part.length() - 1));
            part = new StringBuilder();
        }
        if (part.length() > 0) {
            list.add(part.toString());
        }
        return list;
    }
}

