/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal;

import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.runtime.internal.util.exceptions.BLangExceptionHelper;
import io.ballerina.runtime.internal.values.XmlComment;
import io.ballerina.runtime.internal.values.XmlItem;
import io.ballerina.runtime.internal.values.XmlPi;
import io.ballerina.runtime.internal.values.XmlSequence;
import io.ballerina.runtime.internal.values.XmlText;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class BallerinaXmlSerializer
extends OutputStream {
    private static final XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
    private static final String XMLNS = "xmlns";
    private static final String EMPTY_STR = "";
    public static final String PARSE_XML_OP = "parse xml";
    public static final String XML = "xml";
    private XMLStreamWriter xmlStreamWriter;
    private Deque<Set<String>> parentNSSet;
    private int nsNumber;

    public BallerinaXmlSerializer(OutputStream outputStream) {
        try {
            this.xmlStreamWriter = xmlOutputFactory.createXMLStreamWriter(outputStream);
            this.parentNSSet = new ArrayDeque<Set<String>>();
        }
        catch (XMLStreamException e) {
            BLangExceptionHelper.handleXMLException(PARSE_XML_OP, e);
        }
    }

    @Override
    public void write(int b) {
        assert (false);
    }

    @Override
    public void flush() {
        try {
            this.xmlStreamWriter.flush();
        }
        catch (XMLStreamException e) {
            BLangExceptionHelper.handleXMLException(PARSE_XML_OP, e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.xmlStreamWriter.close();
        }
        catch (XMLStreamException e) {
            BLangExceptionHelper.handleXMLException(PARSE_XML_OP, e);
        }
    }

    public void write(BXml xmlValue) {
        if (xmlValue == null) {
            return;
        }
        try {
            switch (xmlValue.getNodeType()) {
                case SEQUENCE: {
                    this.writeSeq((XmlSequence)xmlValue);
                    break;
                }
                case ELEMENT: {
                    this.writeElement((XmlItem)xmlValue);
                    break;
                }
                case TEXT: {
                    this.writeXMLText((XmlText)xmlValue);
                    break;
                }
                case COMMENT: {
                    this.writeXMLComment((XmlComment)xmlValue);
                    break;
                }
                case PI: {
                    this.writeXMLPI((XmlPi)xmlValue);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + xmlValue.getNodeType());
                }
            }
        }
        catch (XMLStreamException e) {
            BLangExceptionHelper.handleXMLException(PARSE_XML_OP, e);
        }
    }

    private void writeXMLPI(XmlPi xmlValue) throws XMLStreamException {
        this.xmlStreamWriter.writeProcessingInstruction(xmlValue.getTarget(), xmlValue.getData());
    }

    private void writeXMLComment(XmlComment xmlValue) throws XMLStreamException {
        this.xmlStreamWriter.writeComment(xmlValue.getTextValue());
    }

    private void writeXMLText(XmlText xmlValue) throws XMLStreamException {
        String textValue = xmlValue.getTextValue();
        if (!textValue.isEmpty()) {
            this.xmlStreamWriter.writeCharacters(textValue);
        }
    }

    private void writeElement(XmlItem xmlValue) throws XMLStreamException {
        Set<String> prevNSSet = this.parentNSSet.peek();
        HashSet<String> currentNSLevel = prevNSSet == null ? new HashSet<String>() : new HashSet<String>(prevNSSet);
        this.parentNSSet.push(currentNSLevel);
        LinkedHashMap<String, String> nsPrefixMap = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> attributeMap = new LinkedHashMap<String, String>();
        this.splitAttributesAndNSPrefixes(xmlValue, nsPrefixMap, attributeMap);
        QName qName = xmlValue.getQName();
        this.writeStartElement(qName, nsPrefixMap, currentNSLevel);
        this.setMissingElementPrefix(nsPrefixMap, qName);
        this.writeNamespaceAttributes(currentNSLevel, nsPrefixMap);
        this.writeAttributes(currentNSLevel, attributeMap);
        xmlValue.getChildrenSeq().serialize(this);
        this.xmlStreamWriter.writeEndElement();
        this.parentNSSet.pop();
    }

    private String setDefaultNamespace(Map<String, String> nsPrefixMap, QName qName, HashSet<String> currentNSLevel) throws XMLStreamException {
        boolean elementNSUsageFoundInAttribute = false;
        for (Map.Entry<String, String> entry : nsPrefixMap.entrySet()) {
            if (entry.getValue().equals(qName.getNamespaceURI())) {
                elementNSUsageFoundInAttribute = true;
            }
            if (!entry.getKey().isEmpty()) continue;
            this.xmlStreamWriter.setDefaultNamespace(entry.getValue());
            return entry.getValue();
        }
        if (!elementNSUsageFoundInAttribute && !qName.getNamespaceURI().isEmpty()) {
            this.xmlStreamWriter.setDefaultNamespace(qName.getNamespaceURI());
            return qName.getNamespaceURI();
        }
        String defaultNsURI = nsPrefixMap.get(XMLNS);
        if (defaultNsURI != null) {
            this.xmlStreamWriter.setDefaultNamespace(defaultNsURI);
            return defaultNsURI;
        }
        if (qName.getNamespaceURI() == null || qName.getNamespaceURI().isEmpty()) {
            for (String s : currentNSLevel) {
                if (!s.startsWith(XMLNS)) continue;
                this.xmlStreamWriter.setDefaultNamespace(EMPTY_STR);
                return EMPTY_STR;
            }
        }
        return null;
    }

    private void writeStartElement(QName qName, Map<String, String> nsPrefixMap, HashSet<String> currentNSLevel) throws XMLStreamException {
        String defaultNamespaceUri = this.setDefaultNamespace(nsPrefixMap, qName, currentNSLevel);
        if (qName.getPrefix() == null || qName.getPrefix().isEmpty()) {
            this.xmlStreamWriter.writeStartElement(qName.getLocalPart());
        } else {
            this.xmlStreamWriter.writeStartElement(qName.getPrefix(), qName.getLocalPart(), qName.getNamespaceURI());
        }
        if (defaultNamespaceUri == null) {
            return;
        }
        String defaultNsMapEntry = this.concatNsPrefixURI(EMPTY_STR, defaultNamespaceUri);
        if (!currentNSLevel.contains(defaultNsMapEntry)) {
            this.xmlStreamWriter.writeDefaultNamespace(defaultNamespaceUri);
            currentNSLevel.add(defaultNsMapEntry);
        }
    }

    private void writeAttributes(HashSet<String> curNSSet, Map<String, String> attributeMap) throws XMLStreamException {
        String defaultNS = this.xmlStreamWriter.getNamespaceContext().getNamespaceURI(XMLNS);
        for (Map.Entry<String, String> attributeEntry : attributeMap.entrySet()) {
            String key = attributeEntry.getKey();
            int closingCurlyPos = key.lastIndexOf(125);
            if (closingCurlyPos == -1) {
                this.xmlStreamWriter.writeAttribute(key, attributeEntry.getValue());
                continue;
            }
            String uri = key.substring(1, closingCurlyPos);
            if (this.xmlStreamWriter.getNamespaceContext().getPrefix(uri) == null) {
                this.generateAndAddRandomNSPrefix(curNSSet, uri);
            }
            String localName = key.substring(closingCurlyPos + 1);
            if (uri.isEmpty() || uri.equals(defaultNS)) {
                this.xmlStreamWriter.writeAttribute(localName, attributeEntry.getValue());
                continue;
            }
            this.xmlStreamWriter.writeAttribute(uri, localName, attributeEntry.getValue());
        }
    }

    private void writeNamespaceAttributes(HashSet<String> curNSSet, Map<String, String> nsPrefixMap) throws XMLStreamException {
        for (Map.Entry<String, String> nsEntry : nsPrefixMap.entrySet()) {
            String nsUri;
            String nsKey;
            String prefix = nsEntry.getKey();
            if (prefix.isEmpty() || prefix.equals(XMLNS) || curNSSet.contains(nsKey = this.concatNsPrefixURI(prefix, nsUri = nsEntry.getValue()))) continue;
            this.xmlStreamWriter.writeNamespace(prefix, nsUri);
            this.xmlStreamWriter.setPrefix(prefix, nsUri);
            curNSSet.add(nsKey);
        }
    }

    private void setMissingElementPrefix(Map<String, String> nsPrefixMap, QName qName) throws XMLStreamException {
        String namespaceURI = qName.getNamespaceURI();
        if (!namespaceURI.isEmpty() && qName.getPrefix().isEmpty() && this.alreadyDefinedNSPrefixNotFound(qName)) {
            for (Map.Entry<String, String> entry : nsPrefixMap.entrySet()) {
                if (!entry.getValue().equals(namespaceURI) || entry.getKey().equals(XMLNS)) continue;
                this.xmlStreamWriter.setPrefix(entry.getKey(), entry.getValue());
                break;
            }
        }
    }

    private boolean alreadyDefinedNSPrefixNotFound(QName qName) {
        String prefix = this.xmlStreamWriter.getNamespaceContext().getPrefix(qName.getNamespaceURI());
        return prefix == null || prefix.isEmpty();
    }

    private void generateAndAddRandomNSPrefix(HashSet<String> curNSSet, String uri) throws XMLStreamException {
        if (uri.isEmpty()) {
            return;
        }
        String randomNSPrefix = this.generateRandomPrefix(curNSSet, uri);
        String nsKey = this.concatNsPrefixURI(randomNSPrefix, uri);
        this.xmlStreamWriter.writeNamespace(randomNSPrefix, uri);
        this.xmlStreamWriter.setPrefix(randomNSPrefix, uri);
        curNSSet.add(nsKey);
    }

    private String generateRandomPrefix(HashSet<String> curNSSet, String uri) {
        ++this.nsNumber;
        String generatedNs = "ns" + this.nsNumber;
        if (curNSSet.contains(this.concatNsPrefixURI(generatedNs, uri))) {
            return this.generateRandomPrefix(curNSSet, uri);
        }
        for (String nsFrag : curNSSet) {
            int end;
            String prefix = nsFrag.substring(0, end = nsFrag.indexOf("<>"));
            if (!prefix.equals(generatedNs)) continue;
            return this.generateRandomPrefix(curNSSet, uri);
        }
        return generatedNs;
    }

    private String concatNsPrefixURI(String randStr, String nsUri) {
        return randStr + "<>" + nsUri;
    }

    private void splitAttributesAndNSPrefixes(XmlItem xmlValue, Map<String, String> nsPrefixMap, Map<String, String> attributeMap) {
        for (Map.Entry attributeEntry : xmlValue.getAttributesMap().entrySet()) {
            String key = ((BString)attributeEntry.getKey()).getValue();
            if (key.startsWith("{http://www.w3.org/2000/xmlns/}")) {
                int closingCurly = key.indexOf(125);
                String prefix = key.substring(closingCurly + 1);
                if (prefix.equals(XML)) continue;
                nsPrefixMap.put(prefix, ((BString)attributeEntry.getValue()).getValue());
                continue;
            }
            attributeMap.put(key, ((BString)attributeEntry.getValue()).getValue());
        }
        String defaultNs = nsPrefixMap.get(EMPTY_STR);
        if (defaultNs != null) {
            ArrayList<String> alternativePrefixes = new ArrayList<String>();
            for (Map.Entry<String, String> entry : nsPrefixMap.entrySet()) {
                if (entry.getKey().isEmpty() || !entry.getValue().equals(defaultNs)) continue;
                alternativePrefixes.add(entry.getKey());
            }
            for (String prefix : alternativePrefixes) {
                nsPrefixMap.remove(prefix);
            }
        }
    }

    private void writeSeq(XmlSequence xmlValue) {
        for (BXml value : xmlValue.getChildrenList()) {
            this.write(value);
        }
    }

    static {
        if (xmlOutputFactory.getClass().getName().equals("com.ctc.wstx.stax.WstxOutputFactory")) {
            xmlOutputFactory.setProperty("com.ctc.wstx.outputValidateStructure", false);
        }
    }
}

