/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal;

import io.ballerina.runtime.api.PredefinedTypes;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMapInitialValueEntry;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.util.exceptions.BLangExceptionHelper;
import io.ballerina.runtime.internal.util.exceptions.BallerinaErrorReasons;
import io.ballerina.runtime.internal.util.exceptions.RuntimeErrors;
import io.ballerina.runtime.internal.values.ErrorValue;
import io.ballerina.runtime.internal.values.MapValueImpl;
import io.ballerina.runtime.internal.values.MappingInitialValueEntry;

public class ErrorUtils {
    private static final BString ERROR_MESSAGE_FIELD = StringUtils.fromString("message");
    private static final BString ERROR_CAUSE_FIELD = StringUtils.fromString("cause");
    private static final BString NULL_REF_EXCEPTION = StringUtils.fromString("NullReferenceException");

    public static ErrorValue createInteropError(Throwable e) {
        BMapInitialValueEntry[] initialValues;
        String message = e.getMessage();
        Throwable cause = e.getCause();
        if (message != null && cause != null) {
            initialValues = new MappingInitialValueEntry[]{new MappingInitialValueEntry.KeyValueEntry(ERROR_MESSAGE_FIELD, StringUtils.fromString(message)), new MappingInitialValueEntry.KeyValueEntry(ERROR_CAUSE_FIELD, ErrorCreator.createError(StringUtils.fromString(cause.getClass().getName()), StringUtils.fromString(cause.getMessage())))};
        } else if (message != null || cause != null) {
            initialValues = new MappingInitialValueEntry[1];
            initialValues[0] = message != null ? new MappingInitialValueEntry.KeyValueEntry(ERROR_MESSAGE_FIELD, StringUtils.fromString(message)) : new MappingInitialValueEntry.KeyValueEntry(ERROR_CAUSE_FIELD, ErrorCreator.createError(StringUtils.fromString(cause.getClass().getName()), StringUtils.fromString(cause.getMessage())));
        } else {
            initialValues = new MappingInitialValueEntry[]{};
        }
        MapValueImpl<BString, Object> detailMap = new MapValueImpl<BString, Object>(PredefinedTypes.TYPE_ERROR_DETAIL, initialValues);
        return (ErrorValue)ErrorCreator.createError(StringUtils.fromString(e.getClass().getName()), detailMap);
    }

    public static Object handleResourceError(Object returnValue) {
        if (returnValue instanceof BError) {
            throw (BError)returnValue;
        }
        return returnValue;
    }

    public static ErrorValue trapError(Throwable throwable) {
        BError error = ErrorCreator.createError(BallerinaErrorReasons.STACK_OVERFLOW_ERROR);
        error.setStackTrace(throwable.getStackTrace());
        return (ErrorValue)error;
    }

    public static ErrorValue createCancelledFutureError() {
        return (ErrorValue)ErrorCreator.createError(BallerinaErrorReasons.FUTURE_CANCELLED);
    }

    public static BError createTypeCastError(Object sourceVal, Type targetType) {
        throw ErrorCreator.createError(BallerinaErrorReasons.TYPE_CAST_ERROR, BLangExceptionHelper.getErrorMessage(RuntimeErrors.TYPE_CAST_ERROR, TypeChecker.getType(sourceVal), targetType));
    }

    public static BError createBToJTypeCastError(Object sourceVal, String targetType) {
        throw ErrorCreator.createError(BallerinaErrorReasons.TYPE_CAST_ERROR, BLangExceptionHelper.getErrorMessage(RuntimeErrors.J_TYPE_CAST_ERROR, TypeChecker.getType(sourceVal), targetType));
    }

    public static BError createNumericConversionError(Object inputValue, Type targetType) {
        throw ErrorCreator.createError(BallerinaErrorReasons.NUMBER_CONVERSION_ERROR, BLangExceptionHelper.getErrorMessage(RuntimeErrors.INCOMPATIBLE_SIMPLE_TYPE_CONVERT_OPERATION, TypeChecker.getType(inputValue), inputValue, targetType));
    }

    public static BError createNumericConversionError(Object inputValue, Type inputType, Type targetType) {
        throw ErrorCreator.createError(BallerinaErrorReasons.NUMBER_CONVERSION_ERROR, BLangExceptionHelper.getErrorMessage(RuntimeErrors.INCOMPATIBLE_SIMPLE_TYPE_CONVERT_OPERATION, inputType, inputValue, targetType));
    }
}

