/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal;

import io.ballerina.runtime.api.PredefinedTypes;
import io.ballerina.runtime.api.constants.TypeConstants;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.JsonType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.StructureType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BMapInitialValueEntry;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTable;
import io.ballerina.runtime.internal.TableJsonDataSource;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.types.BArrayType;
import io.ballerina.runtime.internal.types.BJsonType;
import io.ballerina.runtime.internal.types.BMapType;
import io.ballerina.runtime.internal.types.BStructureType;
import io.ballerina.runtime.internal.types.BUnionType;
import io.ballerina.runtime.internal.util.exceptions.BLangExceptionHelper;
import io.ballerina.runtime.internal.util.exceptions.BallerinaErrorReasons;
import io.ballerina.runtime.internal.util.exceptions.BallerinaException;
import io.ballerina.runtime.internal.util.exceptions.RuntimeErrors;
import io.ballerina.runtime.internal.values.ArrayValue;
import io.ballerina.runtime.internal.values.ArrayValueImpl;
import io.ballerina.runtime.internal.values.DecimalValue;
import io.ballerina.runtime.internal.values.ErrorValue;
import io.ballerina.runtime.internal.values.MapValue;
import io.ballerina.runtime.internal.values.MapValueImpl;
import io.ballerina.runtime.internal.values.MappingInitialValueEntry;
import io.ballerina.runtime.internal.values.RefValue;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class JsonUtils {
    public static final String OBJECT = "object";
    public static final String ARRAY = "array";

    public static boolean hasElement(Object json, String elementName) {
        if (!JsonUtils.isJSONObject(json)) {
            return false;
        }
        return ((MapValueImpl)json).containsKey(StringUtils.fromString(elementName));
    }

    public static ArrayValue convertArrayToJSON(BArray bArray) {
        if (bArray == null) {
            return null;
        }
        Type elementType = bArray.getElementType();
        if (elementType == PredefinedTypes.TYPE_INT) {
            return JsonUtils.convertIntArrayToJSON(bArray);
        }
        if (elementType == PredefinedTypes.TYPE_BOOLEAN) {
            return JsonUtils.convertBooleanArrayToJSON(bArray);
        }
        if (elementType == PredefinedTypes.TYPE_FLOAT) {
            return JsonUtils.convertFloatArrayToJSON(bArray);
        }
        if (elementType == PredefinedTypes.TYPE_STRING) {
            return JsonUtils.convertStringArrayToJSON(bArray);
        }
        return JsonUtils.convertRefArrayToJSON(bArray);
    }

    public static Object convertMapToJSON(BMap<BString, ?> map, JsonType targetType) {
        if (map == null) {
            return null;
        }
        MapValueImpl<BString, Object> json = new MapValueImpl<BString, Object>(targetType);
        for (Map.Entry<BString, ?> structField : map.entrySet()) {
            BString key = structField.getKey();
            Object value = structField.getValue();
            JsonUtils.populateJSON(json, key, value, PredefinedTypes.TYPE_JSON);
        }
        return json;
    }

    public static Object getElementOrNil(Object json, BString elementName) {
        return JsonUtils.getMappingElement(json, elementName, true);
    }

    public static Object getElement(Object json, BString elementName) {
        return JsonUtils.getMappingElement(json, elementName, false);
    }

    private static Object getMappingElement(Object json, BString elementName, boolean returnNilOnMissingKey) {
        if (!JsonUtils.isJSONObject(json)) {
            return ErrorCreator.createError(BallerinaErrorReasons.JSON_OPERATION_ERROR, StringUtils.fromString("JSON value is not a mapping"));
        }
        MapValueImpl jsonObject = (MapValueImpl)json;
        if (!jsonObject.containsKey(elementName)) {
            if (returnNilOnMissingKey) {
                return null;
            }
            return ErrorCreator.createError(BallerinaErrorReasons.MAP_KEY_NOT_FOUND_ERROR, StringUtils.fromString("Key '" + elementName + "' not found in JSON mapping"));
        }
        try {
            return jsonObject.get(elementName);
        }
        catch (BallerinaException e) {
            if (e.getDetail() != null) {
                throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.JSON_GET_ERROR, e.getDetail());
            }
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.JSON_GET_ERROR, e.getMessage());
        }
        catch (Throwable t) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.JSON_GET_ERROR, t.getMessage());
        }
    }

    public static void setElement(Object json, String elementName, Object element) {
        if (!JsonUtils.isJSONObject(json)) {
            return;
        }
        try {
            ((MapValueImpl)json).put(StringUtils.fromString(elementName), element);
        }
        catch (ErrorValue e) {
            throw e;
        }
        catch (Throwable t) {
            throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.getModulePrefixedReason("lang.map", "InherentTypeViolation"), RuntimeErrors.JSON_SET_ERROR, t.getMessage());
        }
    }

    public static boolean isJSONArray(Object json) {
        if (!(json instanceof RefValue)) {
            return false;
        }
        return ((RefValue)json).getType().getTag() == 20;
    }

    public static boolean isJSONObject(Object json) {
        if (!(json instanceof RefValue)) {
            return false;
        }
        Type type = ((RefValue)json).getType();
        int typeTag = type.getTag();
        return typeTag == 15 || typeTag == 12;
    }

    public static MapValueImpl<BString, ?> jsonToMap(Object json, MapType mapType) {
        if (json == null || !JsonUtils.isJSONObject(json)) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE, JsonUtils.getComplexObjectTypeName(OBJECT), JsonUtils.getTypeName(json));
        }
        MapValueImpl map = new MapValueImpl(mapType);
        Type mapConstraint = mapType.getConstrainedType();
        if (mapConstraint == null || mapConstraint.getTag() == 17 || mapConstraint.getTag() == 7) {
            ((MapValueImpl)json).entrySet().forEach(entry -> map.put((BString)entry.getKey(), entry.getValue()));
            return map;
        }
        ((MapValueImpl)json).entrySet().forEach(entry -> map.put((BString)entry.getKey(), JsonUtils.convertJSON(entry.getValue(), mapConstraint)));
        return map;
    }

    public static MapValueImpl<BString, Object> convertJSONToRecord(Object json, StructureType structType) {
        if (json == null || !JsonUtils.isJSONObject(json)) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE, JsonUtils.getComplexObjectTypeName(OBJECT), JsonUtils.getTypeName(json));
        }
        MapValueImpl<BString, Object> bStruct = new MapValueImpl<BString, Object>(structType);
        MapValueImpl jsonObject = (MapValueImpl)json;
        for (Map.Entry<String, Field> field : structType.getFields().entrySet()) {
            Type fieldType = field.getValue().getFieldType();
            BString fieldName = StringUtils.fromString(field.getValue().getFieldName());
            try {
                if (!jsonObject.containsKey(fieldName)) {
                    bStruct.put(fieldName, fieldType.getZeroValue());
                    continue;
                }
                Object jsonValue = jsonObject.get(fieldName);
                bStruct.put(fieldName, JsonUtils.convertJSON(jsonValue, fieldType));
            }
            catch (Exception e) {
                JsonUtils.handleError(e, fieldName.getValue());
            }
        }
        return bStruct;
    }

    public static Object convertJSON(Object jsonValue, Type targetType) {
        switch (targetType.getTag()) {
            case 1: {
                return JsonUtils.jsonNodeToInt(jsonValue);
            }
            case 3: {
                return JsonUtils.jsonNodeToFloat(jsonValue);
            }
            case 4: {
                return JsonUtils.jsonNodeToDecimal(jsonValue);
            }
            case 5: {
                if (jsonValue instanceof BString) {
                    return jsonValue;
                }
                return jsonValue.toString();
            }
            case 6: {
                return JsonUtils.jsonNodeToBoolean(jsonValue);
            }
            case 7: {
                if (jsonValue != null && !TypeChecker.checkIsType(jsonValue, targetType)) {
                    throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE, targetType, JsonUtils.getTypeName(jsonValue));
                }
            }
            case 17: {
                return jsonValue;
            }
            case 21: {
                BUnionType type = (BUnionType)targetType;
                if (jsonValue == null && type.isNullable()) {
                    return null;
                }
                List matchingTypes = type.getMemberTypes().stream().filter(memberType -> memberType != PredefinedTypes.TYPE_NULL).collect(Collectors.toList());
                if (matchingTypes.size() != 1) break;
                return JsonUtils.convertJSON(jsonValue, (Type)matchingTypes.get(0));
            }
            case 12: 
            case 35: {
                return JsonUtils.convertJSONToRecord(jsonValue, (BStructureType)targetType);
            }
            case 20: {
                return JsonUtils.convertJSONToBArray(jsonValue, (BArrayType)targetType);
            }
            case 15: {
                return JsonUtils.jsonToMap(jsonValue, (BMapType)targetType);
            }
            case 10: {
                if (jsonValue == null) {
                    return null;
                }
            }
            default: {
                throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE, targetType, JsonUtils.getTypeName(jsonValue));
            }
        }
        throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE, targetType, JsonUtils.getTypeName(jsonValue));
    }

    public static ArrayValue getKeys(Object json) {
        if (json == null || !JsonUtils.isJSONObject(json)) {
            return new ArrayValueImpl(new BArrayType(PredefinedTypes.TYPE_STRING));
        }
        BString[] keys = (BString[])((MapValueImpl)json).getKeys();
        return new ArrayValueImpl(keys);
    }

    public static Object convertUnionTypeToJSON(Object source, JsonType targetType) {
        if (source == null) {
            return null;
        }
        Type type = TypeChecker.getType(source);
        switch (type.getTag()) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return source;
            }
            case 10: {
                return null;
            }
            case 12: 
            case 15: 
            case 35: {
                return JsonUtils.convertMapToJSON((MapValueImpl)source, targetType);
            }
            case 7: {
                return source;
            }
        }
        throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE, PredefinedTypes.TYPE_JSON, type);
    }

    public static void remove(Object json, BString fieldName) {
        if (!JsonUtils.isJSONObject(json)) {
            return;
        }
        ((MapValueImpl)json).remove(fieldName);
    }

    public static BError getErrorIfUnmergeable(Object j1, Object j2, List<ObjectPair> visitedPairs) {
        if (j1 == null || j2 == null) {
            return null;
        }
        Type j1Type = TypeChecker.getType(j1);
        Type j2Type = TypeChecker.getType(j2);
        if (j1Type.getTag() != 15 || j2Type.getTag() != 15) {
            return ErrorCreator.createError(BallerinaErrorReasons.MERGE_JSON_ERROR, StringUtils.fromString("Cannot merge JSON values of types '" + j1Type + "' and '" + j2Type + "'"));
        }
        ObjectPair currentPair = new ObjectPair(j1, j2);
        if (visitedPairs.contains(currentPair)) {
            return ErrorCreator.createError(BallerinaErrorReasons.MERGE_JSON_ERROR, StringUtils.fromString("Cannot merge JSON values with cyclic references"));
        }
        visitedPairs.add(currentPair);
        MapValue m1 = (MapValue)j1;
        MapValue m2 = (MapValue)j2;
        for (Map.Entry entry : m2.entrySet()) {
            BError elementMergeNullableError;
            BString key = (BString)entry.getKey();
            if (!m1.containsKey(key) || (elementMergeNullableError = JsonUtils.getErrorIfUnmergeable(m1.get(key), entry.getValue(), visitedPairs)) == null) continue;
            BMapInitialValueEntry[] initialValues = new MappingInitialValueEntry[]{new MappingInitialValueEntry.KeyValueEntry(TypeConstants.DETAIL_MESSAGE, StringUtils.fromString("JSON Merge failed for key '" + key + "'")), new MappingInitialValueEntry.KeyValueEntry(TypeConstants.DETAIL_CAUSE, elementMergeNullableError)};
            MapValueImpl<BString, Object> detailMap = new MapValueImpl<BString, Object>(PredefinedTypes.TYPE_ERROR_DETAIL, initialValues);
            return ErrorCreator.createError(BallerinaErrorReasons.MERGE_JSON_ERROR, detailMap);
        }
        return null;
    }

    public static Object mergeJson(Object j1, Object j2, boolean checkMergeability) {
        if (j1 == null) {
            return j2;
        }
        if (j2 == null) {
            return j1;
        }
        if (checkMergeability) {
            Type j1Type = TypeChecker.getType(j1);
            Type j2Type = TypeChecker.getType(j2);
            if (j1Type.getTag() != 15 || j2Type.getTag() != 15) {
                return ErrorCreator.createError(BallerinaErrorReasons.MERGE_JSON_ERROR, StringUtils.fromString("Cannot merge JSON values of types '" + j1Type + "' and '" + j2Type + "'"));
            }
        }
        MapValue m1 = (MapValue)j1;
        MapValue m2 = (MapValue)j2;
        return m1.merge(m2, true);
    }

    public static ArrayValue convertJSONToBArray(Object json, BArrayType targetArrayType) {
        if (!(json instanceof ArrayValue)) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE, JsonUtils.getComplexObjectTypeName(ARRAY), JsonUtils.getTypeName(json));
        }
        Type targetElementType = targetArrayType.getElementType();
        ArrayValue jsonArray = (ArrayValue)json;
        switch (targetElementType.getTag()) {
            case 1: {
                return JsonUtils.jsonArrayToBIntArray(jsonArray);
            }
            case 3: {
                return JsonUtils.jsonArrayToBFloatArray(jsonArray);
            }
            case 4: {
                return JsonUtils.jsonArrayToBDecimalArray(jsonArray);
            }
            case 5: {
                return JsonUtils.jsonArrayToBStringArray(jsonArray);
            }
            case 6: {
                return JsonUtils.jsonArrayToBooleanArray(jsonArray);
            }
            case 17: {
                ArrayValueImpl array = new ArrayValueImpl(targetArrayType);
                for (int i = 0; i < jsonArray.size(); ++i) {
                    array.add((long)i, jsonArray.getRefValue(i));
                }
                return array;
            }
        }
        ArrayValueImpl array = new ArrayValueImpl(targetArrayType);
        for (int i = 0; i < jsonArray.size(); ++i) {
            array.append(JsonUtils.convertJSON(jsonArray.getRefValue(i), targetElementType));
        }
        return array;
    }

    public static Object toJSON(BTable table) {
        TableJsonDataSource jsonDataSource = new TableJsonDataSource(table);
        return jsonDataSource.build();
    }

    public static BError createJsonConversionError(Throwable throwable, String prefix) {
        BString detail = StringUtils.fromString((String)(throwable.getMessage() != null ? prefix + ": " + throwable.getMessage() : "error occurred in JSON Conversion"));
        return ErrorCreator.createError(BallerinaErrorReasons.JSON_CONVERSION_ERROR, detail);
    }

    private static long jsonNodeToInt(Object json) {
        if (!(json instanceof Long)) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE_FOR_CASTING_JSON, PredefinedTypes.TYPE_INT, JsonUtils.getTypeName(json));
        }
        return (Long)json;
    }

    private static double jsonNodeToFloat(Object json) {
        if (json instanceof Integer) {
            return ((Integer)json).longValue();
        }
        if (json instanceof Double) {
            return (Double)json;
        }
        if (json instanceof DecimalValue) {
            return ((DecimalValue)json).floatValue();
        }
        throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE_FOR_CASTING_JSON, PredefinedTypes.TYPE_FLOAT, JsonUtils.getTypeName(json));
    }

    private static DecimalValue jsonNodeToDecimal(Object json) {
        BigDecimal decimal;
        if (json instanceof Integer) {
            decimal = new BigDecimal(((Integer)json).longValue());
        } else if (json instanceof Double) {
            decimal = BigDecimal.valueOf((Double)json);
        } else if (json instanceof BigDecimal) {
            decimal = (BigDecimal)json;
        } else {
            if (json instanceof DecimalValue) {
                return (DecimalValue)json;
            }
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE_FOR_CASTING_JSON, PredefinedTypes.TYPE_DECIMAL, JsonUtils.getTypeName(json));
        }
        return new DecimalValue(decimal);
    }

    private static boolean jsonNodeToBoolean(Object json) {
        if (!(json instanceof Boolean)) {
            throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE_FOR_CASTING_JSON, PredefinedTypes.TYPE_BOOLEAN, JsonUtils.getTypeName(json));
        }
        return (Boolean)json;
    }

    private static ArrayValue jsonArrayToBIntArray(ArrayValue arrayNode) {
        ArrayValueImpl intArray = new ArrayValueImpl(new BArrayType(PredefinedTypes.TYPE_INT));
        for (int i = 0; i < arrayNode.size(); ++i) {
            Object jsonValue = arrayNode.getRefValue(i);
            intArray.add((long)i, JsonUtils.jsonNodeToInt(jsonValue));
        }
        return intArray;
    }

    private static ArrayValue jsonArrayToBFloatArray(ArrayValue arrayNode) {
        ArrayValueImpl floatArray = new ArrayValueImpl(new BArrayType(PredefinedTypes.TYPE_FLOAT));
        for (int i = 0; i < arrayNode.size(); ++i) {
            Object jsonValue = arrayNode.getRefValue(i);
            floatArray.add((long)i, JsonUtils.jsonNodeToFloat(jsonValue));
        }
        return floatArray;
    }

    private static ArrayValue jsonArrayToBDecimalArray(ArrayValue arrayNode) {
        ArrayValueImpl decimalArray = new ArrayValueImpl(new BArrayType(PredefinedTypes.TYPE_DECIMAL));
        for (int i = 0; i < arrayNode.size(); ++i) {
            Object jsonValue = arrayNode.getRefValue(i);
            decimalArray.add((long)i, JsonUtils.jsonNodeToDecimal(jsonValue));
        }
        return decimalArray;
    }

    private static ArrayValue jsonArrayToBStringArray(ArrayValue arrayNode) {
        ArrayValueImpl stringArray = new ArrayValueImpl(new BArrayType(PredefinedTypes.TYPE_STRING));
        for (int i = 0; i < arrayNode.size(); ++i) {
            stringArray.add((long)i, arrayNode.getRefValue(i).toString());
        }
        return stringArray;
    }

    private static ArrayValue jsonArrayToBooleanArray(ArrayValue arrayNode) {
        ArrayValueImpl booleanArray = new ArrayValueImpl(new BArrayType(PredefinedTypes.TYPE_BOOLEAN));
        for (int i = 0; i < arrayNode.size(); ++i) {
            Object jsonValue = arrayNode.getRefValue(i);
            booleanArray.add((long)i, JsonUtils.jsonNodeToBoolean(jsonValue));
        }
        return booleanArray;
    }

    private static ArrayValue convertRefArrayToJSON(BArray refValueArray) {
        ArrayValueImpl json = new ArrayValueImpl(new BArrayType(PredefinedTypes.TYPE_JSON));
        block5: for (int i = 0; i < refValueArray.size(); ++i) {
            Object value = refValueArray.getRefValue(i);
            if (value == null) {
                json.append(null);
            }
            Type type = TypeChecker.getType(value);
            switch (type.getTag()) {
                case 7: {
                    json.append(value);
                    continue block5;
                }
                case 12: 
                case 15: 
                case 35: {
                    json.append(JsonUtils.convertMapToJSON((MapValueImpl)value, (BJsonType)PredefinedTypes.TYPE_JSON));
                    continue block5;
                }
                case 20: {
                    json.append(JsonUtils.convertArrayToJSON((ArrayValue)value));
                    continue block5;
                }
                default: {
                    throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE, PredefinedTypes.TYPE_JSON, type);
                }
            }
        }
        return json;
    }

    private static ArrayValue convertIntArrayToJSON(BArray intArray) {
        ArrayValueImpl json = new ArrayValueImpl(new BArrayType(PredefinedTypes.TYPE_JSON));
        for (int i = 0; i < intArray.size(); ++i) {
            long value = intArray.getInt(i);
            json.append(value);
        }
        return json;
    }

    private static ArrayValue convertFloatArrayToJSON(BArray floatArray) {
        ArrayValueImpl json = new ArrayValueImpl(new BArrayType(PredefinedTypes.TYPE_JSON));
        for (int i = 0; i < floatArray.size(); ++i) {
            double value = floatArray.getFloat(i);
            json.append(value);
        }
        return json;
    }

    private static ArrayValue convertStringArrayToJSON(BArray stringArray) {
        ArrayValueImpl json = new ArrayValueImpl(new BArrayType(PredefinedTypes.TYPE_JSON));
        for (int i = 0; i < stringArray.size(); ++i) {
            json.append(stringArray.getString(i));
        }
        return json;
    }

    private static ArrayValue convertBooleanArrayToJSON(BArray booleanArray) {
        ArrayValueImpl json = new ArrayValueImpl(new BArrayType(PredefinedTypes.TYPE_JSON));
        for (int i = 0; i < booleanArray.size(); ++i) {
            boolean value = booleanArray.getBoolean(i);
            json.append(value);
        }
        return json;
    }

    private static void populateJSON(BMap<BString, Object> json, BString key, Object value, Type exptType) {
        try {
            if (value == null) {
                json.put(key, null);
                return;
            }
            Type type = TypeChecker.getType(value);
            switch (type.getTag()) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    json.put(key, value);
                    break;
                }
                case 20: {
                    json.put(key, JsonUtils.convertArrayToJSON((ArrayValue)value));
                    break;
                }
                case 12: 
                case 15: 
                case 35: {
                    json.put(key, JsonUtils.convertMapToJSON((MapValueImpl)value, (BJsonType)exptType));
                    break;
                }
                default: {
                    throw BLangExceptionHelper.getRuntimeException(RuntimeErrors.INCOMPATIBLE_TYPE, PredefinedTypes.TYPE_JSON, type);
                }
            }
        }
        catch (Exception e) {
            JsonUtils.handleError(e, key.getValue());
        }
    }

    private static String getTypeName(Object jsonValue) {
        if (jsonValue == null) {
            return PredefinedTypes.TYPE_NULL.toString();
        }
        return TypeChecker.getType(jsonValue).toString();
    }

    private static String getComplexObjectTypeName(String nodeType) {
        return "json-" + nodeType;
    }

    private static void handleError(Exception e, String fieldName) {
        Object errorMsg = e.getCause() == null ? "error while mapping '" + fieldName + "': " : "";
        throw new BallerinaException((String)errorMsg + e.getMessage(), e);
    }

    private static class ObjectPair {
        Object lhsObject;
        Object rhsObject;

        public ObjectPair(Object lhsObject, Object rhsObject) {
            this.lhsObject = lhsObject;
            this.rhsObject = rhsObject;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ObjectPair)) {
                return false;
            }
            ObjectPair other = (ObjectPair)obj;
            return this.lhsObject == other.lhsObject && this.rhsObject == other.rhsObject;
        }
    }
}

