/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.types.BMapType;
import io.ballerina.runtime.internal.types.BRecordType;
import io.ballerina.runtime.internal.util.exceptions.BLangExceptionHelper;
import io.ballerina.runtime.internal.util.exceptions.BallerinaErrorReasons;
import io.ballerina.runtime.internal.util.exceptions.RuntimeErrors;
import io.ballerina.runtime.internal.values.MapValue;

public class MapUtils {
    public static void handleMapStore(MapValue<BString, Object> mapValue, BString fieldName, Object value) {
        Type mapType = mapValue.getType();
        switch (mapType.getTag()) {
            case 15: {
                MapUtils.handleInherentTypeViolatingMapUpdate(value, (BMapType)mapType);
                mapValue.put(fieldName, value);
                break;
            }
            case 12: {
                MapUtils.handleInherentTypeViolatingRecordUpdate(mapValue, fieldName, value, (BRecordType)mapType, false);
                mapValue.put(fieldName, value);
            }
        }
    }

    public static void handleInherentTypeViolatingMapUpdate(Object value, BMapType mapType) {
        if (TypeChecker.checkIsType(value, mapType.getConstrainedType())) {
            return;
        }
        Type expType = mapType.getConstrainedType();
        Type valuesType = TypeChecker.getType(value);
        throw ErrorCreator.createError(BallerinaErrorReasons.getModulePrefixedReason("lang.map", "InherentTypeViolation"), BLangExceptionHelper.getErrorMessage(RuntimeErrors.INVALID_MAP_INSERTION, expType, valuesType));
    }

    public static void handleInherentTypeViolatingRecordUpdate(MapValue mapValue, BString fieldName, Object value, BRecordType recType, boolean initialValue) {
        Type recFieldType;
        Field recField = recType.getFields().get(fieldName.getValue());
        if (recField != null) {
            if (!initialValue && SymbolFlags.isFlagOn(recField.getFlags(), 32L)) {
                throw ErrorCreator.createError(BallerinaErrorReasons.getModulePrefixedReason("lang.map", "InherentTypeViolation"), BLangExceptionHelper.getErrorMessage(RuntimeErrors.RECORD_INVALID_READONLY_FIELD_UPDATE, fieldName, recType));
            }
            recFieldType = recField.getFieldType();
        } else if (recType.restFieldType != null) {
            recFieldType = recType.restFieldType;
        } else {
            throw ErrorCreator.createError(BallerinaErrorReasons.MAP_KEY_NOT_FOUND_ERROR, BLangExceptionHelper.getErrorMessage(RuntimeErrors.INVALID_RECORD_FIELD_ACCESS, fieldName, recType));
        }
        if (TypeChecker.checkIsType(value, recFieldType)) {
            return;
        }
        Type valuesType = TypeChecker.getType(value);
        throw ErrorCreator.createError(BallerinaErrorReasons.getModulePrefixedReason("lang.map", "InherentTypeViolation"), BLangExceptionHelper.getErrorMessage(RuntimeErrors.INVALID_RECORD_FIELD_ADDITION, fieldName, recFieldType, valuesType));
    }

    public static BError createOpNotSupportedError(Type type, String op) {
        return ErrorCreator.createError(BallerinaErrorReasons.getModulePrefixedReason("lang.map", "OperationNotSupported"), StringUtils.fromString(String.format("%s not supported on type '%s'", op, type.getQualifiedName())));
    }

    public static void checkIsMapOnlyOperation(Type mapType, String op) {
        switch (mapType.getTag()) {
            case 7: 
            case 12: 
            case 15: {
                return;
            }
        }
        throw MapUtils.createOpNotSupportedError(mapType, op);
    }
}

