/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal;

import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.types.BField;
import io.ballerina.runtime.internal.types.BStructureType;
import io.ballerina.runtime.internal.util.exceptions.BallerinaException;
import io.ballerina.runtime.internal.values.DecimalValue;
import io.ballerina.runtime.internal.values.IteratorValue;
import io.ballerina.runtime.internal.values.MapValueImpl;
import io.ballerina.runtime.internal.values.TableValueImpl;
import io.ballerina.runtime.internal.values.TupleValueImpl;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.ds.AbstractPushOMDataSource;

public class TableOmDataSource
extends AbstractPushOMDataSource {
    private static final String XSI_NAMESPACE = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String XSI_PREFIX = "xsi";
    private static final String ARRAY_ELEMENT_NAME = "element";
    private static final String DEFAULT_ROOT_WRAPPER = "results";
    private static final String DEFAULT_ROW_WRAPPER = "result";
    private TableValueImpl table;
    private String rootWrapper;
    private String rowWrapper;

    public TableOmDataSource(TableValueImpl table, String rootWrapper, String rowWrapper) {
        this.table = table;
        this.rootWrapper = rootWrapper != null ? rootWrapper : DEFAULT_ROOT_WRAPPER;
        this.rowWrapper = rowWrapper != null ? rowWrapper : DEFAULT_ROW_WRAPPER;
    }

    @Override
    public void serialize(XMLStreamWriter xmlStreamWriter) throws XMLStreamException {
        xmlStreamWriter.writeStartElement("", this.rootWrapper, "");
        IteratorValue itr = this.table.getIterator();
        while (itr.hasNext()) {
            this.table.getIterator().next();
            xmlStreamWriter.writeStartElement("", this.rowWrapper, "");
            TupleValueImpl tupleValue = (TupleValueImpl)itr.next();
            MapValueImpl record = (MapValueImpl)tupleValue.get(0L);
            BStructureType structType = (BStructureType)record.getType();
            BField[] structFields = null;
            if (structType != null) {
                structFields = structType.getFields().values().toArray(new BField[0]);
            }
            for (int i = 0; i < structFields.length; ++i) {
                BField internalStructField = structFields[i];
                int type = internalStructField.getFieldType().getTag();
                String fieldName = internalStructField.getFieldName();
                this.writeElement(record, xmlStreamWriter, fieldName, type, i, structFields);
            }
            xmlStreamWriter.writeEndElement();
        }
        xmlStreamWriter.writeEndElement();
        xmlStreamWriter.flush();
    }

    private void writeElement(MapValueImpl record, XMLStreamWriter xmlStreamWriter, String name, int type, int index, BField[] structFields) throws XMLStreamException {
        boolean isArray = false;
        xmlStreamWriter.writeStartElement("", name, "");
        BString key = StringUtils.fromString(name);
        String value = null;
        switch (type) {
            case 6: {
                value = String.valueOf(record.getBooleanValue(key));
                break;
            }
            case 5: {
                value = String.valueOf(record.getStringValue(key));
                break;
            }
            case 1: {
                value = String.valueOf(record.getIntValue(key));
                break;
            }
            case 3: {
                value = String.valueOf(record.getFloatValue(key));
                break;
            }
            case 4: {
                DecimalValue decimalVal = (DecimalValue)record.get(key);
                value = String.valueOf(decimalVal);
                break;
            }
            case 20: {
                isArray = true;
                BArray array = record.getArrayValue(key);
                this.processArray(xmlStreamWriter, array);
                break;
            }
            case 12: 
            case 35: {
                isArray = true;
                if (structFields == null) {
                    BArray structData = record.getArrayValue(key);
                    this.processArray(xmlStreamWriter, structData);
                    break;
                }
                BMap<?, ?> structData = record.getMapValue(key);
                this.processStruct(xmlStreamWriter, structData, structFields, index);
                break;
            }
            default: {
                value = String.valueOf(record.getStringValue(key));
            }
        }
        if (!isArray) {
            if (value == null) {
                xmlStreamWriter.writeNamespace(XSI_PREFIX, XSI_NAMESPACE);
                xmlStreamWriter.writeAttribute(XSI_PREFIX, XSI_NAMESPACE, "nil", "true");
            } else {
                xmlStreamWriter.writeCharacters(value);
            }
        }
        xmlStreamWriter.writeEndElement();
    }

    private void processArray(XMLStreamWriter xmlStreamWriter, BArray array) throws XMLStreamException {
        if (array != null) {
            for (int i = 0; i < array.size(); ++i) {
                xmlStreamWriter.writeStartElement("", ARRAY_ELEMENT_NAME, "");
                xmlStreamWriter.writeCharacters(String.valueOf(array.get(i)));
                xmlStreamWriter.writeEndElement();
            }
        }
    }

    private void processStruct(XMLStreamWriter xmlStreamWriter, BMap structData, BField[] structFields, int index) throws XMLStreamException {
        BField[] internalStructFields;
        boolean structError = true;
        Type internalType = structFields[index].getFieldType();
        if ((internalType.getTag() == 35 || internalType.getTag() == 12) && (internalStructFields = ((BStructureType)internalType).getFields().values().toArray(new BField[0])) != null) {
            for (int i = 0; i < internalStructFields.length; ++i) {
                BString internalKeyName = StringUtils.fromString(internalStructFields[i].name);
                Object val = structData.get(internalKeyName);
                xmlStreamWriter.writeStartElement("", internalStructFields[i].getFieldName(), "");
                if (val instanceof MapValueImpl) {
                    this.processStruct(xmlStreamWriter, (MapValueImpl)val, internalStructFields, i);
                } else {
                    xmlStreamWriter.writeCharacters(val.toString());
                }
                xmlStreamWriter.writeEndElement();
            }
            structError = false;
        }
        if (structError) {
            throw new BallerinaException("error in constructing the xml element from struct type data");
        }
    }

    @Override
    public boolean isDestructiveWrite() {
        return true;
    }
}

