/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.scheduling.Scheduler;
import io.ballerina.runtime.internal.scheduling.State;
import io.ballerina.runtime.internal.scheduling.Strand;
import io.ballerina.runtime.internal.types.BRecordType;
import io.ballerina.runtime.internal.values.MapValueImpl;
import io.ballerina.runtime.internal.values.ValueCreator;
import java.util.Map;

public class ValueUtils {
    public static BMap<BString, Object> createRecordValue(Module packageId, String recordTypeName) {
        ValueCreator valueCreator = ValueCreator.getValueCreator(packageId.toString());
        return valueCreator.createRecordValue(recordTypeName);
    }

    public static BMap<BString, Object> createRecordValue(Module packageId, String recordTypeName, Map<String, Object> valueMap) {
        BMap<BString, Object> record = ValueUtils.createRecordValue(packageId, recordTypeName);
        for (Map.Entry<String, Object> fieldEntry : valueMap.entrySet()) {
            Object val = fieldEntry.getValue();
            if (val instanceof String) {
                val = StringUtils.fromString((String)val);
            }
            record.put(StringUtils.fromString(fieldEntry.getKey()), val);
        }
        return record;
    }

    public static BMap<BString, Object> createRecordValue(BMap<BString, Object> record, Object ... values) {
        BRecordType recordType = (BRecordType)record.getType();
        MapValueImpl<BString, Object> mapValue = new MapValueImpl<BString, Object>(recordType);
        int i = 0;
        for (Map.Entry<String, Field> fieldEntry : recordType.getFields().entrySet()) {
            Object value = values[i++];
            if (SymbolFlags.isFlagOn(fieldEntry.getValue().getFlags(), 4096L) && value == null) continue;
            mapValue.put(StringUtils.fromString(fieldEntry.getKey()), value instanceof String ? StringUtils.fromString((String)value) : value);
        }
        return mapValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BObject createObjectValue(Module packageId, String objectTypeName, Object ... fieldValues) {
        BObject objectValue;
        Strand currentStrand = ValueUtils.getStrand();
        ValueCreator valueCreator = ValueCreator.getValueCreator(packageId.toString());
        Object[] fields = new Object[fieldValues.length * 2];
        Scheduler scheduler = null;
        State prevState = State.RUNNABLE;
        boolean prevBlockedOnExtern = false;
        int j = 0;
        for (int i = 0; i < fieldValues.length; ++i) {
            fields[j++] = fieldValues[i];
            fields[j++] = true;
        }
        try {
            if (currentStrand != null) {
                scheduler = currentStrand.scheduler;
                prevBlockedOnExtern = currentStrand.blockedOnExtern;
                prevState = currentStrand.getState();
                currentStrand.blockedOnExtern = false;
                currentStrand.setState(State.RUNNABLE);
            }
            objectValue = valueCreator.createObjectValue(objectTypeName, scheduler, currentStrand, null, fields);
        }
        finally {
            if (currentStrand != null) {
                currentStrand.blockedOnExtern = prevBlockedOnExtern;
                currentStrand.setState(prevState);
            }
        }
        return objectValue;
    }

    private static Strand getStrand() {
        try {
            return Scheduler.getStrand();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

