/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.configurable;

import com.moandjiezana.toml.Toml;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.internal.configurable.ConfigurableMap;
import io.ballerina.runtime.internal.configurable.VariableKey;
import io.ballerina.runtime.internal.configurable.exceptions.TomlException;
import io.ballerina.runtime.internal.util.RuntimeUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;

public class TomlParser {
    static final Path CONFIG_FILE_PATH = Paths.get(RuntimeUtils.USER_DIR, new String[0]).resolve("configuration.toml");

    private static Toml getConfigurationData() throws TomlException {
        if (!Files.exists(CONFIG_FILE_PATH, new LinkOption[0])) {
            throw new TomlException("Configuration toml file `configuration.toml` is not found");
        }
        try {
            return new Toml().read(CONFIG_FILE_PATH.toFile());
        }
        catch (RuntimeException exception) {
            throw new TomlException("Invalid `configuration.toml` file : " + exception.getCause().getMessage());
        }
    }

    public static void populateConfigMap(Map<Module, VariableKey[]> configurationData) throws TomlException {
        if (configurationData.isEmpty()) {
            return;
        }
        Toml toml = TomlParser.getConfigurationData();
        if (toml.isEmpty()) {
            return;
        }
        block0: for (Map.Entry<Module, VariableKey[]> moduleEntry : configurationData.entrySet()) {
            String orgName = moduleEntry.getKey().getOrg();
            String moduleName = moduleEntry.getKey().getName();
            Toml orgToml = orgName.equals("$anon") ? toml : TomlParser.extractOrganizationTable(toml, orgName);
            Toml moduleToml = moduleName.equals(".") ? orgToml : TomlParser.extractModuleTable(orgToml, moduleName);
            for (VariableKey key : moduleEntry.getValue()) {
                if (!moduleToml.contains(key.variable)) continue block0;
                Object value = TomlParser.validateAndExtractValue(key, moduleToml);
                ConfigurableMap.put(key, value);
            }
        }
    }

    private static Object validateAndExtractValue(VariableKey key, Toml moduleToml) throws TomlException {
        Object value;
        String variableName = key.variable;
        Type type = key.type;
        try {
            switch (type.getTag()) {
                case 1: {
                    value = moduleToml.getLong(variableName);
                    break;
                }
                case 6: {
                    value = moduleToml.getBoolean(variableName);
                    break;
                }
                case 3: {
                    value = moduleToml.getDouble(variableName);
                    break;
                }
                case 5: {
                    value = StringUtils.fromString(moduleToml.getString(variableName));
                    break;
                }
                default: {
                    throw new TomlException(String.format("Configurable feature is yet to be supported for type '%s'", type.toString()));
                }
            }
        }
        catch (ClassCastException e) {
            throw new TomlException("Invalid `configuration.toml` file : " + String.format("invalid type found for variable '%s', expected type is '%s'", variableName, type.toString()));
        }
        return value;
    }

    private static Toml extractModuleTable(Toml modules, String module) {
        Toml moduleToml = modules;
        int subModuleIndex = module.indexOf(".");
        if (subModuleIndex == -1) {
            moduleToml = modules.getTable(module);
        } else if (subModuleIndex != module.length()) {
            String parent = module.substring(0, subModuleIndex);
            String submodule = module.substring(subModuleIndex + 1);
            moduleToml = TomlParser.extractModuleTable(moduleToml.getTable(parent), submodule);
        }
        return moduleToml;
    }

    private static Toml extractOrganizationTable(Toml toml, String orgName) throws TomlException {
        if (!toml.contains(orgName)) {
            throw new TomlException("Invalid `configuration.toml` file : Organization name '" + orgName + "' not found.");
        }
        return toml.getTable(orgName);
    }
}

