/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.types.BType;
import io.ballerina.runtime.internal.values.ArrayValue;
import io.ballerina.runtime.internal.values.ArrayValueImpl;

public class BArrayType
extends BType
implements ArrayType {
    private Type elementType;
    private int dimensions = 1;
    private int size = -1;
    private boolean hasFillerValue;
    private ArrayType.ArrayState state = ArrayType.ArrayState.OPEN;
    private final boolean readonly;
    private IntersectionType immutableType;

    public BArrayType(Type elementType) {
        this(elementType, false);
    }

    public BArrayType(Type elementType, boolean readonly) {
        super(null, null, ArrayValue.class);
        this.elementType = elementType;
        if (elementType instanceof BArrayType) {
            this.dimensions = ((BArrayType)elementType).getDimensions() + 1;
        }
        this.hasFillerValue = TypeChecker.hasFillerValue(this.elementType);
        this.readonly = readonly;
    }

    public BArrayType(Type elemType, int size) {
        this(elemType, size, false);
    }

    public BArrayType(Type elemType, int size, boolean readonly) {
        super(null, null, ArrayValue.class);
        this.elementType = elemType;
        if (this.elementType instanceof BArrayType) {
            this.dimensions = ((BArrayType)this.elementType).getDimensions() + 1;
        }
        if (size != -1) {
            this.state = ArrayType.ArrayState.CLOSED;
            this.size = size;
        }
        this.hasFillerValue = TypeChecker.hasFillerValue(this.elementType);
        this.readonly = readonly;
    }

    @Override
    public Type getElementType() {
        return this.elementType;
    }

    @Override
    public <V> V getZeroValue() {
        if (this.size == -1) {
            return this.getEmptyValue();
        }
        int tag = this.elementType.getTag();
        switch (tag) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return (V)new ArrayValueImpl(new BArrayType(this.elementType), this.size);
            }
        }
        return (V)new ArrayValueImpl(this);
    }

    @Override
    public <V> V getEmptyValue() {
        int tag = this.elementType.getTag();
        switch (tag) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return (V)new ArrayValueImpl(new BArrayType(this.elementType));
            }
        }
        return (V)new ArrayValueImpl(this);
    }

    @Override
    public int getTag() {
        return 20;
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BArrayType) {
            BArrayType other = (BArrayType)obj;
            if (other.state == ArrayType.ArrayState.CLOSED && this.size != other.size) {
                return false;
            }
            return this.elementType.equals(other.elementType) && this.readonly == other.readonly;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        Type tempElementType = this.elementType;
        sb.append(this.getSizeString());
        while (tempElementType.getTag() == 20) {
            BArrayType arrayElement = (BArrayType)tempElementType;
            sb.append(arrayElement.getSizeString());
            tempElementType = arrayElement.elementType;
        }
        if (tempElementType.getTag() == 21) {
            sb.insert(0, "(" + tempElementType.toString() + ")").toString();
        } else {
            sb.insert(0, tempElementType.toString()).toString();
        }
        return !this.readonly ? sb.toString() : sb.append(" & readonly").toString();
    }

    private String getSizeString() {
        return this.size != -1 ? "[" + this.size + "]" : "[]";
    }

    public int getDimensions() {
        return this.dimensions;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public boolean hasFillerValue() {
        return this.hasFillerValue;
    }

    @Override
    public ArrayType.ArrayState getState() {
        return this.state;
    }

    @Override
    public boolean isAnydata() {
        return this.elementType.isPureType();
    }

    @Override
    public boolean isReadOnly() {
        return this.readonly;
    }

    @Override
    public Type getImmutableType() {
        return this.immutableType;
    }

    @Override
    public void setImmutableType(IntersectionType immutableType) {
        this.immutableType = immutableType;
    }
}

