/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.PredefinedTypes;
import io.ballerina.runtime.api.types.StreamType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.internal.types.BType;
import io.ballerina.runtime.internal.values.StreamValue;

public class BStreamType
extends BType
implements StreamType {
    private Type constraint;

    public BStreamType(String typeName, Type constraint, Module pkgPath) {
        super(typeName, pkgPath, StreamValue.class);
        this.constraint = constraint;
    }

    public BStreamType(Type constraint) {
        super("stream", null, StreamValue.class);
        this.constraint = constraint;
    }

    @Override
    public Type getConstrainedType() {
        return this.constraint;
    }

    @Override
    public <V> V getZeroValue() {
        return (V)new StreamValue(this);
    }

    @Override
    public <V> V getEmptyValue() {
        return null;
    }

    @Override
    public int getTag() {
        return 14;
    }

    @Override
    public String toString() {
        if (this.constraint == PredefinedTypes.TYPE_ANY) {
            return super.toString();
        }
        return "stream<" + this.constraint.getName() + ">";
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj) || !(obj instanceof BStreamType)) {
            return false;
        }
        BStreamType other = (BStreamType)obj;
        if (this.constraint == other.constraint) {
            return true;
        }
        if (this.constraint == null || other.constraint == null) {
            return false;
        }
        return this.constraint.equals(other.constraint);
    }
}

