/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.TableType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.internal.types.BType;
import io.ballerina.runtime.internal.values.TableValue;
import io.ballerina.runtime.internal.values.TableValueImpl;

public class BTableType
extends BType
implements TableType {
    private Type constraint;
    private Type keyType;
    private String[] fieldNames;
    private final boolean readonly;
    private IntersectionType immutableType;

    public BTableType(Type constraint, String[] fieldNames, boolean readonly) {
        super("table", null, TableValue.class);
        this.constraint = constraint;
        this.fieldNames = fieldNames;
        this.keyType = null;
        this.readonly = readonly;
    }

    public BTableType(Type constraint, Type keyType, boolean readonly) {
        super("table", null, TableValue.class);
        this.constraint = constraint;
        this.keyType = keyType;
        this.readonly = readonly;
    }

    public BTableType(Type constraint, boolean readonly) {
        super("table", null, TableValue.class);
        this.constraint = constraint;
        this.readonly = readonly;
    }

    @Override
    public Type getConstrainedType() {
        return this.constraint;
    }

    public Type getKeyType() {
        return this.keyType;
    }

    @Override
    public String[] getFieldNames() {
        return this.fieldNames;
    }

    @Override
    public <V> V getZeroValue() {
        return (V)new TableValueImpl(new BTableType(this.constraint, this.readonly));
    }

    @Override
    public <V> V getEmptyValue() {
        return this.getZeroValue();
    }

    @Override
    public int getTag() {
        return 9;
    }

    @Override
    public String toString() {
        String stringRep;
        if (this.constraint == null) {
            return this.readonly ? super.toString().concat(" & readonly") : super.toString();
        }
        StringBuilder keyStringBuilder = new StringBuilder();
        if (this.fieldNames != null) {
            for (String fieldName : this.fieldNames) {
                if (!keyStringBuilder.toString().equals("")) {
                    keyStringBuilder.append(", ");
                }
                keyStringBuilder.append(fieldName);
            }
            stringRep = super.toString() + "<" + this.constraint.getName() + "> key(" + keyStringBuilder.toString() + ")";
        } else {
            stringRep = super.toString() + "<" + this.constraint.getName() + ">" + (String)(this.keyType != null ? " key<" + this.keyType + ">" : "");
        }
        return this.readonly ? stringRep.concat(" & readonly") : stringRep;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj) || !(obj instanceof BTableType)) {
            return false;
        }
        BTableType other = (BTableType)obj;
        if (this.constraint == other.constraint && this.keyType == other.keyType) {
            return true;
        }
        if (this.constraint == null || other.constraint == null) {
            return false;
        }
        if (this.keyType == null || other.keyType == null) {
            return false;
        }
        return this.constraint.equals(other.constraint) && this.keyType.equals(other.keyType);
    }

    @Override
    public boolean isReadOnly() {
        return this.readonly;
    }

    @Override
    public Type getImmutableType() {
        return this.immutableType;
    }

    @Override
    public void setImmutableType(IntersectionType immutableType) {
        this.immutableType = immutableType;
    }
}

