/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.flags.TypeFlags;
import io.ballerina.runtime.api.types.IntersectionType;
import io.ballerina.runtime.api.types.TupleType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.internal.types.BType;
import io.ballerina.runtime.internal.values.TupleValueImpl;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class BTupleType
extends BType
implements TupleType {
    private List<Type> tupleTypes;
    private Type restType;
    private int typeFlags;
    private final boolean readonly;
    private IntersectionType immutableType;

    public BTupleType(List<Type> typeList) {
        super(null, null, Object.class);
        this.tupleTypes = typeList;
        this.restType = null;
        boolean isAllMembersPure = true;
        for (Type memberType : this.tupleTypes) {
            isAllMembersPure &= memberType.isPureType();
        }
        if (isAllMembersPure) {
            this.typeFlags = TypeFlags.addToMask(this.typeFlags, 2, 4);
        }
        this.readonly = false;
    }

    public BTupleType(List<Type> typeList, int typeFlags) {
        super(null, null, Object.class);
        this.tupleTypes = typeList;
        this.restType = null;
        this.typeFlags = typeFlags;
        this.readonly = false;
    }

    public BTupleType(List<Type> typeList, Type restType, int typeFlags, boolean readonly) {
        super(null, null, Object.class);
        this.tupleTypes = typeList;
        this.restType = restType;
        this.typeFlags = typeFlags;
        this.readonly = readonly;
    }

    @Override
    public List<Type> getTupleTypes() {
        return this.tupleTypes;
    }

    @Override
    public Type getRestType() {
        return this.restType;
    }

    @Override
    public <V> V getZeroValue() {
        return (V)new TupleValueImpl(this);
    }

    @Override
    public <V> V getEmptyValue() {
        return this.getZeroValue();
    }

    @Override
    public int getTag() {
        return 32;
    }

    @Override
    public String toString() {
        List list = this.tupleTypes.stream().map(Type::toString).collect(Collectors.toList());
        if (!this.readonly) {
            return "[" + String.join((CharSequence)",", list) + "]";
        }
        return "[" + String.join((CharSequence)",", list) + "] & readonly";
    }

    @Override
    public String getName() {
        return this.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BTupleType)) {
            return false;
        }
        BTupleType that = (BTupleType)o;
        return this.readonly == that.readonly && Objects.equals(this.tupleTypes, that.tupleTypes);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.tupleTypes);
    }

    @Override
    public boolean isAnydata() {
        return TypeFlags.isFlagOn(this.typeFlags, 2);
    }

    @Override
    public boolean isPureType() {
        return TypeFlags.isFlagOn(this.typeFlags, 4);
    }

    @Override
    public int getTypeFlags() {
        return this.typeFlags;
    }

    @Override
    public boolean isReadOnly() {
        return this.readonly;
    }

    @Override
    public Type getImmutableType() {
        return this.immutableType;
    }

    @Override
    public void setImmutableType(IntersectionType immutableType) {
        this.immutableType = immutableType;
    }
}

