/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.types;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.types.TypeId;
import io.ballerina.runtime.api.types.TypeIdSet;
import java.util.ArrayList;
import java.util.List;

public class BTypeIdSet
implements TypeIdSet {
    List<TypeId> ids = new ArrayList<TypeId>();

    public void add(Module pkg, String name, boolean isPrimary) {
        this.ids.add(new BTypeId(pkg, name, isPrimary));
    }

    public boolean containsAll(BTypeIdSet other) {
        if (other == null) {
            return true;
        }
        for (TypeId id : other.ids) {
            boolean found = false;
            for (TypeId otherTypeId : this.ids) {
                if (!id.getName().equals(otherTypeId.getName()) || !id.getPkg().equals(otherTypeId.getPkg())) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<TypeId> getIds() {
        return this.ids;
    }

    public static class BTypeId
    implements TypeId {
        final Module pkg;
        final String name;
        final boolean isPrimary;

        public BTypeId(Module pkg, String name, boolean isPrimary) {
            this.pkg = pkg;
            this.name = name;
            this.isPrimary = isPrimary;
        }

        public int hashCode() {
            return this.pkg.hashCode() * 31 + this.name.hashCode() + (this.isPrimary ? 0 : 1);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof BTypeId) {
                BTypeId that = (BTypeId)obj;
                return this.name.equals(that.name) && this.pkg.equals(that.pkg);
            }
            return false;
        }

        @Override
        public Module getPkg() {
            return this.pkg;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isPrimary() {
            return this.isPrimary;
        }
    }
}

