/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.util;

import io.ballerina.runtime.api.constants.RuntimeConstants;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.internal.TypeConverter;
import io.ballerina.runtime.internal.types.BArrayType;
import io.ballerina.runtime.internal.util.DefaultLogFormatter;
import io.ballerina.runtime.internal.values.ArrayValue;
import io.ballerina.runtime.internal.values.ArrayValueImpl;
import io.ballerina.runtime.internal.values.ErrorValue;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class RuntimeUtils {
    private static final String CRASH_LOGGER = "b7a.log.crash";
    private static final String DEFAULT_CRASH_LOG_FILE = "ballerina-internal.log";
    private static final String ENCODING_PATTERN = "\\$(\\d{4})";
    private static PrintStream errStream = System.err;
    public static final String USER_DIR = System.getProperty("user.dir");
    public static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    private static Logger crashLogger = Logger.getLogger("b7a.log.crash");
    private static final PrintStream stderr = System.err;
    private static FileHandler handler;

    public static ArrayValue createVarArgsArray(String[] args, int index, BArrayType type) {
        ArrayValueImpl array = new ArrayValueImpl(type, type.getSize());
        for (int i = index; i < args.length; ++i) {
            RuntimeUtils.addToArray(type.getElementType(), args[i], array);
        }
        return array;
    }

    public static void addToArray(Type type, String value, ArrayValue array) {
        switch (type.getTag()) {
            case 5: {
                array.add((long)array.size(), value);
                break;
            }
            case 1: {
                array.add((long)array.size(), (Long)TypeConverter.convertValues(type, value));
                break;
            }
            case 3: {
                array.add((long)array.size(), (Double)TypeConverter.convertValues(type, value));
                break;
            }
            case 6: {
                array.add((long)array.size(), (Boolean)TypeConverter.convertValues(type, value));
                break;
            }
            case 2: {
                array.add((long)array.size(), ((Integer)TypeConverter.convertValues(type, value)).intValue());
                break;
            }
            default: {
                array.append(value);
            }
        }
    }

    public static boolean isByteLiteral(int intValue) {
        return intValue >= RuntimeConstants.BBYTE_MIN_VALUE && intValue <= RuntimeConstants.BBYTE_MAX_VALUE;
    }

    public static void handleRuntimeErrorsAndExit(Throwable throwable) {
        RuntimeUtils.handleRuntimeErrors(throwable);
        Runtime.getRuntime().exit(1);
    }

    public static void handleRuntimeErrors(Throwable throwable) {
        if (throwable instanceof ErrorValue) {
            errStream.println("error: " + ((ErrorValue)throwable).getPrintableStackTrace());
        } else {
            errStream.println("ballerina: Oh no, something really went wrong.\n\nThe `ballerina-internal.log` file located in the current directory\nwill indicate what the problem is.\nWe really appreciate it if you can share with us, the code\nthat broke Ballerina, together with this log file by creating a\nbug report in https://github.com/ballerina-platform/ballerina-lang/issues.\n");
            RuntimeUtils.silentlyLogBadSad(throwable);
        }
    }

    public static void handleRuntimeReturnValues(Object returnValue) {
        if (returnValue instanceof ErrorValue) {
            ErrorValue errorValue = (ErrorValue)returnValue;
            errStream.println("error: " + errorValue.getMessage() + Optional.ofNullable(errorValue.getDetails()).map(details -> " " + details).orElse(""));
            Runtime.getRuntime().exit(1);
        }
    }

    public static void handleInvalidOption(String arg) {
        RuntimeUtils.handleUsageError("value for option '--' (<String=String>) should be in KEY=VALUE format but was " + arg);
    }

    public static void handleInvalidConfig() {
        RuntimeUtils.handleUsageError("value for option 'config' is missing");
    }

    public static void handleUsageError(String errorMsg) {
        errStream.println("ballerina: " + errorMsg);
        Runtime.getRuntime().exit(1);
    }

    public static void silentlyLogBadSad(Throwable throwable) {
        RuntimeUtils.printCrashLog(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printCrashLog(Throwable throwable) {
        Level logLevel = Level.ALL;
        try {
            Logger logger = crashLogger;
            synchronized (logger) {
                if (handler == null) {
                    handler = new FileHandler(RuntimeUtils.initBRELogHandler(), true);
                    handler.setFormatter(new DefaultLogFormatter());
                    crashLogger.addHandler(handler);
                    crashLogger.setUseParentHandlers(false);
                    crashLogger.setLevel(logLevel);
                }
            }
        }
        catch (IOException ioException) {
            stderr.print("error initializing crash logger");
        }
        crashLogger.log(Level.SEVERE, throwable.getMessage(), throwable);
    }

    private static String initBRELogHandler() {
        String fileName = LogManager.getLogManager().getProperty("org.ballerinalang.logging.handlers.DefaultLogFileHandler.pattern");
        if (fileName == null || fileName.trim().isEmpty()) {
            fileName = DEFAULT_CRASH_LOG_FILE;
        }
        if (Files.isWritable(Paths.get(USER_DIR, new String[0]))) {
            return Paths.get(USER_DIR, fileName).toString();
        }
        return Paths.get(TEMP_DIR, fileName).toString();
    }

    public static class ParamInfo {
        String name;
        boolean hasDefaultable;
        Type type;
        int index = -1;

        public ParamInfo(boolean hasDefaultable, String name, Type type) {
            this.name = name;
            this.hasDefaultable = hasDefaultable;
            this.type = type;
        }
    }
}

