/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.util.exceptions;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.util.exceptions.BLangFreezeException;
import io.ballerina.runtime.internal.util.exceptions.BallerinaErrorReasons;
import io.ballerina.runtime.internal.util.exceptions.BallerinaException;
import io.ballerina.runtime.internal.util.exceptions.RuntimeErrors;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class BLangExceptionHelper {
    private static ResourceBundle messageBundle = ResourceBundle.getBundle("MessagesBundle", Locale.getDefault());

    public static BError getRuntimeException(RuntimeErrors runtimeErrors, Object ... params) {
        BString errorMsg = StringUtils.fromString(MessageFormat.format(messageBundle.getString(runtimeErrors.getErrorMsgKey()), params));
        return ErrorCreator.createError(errorMsg);
    }

    public static BError getRuntimeException(BString reason, RuntimeErrors runtimeErrors, Object ... params) {
        BString errorDetail = StringUtils.fromString(MessageFormat.format(messageBundle.getString(runtimeErrors.getErrorMsgKey()), params));
        return ErrorCreator.createError(reason, errorDetail);
    }

    public static BString getErrorMessage(RuntimeErrors runtimeErrors, Object ... params) {
        return StringUtils.fromString(MessageFormat.format(messageBundle.getString(runtimeErrors.getErrorMsgKey()), params));
    }

    public static BError getJsonError(String reason, String operation, Throwable e) {
        if (e instanceof BallerinaException && ((BallerinaException)e).getDetail() != null) {
            return ErrorCreator.createError(StringUtils.fromString(reason), StringUtils.fromString("Failed to " + operation + ": " + ((BallerinaException)e).getDetail()));
        }
        if (e instanceof BLangFreezeException) {
            return ErrorCreator.createError(StringUtils.fromString(reason), StringUtils.fromString("Failed to " + operation + ": " + ((BLangFreezeException)e).getDetail()));
        }
        if (e.getCause() != null) {
            return ErrorCreator.createError(StringUtils.fromString(reason), StringUtils.fromString("Failed to " + operation + ": " + e.getCause().getMessage()));
        }
        return ErrorCreator.createError(StringUtils.fromString(reason), StringUtils.fromString("Failed to " + operation + ": " + e.getMessage()));
    }

    public static void handleInvalidXPath(String operation, Exception e) {
        throw ErrorCreator.createError(StringUtils.fromString("Failed to " + operation + ". Invalid xpath: " + e.getMessage()));
    }

    public static void handleXMLException(String operation, Throwable e) {
        if (e instanceof BallerinaException && ((BallerinaException)e).getDetail() != null) {
            throw ErrorCreator.createError(BallerinaErrorReasons.XML_OPERATION_ERROR, StringUtils.fromString("Failed to " + operation + ": " + ((BallerinaException)e).getDetail()));
        }
        if (e instanceof BLangFreezeException) {
            throw ErrorCreator.createError(BallerinaErrorReasons.XML_OPERATION_ERROR, StringUtils.fromString("Failed to " + operation + ": " + ((BLangFreezeException)e).getDetail()));
        }
        if (e.getCause() != null) {
            throw ErrorCreator.createError(BallerinaErrorReasons.XML_OPERATION_ERROR, StringUtils.fromString("Failed to " + operation + ": " + e.getCause().getMessage()));
        }
        throw ErrorCreator.createError(BallerinaErrorReasons.XML_OPERATION_ERROR, StringUtils.fromString("Failed to " + operation + ": " + e.getMessage()));
    }
}

