/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.PredefinedTypes;
import io.ballerina.runtime.api.constants.RuntimeConstants;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BValue;
import io.ballerina.runtime.internal.CycleUtils;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.types.BArrayType;
import io.ballerina.runtime.internal.util.exceptions.BLangExceptionHelper;
import io.ballerina.runtime.internal.util.exceptions.BallerinaErrorReasons;
import io.ballerina.runtime.internal.util.exceptions.BallerinaException;
import io.ballerina.runtime.internal.util.exceptions.RuntimeErrors;
import io.ballerina.runtime.internal.values.AbstractArrayValue;
import io.ballerina.runtime.internal.values.ArrayValue;
import io.ballerina.runtime.internal.values.IteratorValue;
import io.ballerina.runtime.internal.values.ListInitialValueEntry;
import io.ballerina.runtime.internal.values.ReadOnlyUtils;
import io.ballerina.runtime.internal.values.RefValue;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.IntStream;

public class ArrayValueImpl
extends AbstractArrayValue {
    protected ArrayType arrayType;
    protected Type elementType;
    protected Object[] refValues;
    private long[] intValues;
    private boolean[] booleanValues;
    private byte[] byteValues;
    private double[] floatValues;
    private BString[] bStringValues;

    @Deprecated
    public ArrayValueImpl(Object[] values, ArrayType type) {
        this.refValues = values;
        this.arrayType = type;
        this.size = values.length;
        if (type.getTag() == 20) {
            this.elementType = type.getElementType();
        }
    }

    @Deprecated
    public ArrayValueImpl(long[] values) {
        this.intValues = values;
        this.size = values.length;
        this.setArrayType(PredefinedTypes.TYPE_INT);
    }

    @Deprecated
    public ArrayValueImpl(boolean[] values) {
        this.booleanValues = values;
        this.size = values.length;
        this.setArrayType(PredefinedTypes.TYPE_BOOLEAN);
    }

    @Deprecated
    public ArrayValueImpl(byte[] values) {
        this.byteValues = values;
        this.size = values.length;
        this.setArrayType(PredefinedTypes.TYPE_BYTE);
    }

    @Deprecated
    public ArrayValueImpl(double[] values) {
        this.floatValues = values;
        this.size = values.length;
        this.setArrayType(PredefinedTypes.TYPE_FLOAT);
    }

    @Deprecated
    public ArrayValueImpl(String[] values) {
        this.size = values.length;
        this.bStringValues = new BString[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.bStringValues[i] = StringUtils.fromString(values[i]);
        }
        this.setArrayType(PredefinedTypes.TYPE_STRING);
    }

    @Deprecated
    public ArrayValueImpl(BString[] values) {
        this.bStringValues = values;
        this.size = values.length;
        this.setArrayType(PredefinedTypes.TYPE_STRING);
    }

    @Deprecated
    public ArrayValueImpl(ArrayType type) {
        this.arrayType = type;
        ArrayType arrayType = type;
        this.elementType = arrayType.getElementType();
        this.initArrayValues(this.elementType);
        if (arrayType.getState() == ArrayType.ArrayState.CLOSED) {
            this.size = this.maxSize = arrayType.getSize();
        }
    }

    private void initArrayValues(Type elementType) {
        int initialArraySize = this.arrayType.getSize() != -1 ? this.arrayType.getSize() : 100;
        switch (elementType.getTag()) {
            case 1: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                this.intValues = new long[initialArraySize];
                break;
            }
            case 3: {
                this.floatValues = new double[initialArraySize];
                break;
            }
            case 5: 
            case 46: {
                this.bStringValues = new BString[initialArraySize];
                break;
            }
            case 6: {
                this.booleanValues = new boolean[initialArraySize];
                break;
            }
            case 2: {
                this.byteValues = new byte[initialArraySize];
                break;
            }
            default: {
                this.refValues = new Object[initialArraySize];
                if (this.arrayType.getState() != ArrayType.ArrayState.CLOSED) break;
                this.fillerValueCheck(initialArraySize, initialArraySize);
                this.fillValues(initialArraySize);
            }
        }
    }

    @Deprecated
    public ArrayValueImpl(ArrayType type, long size) {
        this.arrayType = type;
        this.elementType = type.getElementType();
        this.initArrayValues(this.elementType);
        if (size != -1L) {
            this.size = this.maxSize = (int)size;
        }
    }

    @Deprecated
    public ArrayValueImpl(ArrayType type, long size, ListInitialValueEntry[] initialValues) {
        this.arrayType = type;
        this.elementType = type.getElementType();
        this.initArrayValues(this.elementType);
        if (size != -1L) {
            this.size = this.maxSize = (int)size;
        }
        for (int index = 0; index < initialValues.length; ++index) {
            this.addRefValue(index, ((ListInitialValueEntry.ExpressionEntry)initialValues[index]).value);
        }
    }

    @Override
    public Object get(long index) {
        this.rangeCheckForGet(index, this.size);
        switch (this.elementType.getTag()) {
            case 1: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                return this.intValues[(int)index];
            }
            case 6: {
                return this.booleanValues[(int)index];
            }
            case 2: {
                return Byte.toUnsignedInt(this.byteValues[(int)index]);
            }
            case 3: {
                return this.floatValues[(int)index];
            }
            case 5: 
            case 46: {
                return this.bStringValues[(int)index];
            }
        }
        return this.refValues[(int)index];
    }

    @Override
    public Object getRefValue(long index) {
        this.rangeCheckForGet(index, this.size);
        if (this.refValues != null) {
            return this.refValues[(int)index];
        }
        return this.get(index);
    }

    @Override
    public Object fillAndGetRefValue(long index) {
        if (this.refValues != null) {
            if (index >= (long)this.size) {
                this.handleImmutableArrayValue();
                this.fillRead(index, this.refValues.length);
            }
            return this.refValues[(int)index];
        }
        return this.get(index);
    }

    @Override
    public long getInt(long index) {
        this.rangeCheckForGet(index, this.size);
        if (this.intValues != null) {
            return this.intValues[(int)index];
        }
        if (this.refValues != null) {
            return (Long)this.refValues[(int)index];
        }
        return Byte.toUnsignedInt(this.byteValues[(int)index]);
    }

    @Override
    public boolean getBoolean(long index) {
        this.rangeCheckForGet(index, this.size);
        if (this.booleanValues != null) {
            return this.booleanValues[(int)index];
        }
        return (Boolean)this.refValues[(int)index];
    }

    @Override
    public byte getByte(long index) {
        this.rangeCheckForGet(index, this.size);
        if (this.byteValues != null) {
            return this.byteValues[(int)index];
        }
        return ((Integer)this.refValues[(int)index]).byteValue();
    }

    @Override
    public double getFloat(long index) {
        this.rangeCheckForGet(index, this.size);
        if (this.floatValues != null) {
            return this.floatValues[(int)index];
        }
        return (Double)this.refValues[(int)index];
    }

    @Override
    @Deprecated
    public String getString(long index) {
        this.rangeCheckForGet(index, this.size);
        if (this.bStringValues != null) {
            return this.bStringValues[(int)index].getValue();
        }
        return (String)this.refValues[(int)index];
    }

    @Override
    public BString getBString(long index) {
        this.rangeCheckForGet(index, this.size);
        if (this.bStringValues != null) {
            return this.bStringValues[(int)index];
        }
        return (BString)this.refValues[(int)index];
    }

    @Override
    public void add(long index, Object value) {
        this.handleImmutableArrayValue();
        this.addRefValue(index, value);
    }

    @Override
    public void add(long index, long value) {
        this.handleImmutableArrayValue();
        this.addInt(index, value);
    }

    @Override
    public void add(long index, boolean value) {
        this.handleImmutableArrayValue();
        this.addBoolean(index, value);
    }

    @Override
    public void add(long index, byte value) {
        this.handleImmutableArrayValue();
        this.addByte(index, value);
    }

    @Override
    public void add(long index, double value) {
        this.handleImmutableArrayValue();
        this.addFloat(index, value);
    }

    @Override
    @Deprecated
    public void add(long index, String value) {
        this.handleImmutableArrayValue();
        this.addString(index, value);
    }

    @Override
    public void add(long index, BString value) {
        this.handleImmutableArrayValue();
        this.addBString(index, value);
    }

    public void addRefValue(long index, Object value) {
        Type type = TypeChecker.getType(value);
        switch (this.elementType.getTag()) {
            case 6: {
                this.prepareForAdd(index, value, type, this.booleanValues.length);
                this.booleanValues[(int)index] = (Boolean)value;
                return;
            }
            case 3: {
                this.prepareForAdd(index, value, type, this.floatValues.length);
                this.floatValues[(int)index] = (Double)value;
                return;
            }
            case 2: {
                this.prepareForAdd(index, value, type, this.byteValues.length);
                this.byteValues[(int)index] = ((Number)value).byteValue();
                return;
            }
            case 1: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                this.prepareForAdd(index, value, type, this.intValues.length);
                this.intValues[(int)index] = (Long)value;
                return;
            }
            case 5: 
            case 46: {
                this.prepareForAdd(index, value, type, this.bStringValues.length);
                this.bStringValues[(int)index] = (BString)value;
                return;
            }
        }
        this.prepareForAdd(index, value, type, this.refValues.length);
        this.refValues[(int)index] = value;
    }

    public void addInt(long index, long value) {
        if (this.intValues != null) {
            this.prepareForAdd(index, value, PredefinedTypes.TYPE_INT, this.intValues.length);
            this.intValues[(int)index] = value;
            return;
        }
        this.prepareForAdd(index, value, TypeChecker.getType(value), this.byteValues.length);
        this.byteValues[(int)index] = (byte)Long.valueOf(value).intValue();
    }

    private void addBoolean(long index, boolean value) {
        this.prepareForAdd(index, value, PredefinedTypes.TYPE_BOOLEAN, this.booleanValues.length);
        this.booleanValues[(int)index] = value;
    }

    private void addByte(long index, byte value) {
        this.prepareForAdd(index, value, PredefinedTypes.TYPE_BYTE, this.byteValues.length);
        this.byteValues[(int)index] = value;
    }

    private void addFloat(long index, double value) {
        this.prepareForAdd(index, value, PredefinedTypes.TYPE_FLOAT, this.floatValues.length);
        this.floatValues[(int)index] = value;
    }

    @Deprecated
    private void addString(long index, String value) {
        this.addBString(index, StringUtils.fromString(value));
    }

    private void addBString(long index, BString value) {
        this.prepareForAdd(index, value, PredefinedTypes.TYPE_STRING, this.bStringValues.length);
        this.bStringValues[(int)index] = value;
    }

    @Override
    public void append(Object value) {
        this.add((long)this.size, value);
    }

    @Override
    public Object shift(long index) {
        this.handleImmutableArrayValue();
        Object val = this.get(index);
        this.shiftArray((int)index, this.getArrayFromType(this.elementType.getTag()));
        return val;
    }

    @Override
    public Object shift() {
        return this.shift(0L);
    }

    @Override
    public void unshift(Object[] values) {
        this.unshift(0L, values);
    }

    @Override
    public String stringValue(BLink parent) {
        StringJoiner sj = new StringJoiner(",");
        switch (this.elementType.getTag()) {
            case 1: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                for (int i = 0; i < this.size; ++i) {
                    sj.add(Long.toString(this.intValues[i]));
                }
                break;
            }
            case 6: {
                for (int i = 0; i < this.size; ++i) {
                    sj.add(Boolean.toString(this.booleanValues[i]));
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.size; ++i) {
                    sj.add(Long.toString(Byte.toUnsignedLong(this.byteValues[i])));
                }
                break;
            }
            case 3: {
                for (int i = 0; i < this.size; ++i) {
                    sj.add(Double.toString(this.floatValues[i]));
                }
                break;
            }
            case 5: 
            case 46: {
                for (int i = 0; i < this.size; ++i) {
                    sj.add(((BValue)((Object)this.bStringValues[i])).informalStringValue(parent));
                }
                break;
            }
            default: {
                block15: for (int i = 0; i < this.size; ++i) {
                    if (this.refValues[i] == null) {
                        sj.add("null");
                        continue;
                    }
                    Type type = TypeChecker.getType(this.refValues[i]);
                    switch (type.getTag()) {
                        case 5: 
                        case 8: 
                        case 26: 
                        case 28: 
                        case 47: 
                        case 48: 
                        case 49: 
                        case 50: {
                            sj.add(((BValue)this.refValues[i]).informalStringValue(new CycleUtils.Node(this, parent)));
                            continue block15;
                        }
                        default: {
                            sj.add(StringUtils.getStringValue(this.refValues[i], new CycleUtils.Node(this, parent)));
                        }
                    }
                }
            }
        }
        return "[" + sj.toString() + "]";
    }

    @Override
    public String expressionStringValue(BLink parent) {
        StringJoiner sj = new StringJoiner(",");
        switch (this.elementType.getTag()) {
            case 1: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                for (int i = 0; i < this.size; ++i) {
                    sj.add(StringUtils.getExpressionStringValue(this.intValues[i], new CycleUtils.Node(this, parent)));
                }
                break;
            }
            case 6: {
                for (int i = 0; i < this.size; ++i) {
                    sj.add(StringUtils.getExpressionStringValue(this.booleanValues[i], new CycleUtils.Node(this, parent)));
                }
                break;
            }
            case 2: {
                for (int i = 0; i < this.size; ++i) {
                    sj.add(StringUtils.getExpressionStringValue(this.byteValues[i], new CycleUtils.Node(this, parent)));
                }
                break;
            }
            case 3: {
                for (int i = 0; i < this.size; ++i) {
                    sj.add(StringUtils.getExpressionStringValue(this.floatValues[i], new CycleUtils.Node(this, parent)));
                }
                break;
            }
            case 5: 
            case 46: {
                for (int i = 0; i < this.size; ++i) {
                    sj.add(StringUtils.getExpressionStringValue(this.bStringValues[i], new CycleUtils.Node(this, parent)));
                }
                break;
            }
            default: {
                for (int i = 0; i < this.size; ++i) {
                    sj.add(StringUtils.getExpressionStringValue(this.refValues[i], new CycleUtils.Node(this, parent)));
                }
            }
        }
        return "[" + sj.toString() + "]";
    }

    @Override
    public Type getType() {
        return this.arrayType;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        if (this.isFrozen()) {
            return this;
        }
        if (refs.containsKey(this)) {
            return refs.get(this);
        }
        ArrayValueImpl valueArray = null;
        switch (this.elementType.getTag()) {
            case 1: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                valueArray = new ArrayValueImpl(Arrays.copyOf(this.intValues, this.size));
                break;
            }
            case 6: {
                valueArray = new ArrayValueImpl(Arrays.copyOf(this.booleanValues, this.size));
                break;
            }
            case 2: {
                valueArray = new ArrayValueImpl(Arrays.copyOf(this.byteValues, this.size));
                break;
            }
            case 3: {
                valueArray = new ArrayValueImpl(Arrays.copyOf(this.floatValues, this.size));
                break;
            }
            case 5: 
            case 46: {
                valueArray = new ArrayValueImpl(Arrays.copyOf(this.bStringValues, this.size));
                break;
            }
            default: {
                Object[] values = new Object[this.size];
                valueArray = new ArrayValueImpl(values, this.arrayType);
                IntStream.range(0, this.size).forEach(i -> {
                    Object value = this.refValues[i];
                    values[i] = value instanceof RefValue ? ((RefValue)value).copy(refs) : value;
                });
            }
        }
        refs.put(this, valueArray);
        return valueArray;
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        ArrayValue copy = (ArrayValue)this.copy(refs);
        if (!copy.isFrozen()) {
            copy.freezeDirect();
        }
        return copy;
    }

    @Override
    @Deprecated
    public ArrayValueImpl slice(long startIndex, long endIndex) {
        ArrayValueImpl slicedArray;
        int slicedSize = (int)(endIndex - startIndex);
        switch (this.elementType.getTag()) {
            case 1: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                slicedArray = new ArrayValueImpl(new long[slicedSize]);
                System.arraycopy(this.intValues, (int)startIndex, slicedArray.intValues, 0, slicedSize);
                break;
            }
            case 6: {
                slicedArray = new ArrayValueImpl(new boolean[slicedSize]);
                System.arraycopy(this.booleanValues, (int)startIndex, slicedArray.booleanValues, 0, slicedSize);
                break;
            }
            case 2: {
                slicedArray = new ArrayValueImpl(new byte[slicedSize]);
                System.arraycopy(this.byteValues, (int)startIndex, slicedArray.byteValues, 0, slicedSize);
                break;
            }
            case 3: {
                slicedArray = new ArrayValueImpl(new double[slicedSize]);
                System.arraycopy(this.floatValues, (int)startIndex, slicedArray.floatValues, 0, slicedSize);
                break;
            }
            case 5: 
            case 46: {
                slicedArray = new ArrayValueImpl(new BString[slicedSize]);
                System.arraycopy(this.bStringValues, (int)startIndex, slicedArray.bStringValues, 0, slicedSize);
                break;
            }
            default: {
                slicedArray = new ArrayValueImpl(new Object[slicedSize], new BArrayType(this.elementType));
                System.arraycopy(this.refValues, (int)startIndex, slicedArray.refValues, 0, slicedSize);
            }
        }
        return slicedArray;
    }

    @Override
    public String toString() {
        return this.stringValue(null);
    }

    @Override
    public Object[] getValues() {
        return this.refValues;
    }

    @Override
    public byte[] getBytes() {
        byte[] bytes = new byte[this.size];
        System.arraycopy(this.byteValues, 0, bytes, 0, this.size);
        return bytes;
    }

    @Override
    public String[] getStringArray() {
        String[] arr = new String[this.size];
        for (int i = 0; i < this.size; ++i) {
            arr[i] = this.bStringValues[i].getValue();
        }
        return arr;
    }

    public long[] getLongArray() {
        return Arrays.copyOf(this.intValues, this.size);
    }

    @Override
    public long[] getIntArray() {
        return Arrays.copyOf(this.intValues, this.size);
    }

    @Override
    public void serialize(OutputStream outputStream) {
        if (this.elementType.getTag() == 2) {
            try {
                for (int i = 0; i < this.size; ++i) {
                    outputStream.write(this.byteValues[i]);
                }
            }
            catch (IOException e) {
                throw new BallerinaException("error occurred while writing the binary content to the output stream", e);
            }
        }
        try {
            outputStream.write(this.toString().getBytes(Charset.defaultCharset()));
        }
        catch (IOException e) {
            throw new BallerinaException("error occurred while serializing data", e);
        }
    }

    @Override
    public void freezeDirect() {
        if (this.arrayType.isReadOnly()) {
            return;
        }
        this.arrayType = (ArrayType)ReadOnlyUtils.setImmutableTypeAndGetEffectiveType(this.arrayType);
        if (this.elementType == null || this.elementType.getTag() > 6) {
            for (int i = 0; i < this.size; ++i) {
                Object value = this.getRefValue(i);
                if (!(value instanceof RefValue)) continue;
                ((RefValue)value).freezeDirect();
            }
        }
    }

    @Override
    public IteratorValue getIterator() {
        return new AbstractArrayValue.ArrayIterator(this);
    }

    @Override
    public Type getElementType() {
        return this.elementType;
    }

    @Override
    protected void resizeInternalArray(int newLength) {
        switch (this.elementType.getTag()) {
            case 1: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                this.intValues = Arrays.copyOf(this.intValues, newLength);
                break;
            }
            case 6: {
                this.booleanValues = Arrays.copyOf(this.booleanValues, newLength);
                break;
            }
            case 2: {
                this.byteValues = Arrays.copyOf(this.byteValues, newLength);
                break;
            }
            case 3: {
                this.floatValues = Arrays.copyOf(this.floatValues, newLength);
                break;
            }
            case 5: 
            case 46: {
                this.bStringValues = Arrays.copyOf(this.bStringValues, newLength);
                break;
            }
            default: {
                this.refValues = Arrays.copyOf(this.refValues, newLength);
            }
        }
    }

    @Override
    protected void fillValues(int index) {
        if (index <= this.size) {
            return;
        }
        switch (this.elementType.getTag()) {
            case 5: {
                Arrays.fill(this.bStringValues, this.size, index, RuntimeConstants.STRING_EMPTY_VALUE);
                return;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                return;
            }
        }
        if (this.arrayType.hasFillerValue()) {
            for (int i = this.size; i < index; ++i) {
                this.refValues[i] = this.elementType.getZeroValue();
            }
        }
    }

    @Override
    protected void rangeCheckForGet(long index, int size) {
        this.rangeCheck(index, size);
        if (index >= (long)size) {
            throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.getModulePrefixedReason("lang.array", "IndexOutOfRange"), RuntimeErrors.ARRAY_INDEX_OUT_OF_RANGE, index, size);
        }
    }

    @Override
    protected void rangeCheck(long index, int size) {
        if (index > Integer.MAX_VALUE || index < Integer.MIN_VALUE) {
            throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.getModulePrefixedReason("lang.array", "IndexOutOfRange"), RuntimeErrors.INDEX_NUMBER_TOO_LARGE, index);
        }
        if ((int)index < 0 || index >= (long)this.maxSize) {
            throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.getModulePrefixedReason("lang.array", "IndexOutOfRange"), RuntimeErrors.ARRAY_INDEX_OUT_OF_RANGE, index, size);
        }
    }

    @Override
    protected void fillerValueCheck(int index, int size) {
        if (this.arrayType.hasFillerValue()) {
            return;
        }
        if (index > size) {
            throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.ILLEGAL_LIST_INSERTION_ERROR, RuntimeErrors.ILLEGAL_ARRAY_INSERTION, size, index + 1);
        }
    }

    @Override
    protected void ensureCapacity(int requestedCapacity, int currentArraySize) {
        if (requestedCapacity <= currentArraySize) {
            return;
        }
        if (this.arrayType.getState() != ArrayType.ArrayState.OPEN) {
            return;
        }
        int newArraySize = currentArraySize + (currentArraySize >> 1);
        newArraySize = Math.max(newArraySize, requestedCapacity);
        newArraySize = Math.min(newArraySize, this.maxSize);
        this.resizeInternalArray(newArraySize);
    }

    @Override
    protected void checkFixedLength(long length) {
        if (this.arrayType.getState() == ArrayType.ArrayState.CLOSED) {
            throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.getModulePrefixedReason("lang.array", "InherentTypeViolation"), RuntimeErrors.ILLEGAL_ARRAY_SIZE, this.size, length);
        }
    }

    @Override
    protected void unshift(long index, Object[] vals) {
        this.handleImmutableArrayValue();
        this.unshiftArray(index, vals.length, this.getCurrentArrayLength());
        int startIndex = (int)index;
        int endIndex = startIndex + vals.length;
        int i = startIndex;
        int j = 0;
        while (i < endIndex) {
            this.add((long)i, vals[j]);
            ++i;
            ++j;
        }
    }

    private void prepareForAdd(long index, Object value, Type sourceType, int currentArraySize) {
        if (!TypeChecker.checkIsType(value, sourceType, this.elementType)) {
            BString reason = BallerinaErrorReasons.getModulePrefixedReason("lang.array", "InherentTypeViolation");
            BString detail = BLangExceptionHelper.getErrorMessage(RuntimeErrors.INCOMPATIBLE_TYPE, this.elementType, sourceType);
            throw ErrorCreator.createError(reason, detail);
        }
        int intIndex = (int)index;
        this.rangeCheck(index, this.size);
        this.fillerValueCheck(intIndex, this.size);
        this.ensureCapacity(intIndex + 1, currentArraySize);
        this.fillValues(intIndex);
        this.resetSize(intIndex);
    }

    private void fillRead(long index, int currentArraySize) {
        if (!this.arrayType.hasFillerValue()) {
            throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.ILLEGAL_LIST_INSERTION_ERROR, RuntimeErrors.ILLEGAL_ARRAY_INSERTION, this.size, index + 1L);
        }
        int intIndex = (int)index;
        this.rangeCheck(index, this.size);
        this.ensureCapacity(intIndex + 1, currentArraySize);
        switch (this.elementType.getTag()) {
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 5: {
                Arrays.fill(this.bStringValues, this.size, intIndex, RuntimeConstants.STRING_EMPTY_VALUE);
                break;
            }
            default: {
                int i = this.size;
                while ((long)i <= index) {
                    this.refValues[i] = this.elementType.getZeroValue();
                    ++i;
                }
                break block0;
            }
        }
        this.resetSize(intIndex);
    }

    private void setArrayType(Type elementType) {
        this.arrayType = new BArrayType(elementType);
        this.elementType = elementType;
    }

    private void resetSize(int index) {
        if (index >= this.size) {
            this.size = index + 1;
        }
    }

    private void shiftArray(int index, Object arr) {
        int nElemsToBeMoved = this.size - 1 - index;
        if (nElemsToBeMoved >= 0) {
            System.arraycopy(arr, index + 1, arr, index, nElemsToBeMoved);
        }
        --this.size;
    }

    private void unshiftArray(long index, int unshiftByN, int arrLength) {
        int lastIndex = this.size() + unshiftByN - 1;
        this.prepareForConsecutiveMultiAdd(lastIndex, arrLength);
        Object arr = this.getArrayFromType(this.elementType.getTag());
        if (index > (long)lastIndex) {
            throw BLangExceptionHelper.getRuntimeException(BallerinaErrorReasons.getModulePrefixedReason("lang.array", "IndexOutOfRange"), RuntimeErrors.INDEX_NUMBER_TOO_LARGE, index);
        }
        int i = (int)index;
        System.arraycopy(arr, i, arr, i + unshiftByN, this.size - i);
    }

    private Object getArrayFromType(int typeTag) {
        switch (typeTag) {
            case 1: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                return this.intValues;
            }
            case 6: {
                return this.booleanValues;
            }
            case 2: {
                return this.byteValues;
            }
            case 3: {
                return this.floatValues;
            }
            case 5: 
            case 46: {
                return this.bStringValues;
            }
        }
        return this.refValues;
    }

    private int getCurrentArrayLength() {
        switch (this.elementType.getTag()) {
            case 1: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                return this.intValues.length;
            }
            case 6: {
                return this.booleanValues.length;
            }
            case 2: {
                return this.byteValues.length;
            }
            case 3: {
                return this.floatValues.length;
            }
            case 5: 
            case 46: {
                return this.bStringValues.length;
            }
        }
        return this.refValues.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayValueImpl that = (ArrayValueImpl)o;
        return this.arrayType.equals(that.arrayType) && this.elementType.equals(that.elementType) && Arrays.equals(this.refValues, that.refValues) && Arrays.equals(this.intValues, that.intValues) && Arrays.equals(this.booleanValues, that.booleanValues) && Arrays.equals(this.byteValues, that.byteValues) && Arrays.equals(this.floatValues, that.floatValues) && Arrays.equals(this.bStringValues, that.bStringValues);
    }

    public int hashCode() {
        int result = Objects.hash(this.arrayType, this.elementType);
        result = 31 * result + Arrays.hashCode(this.refValues);
        result = 31 * result + Arrays.hashCode(this.intValues);
        result = 31 * result + Arrays.hashCode(this.booleanValues);
        result = 31 * result + Arrays.hashCode(this.byteValues);
        result = 31 * result + Arrays.hashCode(this.floatValues);
        result = 31 * result + Arrays.hashCode(this.bStringValues);
        return result;
    }
}

