/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.PredefinedTypes;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BMapInitialValueEntry;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.api.values.BValue;
import io.ballerina.runtime.internal.CycleUtils;
import io.ballerina.runtime.internal.IteratorUtils;
import io.ballerina.runtime.internal.JsonGenerator;
import io.ballerina.runtime.internal.JsonUtils;
import io.ballerina.runtime.internal.MapUtils;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.types.BField;
import io.ballerina.runtime.internal.types.BMapType;
import io.ballerina.runtime.internal.types.BRecordType;
import io.ballerina.runtime.internal.types.BTupleType;
import io.ballerina.runtime.internal.types.BUnionType;
import io.ballerina.runtime.internal.util.exceptions.BLangExceptionHelper;
import io.ballerina.runtime.internal.util.exceptions.BallerinaErrorReasons;
import io.ballerina.runtime.internal.util.exceptions.BallerinaException;
import io.ballerina.runtime.internal.util.exceptions.RuntimeErrors;
import io.ballerina.runtime.internal.values.CollectionValue;
import io.ballerina.runtime.internal.values.IteratorValue;
import io.ballerina.runtime.internal.values.MapValue;
import io.ballerina.runtime.internal.values.MappingInitialValueEntry;
import io.ballerina.runtime.internal.values.ReadOnlyUtils;
import io.ballerina.runtime.internal.values.RefValue;
import io.ballerina.runtime.internal.values.TupleValueImpl;
import io.ballerina.runtime.internal.values.TypedescValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public class MapValueImpl<K, V>
extends LinkedHashMap<K, V>
implements RefValue,
CollectionValue,
MapValue<K, V>,
BMap<K, V> {
    private static final long serialVersionUID = 1L;
    private TypedescValue typedesc;
    private Type type;
    private final Map<String, Object> nativeData = new HashMap<String, Object>();
    private Type iteratorNextReturnType;

    public MapValueImpl(TypedescValue typedesc) {
        this(typedesc.getDescribingType());
        this.typedesc = typedesc;
    }

    public MapValueImpl(Type type) {
        this.type = type;
    }

    public MapValueImpl(Type type, BMapInitialValueEntry[] initialValues) {
        this.type = type;
        this.populateInitialValues(initialValues);
    }

    public MapValueImpl() {
        this.type = PredefinedTypes.TYPE_MAP;
    }

    @Override
    public Long getIntValue(BString key) {
        return (Long)this.get(key);
    }

    @Override
    public Double getFloatValue(BString key) {
        return (Double)this.get(key);
    }

    @Override
    public BString getStringValue(BString key) {
        return (BString)this.get(key);
    }

    @Override
    public Boolean getBooleanValue(BString key) {
        return (Boolean)this.get(key);
    }

    @Override
    public BMap<?, ?> getMapValue(BString key) {
        return (BMap)this.get(key);
    }

    @Override
    public BObject getObjectValue(BString key) {
        return (BObject)this.get(key);
    }

    @Override
    public BArray getArrayValue(BString key) {
        return (BArray)this.get(key);
    }

    @Override
    public long getDefaultableIntValue(BString key) {
        if (this.get(key) != null) {
            return this.getIntValue(key);
        }
        return 0L;
    }

    @Override
    public V getOrThrow(Object key) {
        if (!this.containsKey(key)) {
            throw ErrorCreator.createError(BallerinaErrorReasons.MAP_KEY_NOT_FOUND_ERROR, StringUtils.fromString("cannot find key '" + key + "'"));
        }
        return this.get(key);
    }

    @Override
    public V fillAndGet(Object key) {
        if (this.containsKey(key)) {
            return this.get(key);
        }
        Type expectedType = null;
        if (this.type.getTag() == 12) {
            BRecordType recordType = (BRecordType)this.type;
            Map<String, Field> fields = recordType.getFields();
            if (fields.containsKey(key.toString())) {
                expectedType = ((BField)fields.get((Object)key.toString())).type;
            } else {
                if (recordType.sealed) {
                    throw ErrorCreator.createError(BallerinaErrorReasons.MAP_KEY_NOT_FOUND_ERROR, StringUtils.fromString("cannot find key '" + key + "'"));
                }
                expectedType = recordType.restFieldType;
            }
        } else {
            expectedType = ((BMapType)this.type).getConstrainedType();
        }
        if (!TypeChecker.hasFillerValue(expectedType)) {
            throw ErrorCreator.createError(BallerinaErrorReasons.MAP_KEY_NOT_FOUND_ERROR, StringUtils.fromString("cannot find key '" + key + "'"));
        }
        Object value = expectedType.getZeroValue();
        this.put(key, value);
        return value;
    }

    @Override
    public Object merge(BMap v2, boolean checkMergeability) {
        BError errorIfUnmergeable;
        if (checkMergeability && (errorIfUnmergeable = JsonUtils.getErrorIfUnmergeable(this, v2, new ArrayList<JsonUtils.ObjectPair>())) != null) {
            return errorIfUnmergeable;
        }
        MapValueImpl m1 = this;
        MapValue m2 = (MapValue)v2;
        for (Map.Entry entry : m2.entrySet()) {
            BString key = (BString)entry.getKey();
            if (!m1.containsKey(key)) {
                m1.put(key, entry.getValue());
                continue;
            }
            m1.put(key, JsonUtils.mergeJson(m1.get(key), entry.getValue(), false));
        }
        return this;
    }

    @Override
    public V put(K key, V value) {
        if (!this.type.isReadOnly()) {
            return this.putValue(key, value);
        }
        String errMessage = "";
        switch (this.getType().getTag()) {
            case 12: {
                errMessage = "Invalid update of record field: ";
                break;
            }
            case 15: {
                errMessage = "Invalid map insertion: ";
            }
        }
        throw ErrorCreator.createError(BallerinaErrorReasons.getModulePrefixedReason("lang.map", "InvalidUpdate"), StringUtils.fromString(errMessage).concat(BLangExceptionHelper.getErrorMessage(RuntimeErrors.INVALID_READONLY_VALUE_UPDATE, new Object[0])));
    }

    protected void populateInitialValues(BMapInitialValueEntry[] initialValues) {
        for (BMapInitialValueEntry initialValue : initialValues) {
            if (initialValue.isKeyValueEntry()) {
                MappingInitialValueEntry.KeyValueEntry keyValueEntry = (MappingInitialValueEntry.KeyValueEntry)initialValue;
                this.populateInitialValue(keyValueEntry.key, keyValueEntry.value);
                continue;
            }
            MapValueImpl values = (MapValueImpl)((MappingInitialValueEntry.SpreadFieldEntry)initialValue).values;
            for (Map.Entry entry : values.entrySet()) {
                this.populateInitialValue(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void populateInitialValue(K key, V value) {
        if (this.type.getTag() == 15) {
            MapUtils.handleInherentTypeViolatingMapUpdate(value, (BMapType)this.type);
        } else {
            BString fieldName = (BString)key;
            MapUtils.handleInherentTypeViolatingRecordUpdate(this, fieldName, value, (BRecordType)this.type, true);
        }
        this.putValue(key, value);
    }

    @Override
    public void clear() {
        this.validateFreezeStatus();
        super.clear();
    }

    protected void validateFreezeStatus() {
        if (!this.type.isReadOnly()) {
            return;
        }
        ReadOnlyUtils.handleInvalidUpdate("lang.map");
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(key);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapValueImpl mapValue = (MapValueImpl)o;
        if (mapValue.type.getTag() != this.type.getTag()) {
            return false;
        }
        if (this.entrySet().size() != mapValue.entrySet().size()) {
            return false;
        }
        return this.entrySet().equals(mapValue.entrySet());
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public V remove(Object key) {
        this.validateFreezeStatus();
        return super.remove(key);
    }

    @Override
    public K[] getKeys() {
        Set keys = super.keySet();
        return keys.toArray(new BString[keys.size()]);
    }

    @Override
    public Collection<V> values() {
        return super.values();
    }

    @Override
    public int size() {
        return super.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public String toString() {
        return this.stringValue(null);
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        if (this.isFrozen()) {
            return this;
        }
        if (refs.containsKey(this)) {
            return refs.get(this);
        }
        MapValueImpl newMap = new MapValueImpl(this.type);
        refs.put(this, newMap);
        for (Map.Entry entry : this.entrySet()) {
            Object value = entry.getValue();
            value = value instanceof RefValue ? ((RefValue)value).copy(refs) : value;
            newMap.put(entry.getKey(), value);
        }
        return newMap;
    }

    @Override
    public Object frozenCopy(Map<Object, Object> refs) {
        MapValueImpl copy = (MapValueImpl)this.copy(refs);
        if (!copy.isFrozen()) {
            copy.freezeDirect();
        }
        return copy;
    }

    @Override
    public String stringValue(BLink parent) {
        StringJoiner sj = new StringJoiner(",");
        block3: for (Map.Entry kvEntry : this.entrySet()) {
            Object key = kvEntry.getKey();
            Object value = kvEntry.getValue();
            if (value == null) {
                sj.add("\"" + key + "\":null");
                continue;
            }
            Type type = TypeChecker.getType(value);
            CycleUtils.Node mapParent = new CycleUtils.Node(this, parent);
            switch (type.getTag()) {
                case 5: 
                case 8: 
                case 26: 
                case 28: 
                case 47: 
                case 48: 
                case 49: 
                case 50: {
                    sj.add("\"" + key + "\":" + ((BValue)value).informalStringValue(mapParent));
                    continue block3;
                }
            }
            sj.add("\"" + key + "\":" + StringUtils.getStringValue(value, mapParent));
        }
        return "{" + sj.toString() + "}";
    }

    @Override
    public String expressionStringValue(BLink parent) {
        CycleUtils.Node node = new CycleUtils.Node(this, parent);
        StringJoiner sj = new StringJoiner(",");
        for (Map.Entry kvEntry : this.entrySet()) {
            Object key = kvEntry.getKey();
            Object value = kvEntry.getValue();
            CycleUtils.Node mapParent = new CycleUtils.Node(this, node);
            sj.add("\"" + key + "\":" + StringUtils.getExpressionStringValue(value, mapParent));
        }
        return "{" + sj.toString() + "}";
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public void freezeDirect() {
        if (this.isFrozen()) {
            return;
        }
        this.type = ReadOnlyUtils.setImmutableTypeAndGetEffectiveType(this.type);
        this.values().forEach((? super T val) -> {
            if (val instanceof RefValue) {
                ((RefValue)val).freezeDirect();
            }
        });
    }

    public String getJSONString() {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        JsonGenerator gen = new JsonGenerator(byteOut);
        try {
            gen.serialize(this);
            gen.flush();
        }
        catch (IOException e) {
            throw new BallerinaException("Error in converting JSON to a string: " + e.getMessage(), e);
        }
        return new String(byteOut.toByteArray());
    }

    @Override
    public IteratorValue getIterator() {
        return new MapIterator(new LinkedHashSet(this.entrySet()).iterator());
    }

    @Override
    public void addNativeData(String key, Object data) {
        this.nativeData.put(key, data);
    }

    @Override
    public Object getNativeData(String key) {
        return this.nativeData.get(key);
    }

    @Override
    public BTypedesc getTypedesc() {
        return this.typedesc;
    }

    public Map<String, Object> getNativeDataMap() {
        return this.nativeData;
    }

    private void initializeIteratorNextReturnType() {
        Type type;
        if (this.type.getTag() == PredefinedTypes.TYPE_MAP.getTag()) {
            BMapType mapType = (BMapType)this.type;
            type = mapType.getConstrainedType();
        } else {
            BRecordType recordType = (BRecordType)this.type;
            LinkedHashSet types = recordType.getFields().values().stream().map(Field::getFieldType).collect(Collectors.toCollection(LinkedHashSet::new));
            if (recordType.restFieldType != null) {
                types.add(recordType.restFieldType);
            }
            type = types.size() == 1 ? (Type)types.iterator().next() : new BUnionType(new ArrayList<Type>(types));
        }
        this.iteratorNextReturnType = IteratorUtils.createIteratorNextReturnType(type);
    }

    @Override
    public Type getIteratorNextReturnType() {
        if (this.iteratorNextReturnType == null) {
            this.initializeIteratorNextReturnType();
        }
        return this.iteratorNextReturnType;
    }

    protected V putValue(K key, V value) {
        return super.put(key, value);
    }

    static class MapIterator<K, V>
    implements IteratorValue {
        Iterator<Map.Entry<K, V>> iterator;

        MapIterator(Iterator<Map.Entry<K, V>> iterator) {
            this.iterator = iterator;
        }

        public Object next() {
            Map.Entry<K, V> next = this.iterator.next();
            V value = next.getValue();
            LinkedList<Type> types = new LinkedList<Type>();
            types.add(PredefinedTypes.TYPE_STRING);
            types.add(TypeChecker.getType(value));
            BTupleType tupleType = new BTupleType(types);
            TupleValueImpl tuple = new TupleValueImpl(tupleType);
            tuple.add(0L, next.getKey());
            tuple.add(1L, value);
            return tuple;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }
    }
}

