/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.scheduling.Scheduler;
import io.ballerina.runtime.internal.scheduling.Strand;
import io.ballerina.runtime.internal.util.exceptions.BallerinaException;
import io.ballerina.runtime.internal.values.MapValue;
import java.util.HashMap;
import java.util.Map;

public abstract class ValueCreator {
    private static final Map<String, ValueCreator> runtimeValueCreators = new HashMap<String, ValueCreator>();

    public static void addValueCreator(String orgName, String moduleName, String moduleVersion, ValueCreator valueCreator) {
        String key = ValueCreator.getLookupKey(orgName, moduleName, moduleVersion);
        if (!key.equals(".") && runtimeValueCreators.containsKey(key)) {
            return;
        }
        runtimeValueCreators.put(key, valueCreator);
    }

    private static String getLookupKey(String orgName, String moduleName, String version) {
        if (".".equals(moduleName)) {
            return moduleName;
        }
        Object pkgName = "";
        if (orgName != null && !orgName.equals("$anon")) {
            pkgName = orgName + "/";
        }
        if (version == null || version.equals("")) {
            return (String)pkgName + moduleName;
        }
        return (String)pkgName + moduleName + ":" + version;
    }

    public static ValueCreator getValueCreator(String key) {
        if (!runtimeValueCreators.containsKey(key)) {
            throw new BallerinaException("Value creator object is not available");
        }
        return runtimeValueCreators.get(key);
    }

    public abstract MapValue<BString, Object> createRecordValue(String var1);

    public abstract BObject createObjectValue(String var1, Scheduler var2, Strand var3, Map<String, Object> var4, Object[] var5);
}

