/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.PredefinedTypes;
import io.ballerina.runtime.api.types.XmlNodeType;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.internal.values.XmlNonElementItem;
import java.util.Map;
import java.util.Objects;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.llom.OMCommentImpl;

public class XmlComment
extends XmlNonElementItem {
    private String data;

    public XmlComment(String data) {
        this.data = data;
        this.type = PredefinedTypes.TYPE_COMMENT;
    }

    public XmlComment(String data, boolean readonly) {
        this.data = data;
        this.type = readonly ? PredefinedTypes.TYPE_READONLY_COMMENT : PredefinedTypes.TYPE_COMMENT;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public String getTextValue() {
        return this.data;
    }

    @Override
    public XmlNodeType getNodeType() {
        return XmlNodeType.COMMENT;
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        if (this.isFrozen()) {
            return this;
        }
        return new XmlComment(this.data);
    }

    @Override
    public OMNode value() {
        OMCommentImpl omComment = new OMCommentImpl();
        omComment.setValue(this.data);
        return omComment;
    }

    @Override
    public String stringValue(BLink parent) {
        return "<!--" + this.data + "-->";
    }

    @Override
    public String informalStringValue(BLink parent) {
        return "`" + this.toString() + "`";
    }

    @Override
    public String expressionStringValue(BLink parent) {
        return "xml`" + this.toString() + "`";
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof XmlComment) {
            XmlComment that = (XmlComment)obj;
            return this.data.equals(that.data);
        }
        return false;
    }
}

