/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.values;

import io.ballerina.runtime.api.PredefinedTypes;
import io.ballerina.runtime.api.constants.RuntimeConstants;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.types.XmlNodeType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BLink;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.runtime.api.values.BXmlItem;
import io.ballerina.runtime.api.values.BXmlSequence;
import io.ballerina.runtime.internal.BallerinaXmlSerializer;
import io.ballerina.runtime.internal.XmlFactory;
import io.ballerina.runtime.internal.XmlValidator;
import io.ballerina.runtime.internal.util.exceptions.BallerinaErrorReasons;
import io.ballerina.runtime.internal.util.exceptions.BallerinaException;
import io.ballerina.runtime.internal.values.AttributeMapValueImpl;
import io.ballerina.runtime.internal.values.ErrorValue;
import io.ballerina.runtime.internal.values.IteratorValue;
import io.ballerina.runtime.internal.values.MapValue;
import io.ballerina.runtime.internal.values.MapValueImpl;
import io.ballerina.runtime.internal.values.ReadOnlyUtils;
import io.ballerina.runtime.internal.values.XmlPi;
import io.ballerina.runtime.internal.values.XmlSequence;
import io.ballerina.runtime.internal.values.XmlText;
import io.ballerina.runtime.internal.values.XmlValue;
import java.io.ByteArrayOutputStream;
import java.lang.ref.WeakReference;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNode;

public final class XmlItem
extends XmlValue
implements BXmlItem {
    private QName name;
    private XmlSequence children;
    private AttributeMapValueImpl attributes;
    private List<WeakReference<XmlItem>> probableParents;

    public XmlItem(QName name, XmlSequence children, boolean readonly) {
        this.name = name;
        this.children = children;
        for (BXml child : children.children) {
            this.addParent(child, this);
        }
        this.attributes = new AttributeMapValueImpl(false);
        this.addDefaultNamespaceAttribute(name, this.attributes);
        this.probableParents = new ArrayList<WeakReference<XmlItem>>();
        this.type = PredefinedTypes.TYPE_ELEMENT;
        this.type = readonly ? PredefinedTypes.TYPE_READONLY_ELEMENT : PredefinedTypes.TYPE_ELEMENT;
    }

    public XmlItem(QName name, XmlSequence children) {
        this(name, children, false);
    }

    public XmlItem(QName name) {
        this(name, new XmlSequence(new ArrayList<BXml>()));
        this.type = PredefinedTypes.TYPE_ELEMENT;
    }

    public XmlItem(QName name, boolean readonly) {
        XmlSequence children = new XmlSequence(new ArrayList<BXml>());
        this.name = name;
        this.children = children;
        for (BXml child : children.children) {
            this.addParent(child, this);
        }
        this.attributes = new AttributeMapValueImpl(readonly);
        this.addDefaultNamespaceAttribute(name, this.attributes);
        this.probableParents = new ArrayList<WeakReference<XmlItem>>();
        this.type = readonly ? PredefinedTypes.TYPE_READONLY_ELEMENT : PredefinedTypes.TYPE_ELEMENT;
    }

    private void addDefaultNamespaceAttribute(QName name, AttributeMapValueImpl attributes) {
        String namespace = name.getNamespaceURI();
        if (namespace == null || namespace.isEmpty()) {
            return;
        }
        String prefix = name.getPrefix();
        if (prefix == null || prefix.isEmpty()) {
            prefix = "xmlns";
        }
        attributes.populateInitialValue(StringUtils.fromString("{http://www.w3.org/2000/xmlns/}" + prefix), StringUtils.fromString(namespace));
    }

    @Override
    public XmlNodeType getNodeType() {
        return XmlNodeType.ELEMENT;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public String getItemType() {
        return this.getNodeType().value();
    }

    @Override
    public String getElementName() {
        return this.name.toString();
    }

    @Override
    public QName getQName() {
        return this.name;
    }

    @Override
    public void setQName(QName name) {
        this.name = name;
    }

    @Override
    public String getTextValue() {
        return this.children.getTextValue();
    }

    @Override
    public BString getAttribute(String localName, String namespace) {
        return this.getAttribute(localName, namespace, "");
    }

    @Override
    public BString getAttribute(String localName, String namespace, String prefix) {
        String ns;
        BString attrVal;
        if (prefix != null && !prefix.isEmpty() && (attrVal = (BString)this.attributes.get(StringUtils.fromString("{" + (ns = ((BString)this.attributes.get(StringUtils.fromString("{http://www.w3.org/2000/xmlns/}" + prefix))).getValue()) + "}" + localName))) != null) {
            return attrVal;
        }
        if (namespace != null && !namespace.isEmpty()) {
            return (BString)this.attributes.get(StringUtils.fromString("{" + namespace + "}" + localName));
        }
        return (BString)this.attributes.get(StringUtils.fromString(localName));
    }

    @Override
    public void setAttribute(String localName, String namespaceUri, String prefix, String value) {
        if (this.type.isReadOnly()) {
            ReadOnlyUtils.handleInvalidUpdate("lang.xml");
        }
        this.attributes.setAttribute(localName, namespaceUri, prefix, value, false);
    }

    @Override
    public MapValue<BString, BString> getAttributesMap() {
        return this.attributes;
    }

    @Override
    @Deprecated
    public void setAttributes(BMap<BString, BString> attributes) {
        if (this.type.isReadOnly()) {
            ReadOnlyUtils.handleInvalidUpdate("lang.xml");
        }
        this.setAttributes(attributes, this::setAttribute);
    }

    @Override
    public XmlValue elements() {
        ArrayList<BXml> children = new ArrayList<BXml>();
        children.add(this);
        return new XmlSequence(children);
    }

    @Override
    public XmlValue elements(String qname) {
        ArrayList<BXml> children = new ArrayList<BXml>();
        if (this.getElementName().equals(this.getQname(qname).toString())) {
            children.add(this);
        }
        return new XmlSequence(children);
    }

    @Override
    public XmlValue children() {
        return new XmlSequence(new ArrayList<BXml>(this.children.getChildrenList()));
    }

    @Override
    public XmlValue children(String qname) {
        return this.children.elements(qname);
    }

    @Override
    public void setChildren(BXml seq) {
        if (this.type.isReadOnly()) {
            ReadOnlyUtils.handleInvalidUpdate("lang.xml");
        }
        if (seq == null) {
            return;
        }
        if (seq.getNodeType() == XmlNodeType.SEQUENCE) {
            this.children = (XmlSequence)seq;
            for (BXml child : this.children.children) {
                this.addParent(child);
            }
        } else {
            this.addParent(seq);
            this.children = new XmlSequence(seq);
        }
    }

    @Override
    @Deprecated
    public void addChildren(BXml seq) {
        if (seq == null) {
            return;
        }
        ArrayList<BXml> leftList = new ArrayList<BXml>(this.children.children);
        if (seq.getNodeType() == XmlNodeType.SEQUENCE) {
            List<BXml> appendingList = ((XmlSequence)seq).getChildrenList();
            if (this.isLastChildIsTextNode(leftList) && !appendingList.isEmpty() && appendingList.get(0).getNodeType() == XmlNodeType.TEXT) {
                this.mergeAdjoiningTextNodesIntoList(leftList, appendingList);
            } else {
                for (BXml bxml : appendingList) {
                    this.addParent(bxml, this);
                }
                leftList.addAll(appendingList);
            }
        } else {
            this.addParent(seq, this);
            leftList.add(seq);
        }
        this.children = new XmlSequence(leftList);
    }

    private void addParent(BXml child) {
        this.ensureAcyclicGraph(child, this);
        this.addParent(child, this);
    }

    private void addParent(BXml child, XmlItem thisElem) {
        if (child.getNodeType() == XmlNodeType.ELEMENT) {
            ((XmlItem)child).probableParents.add(new WeakReference<XmlItem>(thisElem));
        }
    }

    private void ensureAcyclicGraph(BXml newSubTree, XmlItem current) {
        for (WeakReference<XmlItem> probableParentRef : current.probableParents) {
            XmlItem parent = (XmlItem)probableParentRef.get();
            if (!parent.children.children.contains(current)) continue;
            if (parent == newSubTree) {
                throw this.createXMLCycleError();
            }
            this.ensureAcyclicGraph(newSubTree, parent);
        }
    }

    private BallerinaException createXMLCycleError() {
        return new BallerinaException(BallerinaErrorReasons.XML_OPERATION_ERROR.getValue(), "Cycle detected");
    }

    private void mergeAdjoiningTextNodesIntoList(List leftList, List<BXml> appendingList) {
        XmlPi lastChild = (XmlPi)leftList.get(leftList.size() - 1);
        String firstChildContent = ((XmlPi)appendingList.get(0)).getData();
        String mergedTextContent = lastChild.getData() + firstChildContent;
        XmlText text = new XmlText(mergedTextContent);
        leftList.set(leftList.size() - 1, text);
        for (int i = 1; i < appendingList.size(); ++i) {
            leftList.add(appendingList.get(i));
        }
    }

    private boolean isLastChildIsTextNode(List<BXml> childList) {
        return !childList.isEmpty() && childList.get(childList.size() - 1).getNodeType() == XmlNodeType.TEXT;
    }

    @Override
    public XmlValue strip() {
        this.children.strip();
        return this;
    }

    @Override
    public XmlValue slice(long startIndex, long endIndex) {
        return this;
    }

    @Override
    public XmlValue descendants(List<String> qnames) {
        if (qnames.contains(this.getQName().toString())) {
            List<BXml> descendants = Arrays.asList(this);
            this.addDescendants(descendants, this, qnames);
            return new XmlSequence(descendants);
        }
        return this.children.descendants((List)qnames);
    }

    @Override
    public OMNode value() {
        try {
            String xmlStr = this.stringValue(null);
            OMElement omElement = XmlFactory.stringToOM(xmlStr);
            return omElement;
        }
        catch (ErrorValue e) {
            throw e;
        }
        catch (XMLStreamException | OMException e) {
            Throwable cause = e.getCause() == null ? e : e.getCause();
            throw ErrorCreator.createError(StringUtils.fromString(cause.getMessage()));
        }
        catch (Throwable e) {
            throw ErrorCreator.createError(StringUtils.fromString("failed to parse xml: " + e.getMessage()));
        }
    }

    public String toString() {
        return this.stringValue(null);
    }

    @Override
    @Deprecated
    public String stringValue(BLink parent) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            BallerinaXmlSerializer ballerinaXMLSerializer = new BallerinaXmlSerializer(outputStream);
            ballerinaXMLSerializer.write(this);
            ballerinaXMLSerializer.flush();
            String xml = new String(outputStream.toByteArray(), StandardCharsets.UTF_8);
            ballerinaXMLSerializer.close();
            return xml;
        }
        catch (Throwable t) {
            XmlItem.handleXmlException("failed to get xml as string: ", t);
            return RuntimeConstants.STRING_NULL_VALUE;
        }
    }

    @Override
    public String informalStringValue(BLink parent) {
        return "`" + this.toString() + "`";
    }

    @Override
    public String expressionStringValue(BLink parent) {
        return "xml`" + this.toString() + "`";
    }

    @Override
    public Object copy(Map<Object, Object> refs) {
        if (this.isFrozen()) {
            return this;
        }
        QName elemName = new QName(this.name.getNamespaceURI(), this.name.getLocalPart(), this.name.getPrefix());
        XmlItem xmlItem = new XmlItem(elemName, (XmlSequence)this.children.copy(refs));
        BMap attributesMap = xmlItem.getAttributesMap();
        MapValue copy = (MapValue)this.getAttributesMap().copy(refs);
        if (attributesMap instanceof MapValueImpl) {
            MapValueImpl map = (MapValueImpl)attributesMap;
            map.putAll((Map)((Object)copy));
        } else {
            for (Map.Entry entry : copy.entrySet()) {
                attributesMap.put((BString)entry.getKey(), (BString)entry.getValue());
            }
        }
        if (this.getAttributesMap().isFrozen()) {
            attributesMap.freezeDirect();
        }
        return xmlItem;
    }

    @Override
    public XmlValue getItem(int index) {
        if (index != 0) {
            return new XmlSequence();
        }
        return this;
    }

    @Override
    public int size() {
        return 1;
    }

    public int length() {
        return 1;
    }

    @Override
    public void build() {
    }

    @Override
    protected void setAttributesOnInitialization(BMap<BString, BString> attributes) {
        this.setAttributes(attributes, this::setAttributeOnInitialization);
    }

    @Override
    protected void setAttributeOnInitialization(String localName, String namespace, String prefix, String value) {
        this.attributes.setAttribute(localName, namespace, prefix, value, true);
    }

    @Override
    public void removeAttribute(String qname) {
        if (this.type.isReadOnly()) {
            ReadOnlyUtils.handleInvalidUpdate("lang.xml");
        }
        this.attributes.remove(qname);
    }

    @Override
    public void removeChildren(String qname) {
        if (this.type.isReadOnly()) {
            ReadOnlyUtils.handleInvalidUpdate("lang.xml");
        }
        List<BXml> children = this.children.children;
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        for (int i = 0; i < children.size(); ++i) {
            BXml child = children.get(i);
            if (child.getNodeType() != XmlNodeType.ELEMENT || !((XmlItem)child).getElementName().equals(qname)) continue;
            toRemove.add(i);
        }
        Collections.reverse(toRemove);
        for (Integer index : toRemove) {
            BXml removed = children.remove(index);
            this.removeParentReference(removed);
        }
    }

    private void setAttributes(BMap<BString, BString> attributes, SetAttributeFunction func) {
        for (BString qname : attributes.getKeys()) {
            String uri;
            String localName;
            if (qname.getValue().startsWith("{") && qname.getValue().indexOf(125) > 0) {
                localName = qname.getValue().substring(qname.getValue().indexOf(125) + 1);
                uri = qname.getValue().substring(1, qname.getValue().indexOf(125));
            } else {
                localName = qname.getValue();
                uri = RuntimeConstants.STRING_NULL_VALUE;
            }
            XmlValidator.validateXMLName(localName);
            func.set(localName, uri, RuntimeConstants.STRING_NULL_VALUE, attributes.get(qname).toString());
        }
    }

    private void removeParentReference(BXml removedItem) {
        if (removedItem.getNodeType() != XmlNodeType.ELEMENT) {
            return;
        }
        XmlItem item = (XmlItem)removedItem;
        Iterator<WeakReference<XmlItem>> iterator = item.probableParents.iterator();
        while (iterator.hasNext()) {
            WeakReference<XmlItem> probableParent = iterator.next();
            XmlItem parent = (XmlItem)probableParent.get();
            if (parent != this) continue;
            probableParent.clear();
            iterator.remove();
        }
    }

    @Override
    public void freezeDirect() {
        this.type = ReadOnlyUtils.setImmutableTypeAndGetEffectiveType(this.type);
        this.children.freezeDirect();
        this.attributes.freezeDirect();
    }

    private QName getQName(String localName, String namespaceUri, String prefix) {
        if (namespaceUri == null || namespaceUri.isEmpty()) {
            return new QName(localName);
        }
        if (prefix == null || prefix.isEmpty()) {
            return new QName(namespaceUri, localName);
        }
        return new QName(namespaceUri, localName, prefix);
    }

    @Override
    public BXmlSequence getChildrenSeq() {
        return this.children;
    }

    @Override
    public IteratorValue getIterator() {
        final XmlItem that = this;
        return new IteratorValue(){
            boolean read = false;

            @Override
            public boolean hasNext() {
                return !this.read;
            }

            public Object next() {
                if (this.read) {
                    throw new NoSuchElementException();
                }
                this.read = true;
                return that;
            }
        };
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof XmlItem) {
            XmlItem that = (XmlItem)obj;
            boolean qNameEquals = that.getQName().equals(this.getQName());
            if (!qNameEquals) {
                return false;
            }
            boolean attrMapEquals = that.attributes.entrySet().equals(this.attributes.entrySet());
            if (!attrMapEquals) {
                return false;
            }
            return that.children.equals(this.children);
        }
        if (obj instanceof XmlSequence) {
            XmlSequence other = (XmlSequence)obj;
            return other.children.size() == 1 && this.equals(other.children.get(0));
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.children, this.attributes, this.probableParents);
    }

    public static XmlItem createXMLItemWithDefaultNSAttribute(QName name, boolean readonly, String defaultNsUri) {
        XmlItem item = new XmlItem(name, readonly);
        if (!defaultNsUri.isEmpty()) {
            item.setAttributeOnInitialization("xmlns", null, null, defaultNsUri);
        }
        return item;
    }

    private static interface SetAttributeFunction {
        public void set(String var1, String var2, String var3, String var4);
    }
}

