/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.observability;

import io.ballerina.runtime.internal.values.ErrorValue;
import io.ballerina.runtime.observability.ObserverContext;
import io.ballerina.runtime.observability.metrics.Tag;
import io.ballerina.runtime.observability.tracer.BSpan;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class TracingUtils {
    private static final String SEPARATOR = ":";

    private TracingUtils() {
    }

    public static void startObservation(ObserverContext observerContext, boolean isClient) {
        BSpan span = new BSpan(observerContext, isClient);
        span.setServiceName(observerContext.getServiceName() != null ? observerContext.getServiceName() : "Unknown Service");
        if (isClient) {
            span.setOperationName((String)(StringUtils.isNotEmpty(observerContext.getObjectName()) ? observerContext.getObjectName() + SEPARATOR + observerContext.getFunctionName() : observerContext.getFunctionName()));
            observerContext.addProperty("trace_properties", span.getProperties());
        } else {
            span.setOperationName(observerContext.getResourceName());
            Map httpHeaders = (Map)observerContext.getProperty("trace_properties");
            if (httpHeaders != null) {
                httpHeaders.entrySet().forEach(e -> span.addProperty((String)e.getKey(), (String)e.getValue()));
            }
        }
        observerContext.addProperty("_span_", span);
        span.startSpan();
    }

    public static void stopObservation(ObserverContext observerContext) {
        BSpan span = (BSpan)observerContext.getProperty("_span_");
        if (span != null) {
            Integer statusCode;
            Tag errorTag = observerContext.getTag("error");
            if (errorTag != null && "true".equals(errorTag.getValue())) {
                ErrorValue bError;
                StringBuilder errorMessageBuilder = new StringBuilder();
                String errorMessage = (String)observerContext.getProperty("error_message");
                if (errorMessage != null) {
                    errorMessageBuilder.append(errorMessage);
                }
                if ((bError = (ErrorValue)observerContext.getProperty("bstruct_error")) != null) {
                    if (errorMessage != null) {
                        errorMessageBuilder.append('\n');
                    }
                    errorMessageBuilder.append(bError.getPrintableStackTrace());
                }
                HashMap<String, Object> logProps = new HashMap<String, Object>();
                logProps.put("error.kind", "Exception");
                logProps.put("event", "error");
                logProps.put("message", errorMessageBuilder.toString());
                span.logError(logProps);
            }
            if ((statusCode = (Integer)observerContext.getProperty("http.status_code")) != null && statusCode >= 100) {
                span.addTags(Collections.singletonMap("http.status_code", Integer.toString(statusCode)));
            }
            span.addTags(observerContext.getAllTags().stream().collect(Collectors.toMap(Tag::getKey, Tag::getValue)));
            span.finishSpan();
        }
    }
}

