/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.observability.tracer;

import io.ballerina.runtime.observability.ObserverContext;
import io.ballerina.runtime.observability.tracer.TraceManager;
import io.opentracing.Span;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class BSpan {
    private static final TraceManager manager = TraceManager.getInstance();
    private final Map<String, String> properties = new HashMap<String, String>();
    private final Map<String, String> tags = new HashMap<String, String>();
    private String serviceName = "BallerinaService";
    private String operationName = "BallerinaOperation";
    private final ObserverContext observerContext;
    private Span span;

    public BSpan(ObserverContext observerContext, boolean isClientContext) {
        this.observerContext = observerContext;
        this.tags.put("span.kind", isClientContext ? "client" : "server");
    }

    public void startSpan() {
        manager.startSpan(this.getParentBSpan(), this);
    }

    public void finishSpan() {
        manager.finishSpan(this);
    }

    public void log(Map<String, Object> fields) {
        manager.log(this, fields);
    }

    public void logError(Map<String, Object> fields) {
        this.addTags(Collections.singletonMap("error", "true"));
        manager.log(this, fields);
    }

    public void addTags(Map<String, String> tags) {
        if (this.span != null) {
            manager.addTags(this, tags);
        } else {
            this.tags.putAll(tags);
        }
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void addProperty(String key, String value) {
        if (this.properties != null) {
            this.properties.put(key, value);
        }
    }

    public String getProperty(String key) {
        if (this.properties != null) {
            return this.properties.get(key);
        }
        return null;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public Span getSpan() {
        return this.span;
    }

    public void setSpan(Span span) {
        this.span = span;
    }

    public Map<String, String> getTraceContext() {
        return manager.extractTraceContext(this.span, this.serviceName);
    }

    private BSpan getParentBSpan() {
        if (this.observerContext.getParent() != null) {
            return (BSpan)this.observerContext.getParent().getProperty("_span_");
        }
        return null;
    }
}

