/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.api;

import io.ballerina.toml.semantic.TomlType;
import io.ballerina.toml.semantic.ast.TomlKeyValueNode;
import io.ballerina.toml.semantic.ast.TomlTableArrayNode;
import io.ballerina.toml.semantic.ast.TomlTableNode;
import io.ballerina.toml.semantic.ast.TomlTransformer;
import io.ballerina.toml.semantic.ast.TomlValueNode;
import io.ballerina.toml.semantic.ast.TopLevelNode;
import io.ballerina.toml.semantic.diagnostics.DiagnosticComparator;
import io.ballerina.toml.semantic.diagnostics.TomlDiagnostic;
import io.ballerina.toml.semantic.diagnostics.TomlNodeLocation;
import io.ballerina.toml.syntax.tree.DocumentNode;
import io.ballerina.toml.syntax.tree.SyntaxTree;
import io.ballerina.toml.validator.TomlValidator;
import io.ballerina.toml.validator.schema.Schema;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

@Deprecated
public class Toml {
    private TomlTableNode rootNode;

    private Toml(TomlTableNode tomlTableNode) {
        this.rootNode = tomlTableNode;
    }

    public static Toml read(Path path) throws IOException {
        Path fileNamePath = path.getFileName();
        if (fileNamePath == null) {
            return null;
        }
        return Toml.read(Files.readString(path), fileNamePath.toString());
    }

    public static Toml read(Path path, Schema schema) throws IOException {
        Path fileNamePath = path.getFileName();
        if (fileNamePath == null) {
            return null;
        }
        return Toml.read(Files.readString(path), fileNamePath.toString(), schema);
    }

    public static Toml read(InputStream inputStream) throws IOException {
        return Toml.read(new String(inputStream.readAllBytes(), StandardCharsets.UTF_8), null);
    }

    public static Toml read(InputStream inputStream, Schema schema) throws IOException {
        return Toml.read(new String(inputStream.readAllBytes(), StandardCharsets.UTF_8), null, schema);
    }

    public static Toml read(String content, String filePath) {
        TextDocument textDocument = TextDocuments.from(content);
        SyntaxTree syntaxTree = SyntaxTree.from(textDocument, filePath);
        TomlTransformer nodeTransformer = new TomlTransformer();
        TomlTableNode transformedTable = (TomlTableNode)nodeTransformer.transform((DocumentNode)syntaxTree.rootNode());
        transformedTable.addSyntaxDiagnostics(Toml.reportSyntaxDiagnostics(syntaxTree));
        return new Toml(transformedTable);
    }

    public static Toml read(String content, String filePath, Schema schema) {
        TextDocument textDocument = TextDocuments.from(content);
        SyntaxTree syntaxTree = SyntaxTree.from(textDocument, filePath);
        TomlTransformer nodeTransformer = new TomlTransformer();
        TomlTableNode transformedTable = (TomlTableNode)nodeTransformer.transform((DocumentNode)syntaxTree.rootNode());
        transformedTable.addSyntaxDiagnostics(Toml.reportSyntaxDiagnostics(syntaxTree));
        Toml toml = new Toml(transformedTable);
        TomlValidator tomlValidator = new TomlValidator(schema);
        tomlValidator.validate(toml);
        return toml;
    }

    private static Set<Diagnostic> reportSyntaxDiagnostics(SyntaxTree tree) {
        TreeSet<Diagnostic> diagnostics = new TreeSet<Diagnostic>(new DiagnosticComparator());
        for (Diagnostic syntaxDiagnostic : tree.diagnostics()) {
            TomlNodeLocation tomlNodeLocation = new TomlNodeLocation(syntaxDiagnostic.location().lineRange(), syntaxDiagnostic.location().textRange());
            TomlDiagnostic tomlDiagnostic = new TomlDiagnostic(tomlNodeLocation, syntaxDiagnostic.diagnosticInfo(), syntaxDiagnostic.message());
            diagnostics.add(tomlDiagnostic);
        }
        return diagnostics;
    }

    public <T extends TomlValueNode> T get(String key) {
        TomlKeyValueNode tomlKeyValueNode = (TomlKeyValueNode)this.rootNode.entries().get(key);
        if (tomlKeyValueNode == null || tomlKeyValueNode.value() == null) {
            return null;
        }
        TomlValueNode value = tomlKeyValueNode.value();
        return (T)value;
    }

    public Toml getTable(String key) {
        TopLevelNode topLevelNode = this.rootNode.entries().get(key);
        if (topLevelNode == null || topLevelNode.kind() != TomlType.TABLE) {
            return null;
        }
        return new Toml((TomlTableNode)topLevelNode);
    }

    public List<Toml> getTables(String key) {
        TopLevelNode tableNode = this.rootNode.entries().get(key);
        if (tableNode == null || tableNode.kind() != TomlType.TABLE_ARRAY) {
            return null;
        }
        TomlTableArrayNode tomlTableArrayNode = (TomlTableArrayNode)tableNode;
        List<TomlTableNode> childs = tomlTableArrayNode.children();
        ArrayList<Toml> tomlList = new ArrayList<Toml>();
        for (TomlTableNode child : childs) {
            tomlList.add(new Toml(child));
        }
        return tomlList;
    }

    public List<Diagnostic> diagnostics() {
        return new ArrayList<Diagnostic>(this.rootNode.diagnostics());
    }

    public TomlTableNode rootNode() {
        return this.rootNode;
    }
}

