/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.internal.parser;

import io.ballerina.toml.internal.parser.AbstractTokenReader;
import io.ballerina.toml.internal.parser.ParserRuleContext;
import io.ballerina.toml.internal.parser.SyntaxErrors;
import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.internal.parser.tree.STToken;
import io.ballerina.toml.syntax.tree.SyntaxKind;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractParserErrorHandler {
    protected final AbstractTokenReader tokenReader;
    private ArrayDeque<ParserRuleContext> ctxStack = new ArrayDeque();
    private int previousTokenIndex;
    private int itterCount;
    protected static final int LOOKAHEAD_LIMIT = 5;
    private static final int ITTER_LIMIT = 7;

    public AbstractParserErrorHandler(AbstractTokenReader tokenReader) {
        this.tokenReader = tokenReader;
        this.previousTokenIndex = -1;
        this.itterCount = 0;
    }

    protected abstract boolean isProductionWithAlternatives(ParserRuleContext var1);

    protected abstract Result seekMatch(ParserRuleContext var1, int var2, int var3, boolean var4);

    protected abstract ParserRuleContext getNextRule(ParserRuleContext var1, int var2);

    protected abstract SyntaxKind getExpectedTokenKind(ParserRuleContext var1);

    public Solution recover(ParserRuleContext currentCtx, STToken nextToken, Object ... args) {
        if (nextToken.kind == SyntaxKind.EOF_TOKEN) {
            SyntaxKind expectedTokenKind = this.getExpectedTokenKind(currentCtx);
            Solution fix = new Solution(Action.INSERT, currentCtx, expectedTokenKind, currentCtx.toString());
            this.applyFix(currentCtx, fix, args);
            return fix;
        }
        int currentTokenIndex = this.tokenReader.getCurrentTokenIndex();
        if (currentTokenIndex == this.previousTokenIndex) {
            ++this.itterCount;
        } else {
            this.itterCount = 0;
            this.previousTokenIndex = currentTokenIndex;
        }
        if (this.itterCount < 7) {
            Solution sol;
            Result bestMatch = this.seekMatch(currentCtx);
            if (bestMatch.matches > 0 && (sol = bestMatch.solution) != null) {
                this.applyFix(currentCtx, sol, args);
                return sol;
            }
        }
        Solution sol = new Solution(Action.REMOVE, currentCtx, nextToken.kind, nextToken.toString());
        sol.removedToken = this.consumeInvalidToken();
        return sol;
    }

    public STToken consumeInvalidToken() {
        return this.tokenReader.read();
    }

    private void applyFix(ParserRuleContext currentCtx, Solution fix, Object ... args) {
        if (fix.action == Action.REMOVE) {
            fix.removedToken = this.consumeInvalidToken();
            fix.recoveredNode = this.tokenReader.peek();
            fix.tokenKind = this.tokenReader.peek().kind;
        } else {
            fix.recoveredNode = this.handleMissingToken(currentCtx, fix);
        }
    }

    private STNode handleMissingToken(ParserRuleContext currentCtx, Solution fix) {
        return SyntaxErrors.createMissingTokenWithDiagnostics(fix.tokenKind, fix.ctx);
    }

    private ArrayDeque<ParserRuleContext> getCtxStackSnapshot() {
        return this.ctxStack.clone();
    }

    private Result seekMatch(ParserRuleContext currentCtx) {
        return this.seekMatchInSubTree(currentCtx, 1, 0, true);
    }

    protected Result seekMatchInSubTree(ParserRuleContext currentCtx, int lookahead, int currentDepth, boolean isEntryPoint) {
        ArrayDeque<ParserRuleContext> tempCtxStack = this.ctxStack;
        this.ctxStack = this.getCtxStackSnapshot();
        Result result = this.seekMatch(currentCtx, lookahead, currentDepth, isEntryPoint);
        this.ctxStack = tempCtxStack;
        return result;
    }

    public void startContext(ParserRuleContext context) {
        this.ctxStack.push(context);
    }

    public void endContext() {
        this.ctxStack.pop();
    }

    public void switchContext(ParserRuleContext context) {
        this.ctxStack.pop();
        this.ctxStack.push(context);
    }

    protected ParserRuleContext getParentContext() {
        return this.ctxStack.peek();
    }

    protected ParserRuleContext getGrandParentContext() {
        ParserRuleContext parent = this.ctxStack.pop();
        ParserRuleContext grandParent = this.ctxStack.peek();
        this.ctxStack.push(parent);
        return grandParent;
    }

    protected Result seekInAlternativesPaths(int lookahead, int currentDepth, int currentMatches, ParserRuleContext[] alternativeRules, boolean isEntryPoint) {
        List[] results = new List[5];
        int bestMatchIndex = 0;
        for (ParserRuleContext rule : alternativeRules) {
            Result result = this.seekMatchInSubTree(rule, lookahead, currentDepth, isEntryPoint);
            if (result.matches >= 4) {
                return this.getFinalResult(currentMatches, result);
            }
            ArrayList<Result> similarResutls = results[result.matches];
            if (similarResutls == null) {
                results[result.matches] = similarResutls = new ArrayList<Result>(5);
                if (bestMatchIndex < result.matches) {
                    bestMatchIndex = result.matches;
                }
            }
            similarResutls.add(result);
        }
        if (bestMatchIndex == 0) {
            return new Result(new ArrayDeque<Solution>(), currentMatches);
        }
        List bestMatches = results[bestMatchIndex];
        Result bestMatch = (Result)bestMatches.get(0);
        for (int i = 1; i < bestMatches.size(); ++i) {
            int bestmatchFixesSize;
            Result currentMatch = (Result)bestMatches.get(i);
            int currentMatchFixesSize = currentMatch.fixes.size();
            if (currentMatchFixesSize == (bestmatchFixesSize = bestMatch.fixes.size())) {
                if (bestmatchFixesSize == 0) continue;
                Solution currentSol = bestMatch.fixes.peek();
                Solution foundSol = currentMatch.fixes.peek();
                if (currentSol.action == Action.REMOVE && foundSol.action == Action.INSERT) {
                    bestMatch = currentMatch;
                }
            }
            if (currentMatchFixesSize >= bestmatchFixesSize) continue;
            bestMatch = currentMatch;
        }
        return this.getFinalResult(currentMatches, bestMatch);
    }

    protected Result getFinalResult(int currentMatches, Result bestMatch) {
        bestMatch.matches += currentMatches;
        return bestMatch;
    }

    protected Result fixAndContinue(ParserRuleContext currentCtx, int lookahead, int currentDepth, int matchingRulesCount, boolean isEntryPoint) {
        Result fixedPathResult = this.fixAndContinue(currentCtx, lookahead, currentDepth + 1);
        fixedPathResult.solution = isEntryPoint ? fixedPathResult.fixes.peek() : new Solution(Action.KEEP, currentCtx, this.getExpectedTokenKind(currentCtx), currentCtx.toString());
        return this.getFinalResult(matchingRulesCount, fixedPathResult);
    }

    protected Result fixAndContinue(ParserRuleContext currentCtx, int lookahead, int currentDepth) {
        Result fixedPathResult;
        Result deletionResult = this.seekMatchInSubTree(currentCtx, lookahead + 1, currentDepth, false);
        ParserRuleContext nextCtx = this.getNextRule(currentCtx, lookahead);
        Result insertionResult = this.seekMatchInSubTree(nextCtx, lookahead, currentDepth, false);
        if (insertionResult.matches == 0 && deletionResult.matches == 0) {
            fixedPathResult = insertionResult;
        } else if (insertionResult.matches == deletionResult.matches) {
            if (insertionResult.fixes.size() <= deletionResult.fixes.size()) {
                Solution action = new Solution(Action.INSERT, currentCtx, this.getExpectedTokenKind(currentCtx), currentCtx.toString());
                insertionResult.fixes.push(action);
                fixedPathResult = insertionResult;
            } else {
                STToken token = this.tokenReader.peek(lookahead);
                Solution action = new Solution(Action.REMOVE, currentCtx, token.kind, token.toString());
                deletionResult.fixes.push(action);
                fixedPathResult = deletionResult;
            }
        } else if (insertionResult.matches > deletionResult.matches) {
            Solution action = new Solution(Action.INSERT, currentCtx, this.getExpectedTokenKind(currentCtx), currentCtx.toString());
            insertionResult.fixes.push(action);
            fixedPathResult = insertionResult;
        } else {
            STToken token = this.tokenReader.peek(lookahead);
            Solution action = new Solution(Action.REMOVE, currentCtx, token.kind, token.toString());
            deletionResult.fixes.push(action);
            fixedPathResult = deletionResult;
        }
        return fixedPathResult;
    }

    protected static enum Action {
        INSERT,
        REMOVE,
        KEEP;

    }

    public static class Result {
        protected int matches;
        protected ArrayDeque<Solution> fixes;
        protected Solution solution;

        public Result(ArrayDeque<Solution> fixes, int matches) {
            this.fixes = fixes;
            this.matches = matches;
        }
    }

    public static class Solution {
        public ParserRuleContext ctx;
        public Action action;
        public String tokenText;
        public SyntaxKind tokenKind;
        public STNode recoveredNode;
        public STToken removedToken;

        public Solution(Action action, ParserRuleContext ctx, SyntaxKind tokenKind, String tokenText) {
            this.action = action;
            this.ctx = ctx;
            this.tokenText = tokenText;
            this.tokenKind = tokenKind;
        }

        public String toString() {
            return this.action.toString() + "'" + this.tokenText + "'";
        }
    }
}

