/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.internal.parser;

import io.ballerina.toml.internal.parser.AbstractParserErrorHandler;
import io.ballerina.toml.internal.parser.AbstractTokenReader;
import io.ballerina.toml.internal.parser.ParserRuleContext;
import io.ballerina.toml.internal.parser.tree.STToken;
import io.ballerina.toml.syntax.tree.SyntaxKind;
import java.util.ArrayDeque;

public class TomlParserErrorHandler
extends AbstractParserErrorHandler {
    private static final ParserRuleContext[] TOP_LEVEL_NODE = new ParserRuleContext[]{ParserRuleContext.EOF, ParserRuleContext.NEWLINE, ParserRuleContext.KEY_VALUE_PAIR, ParserRuleContext.TOML_TABLE, ParserRuleContext.TOML_TABLE_ARRAY};
    private static final ParserRuleContext[] ARRAY_VALUE_END = new ParserRuleContext[]{ParserRuleContext.COMMA, ParserRuleContext.ARRAY_VALUE_LIST_END};
    private static final ParserRuleContext[] ARRAY_VALUE_START_OR_VALUE_LIST_END = new ParserRuleContext[]{ParserRuleContext.ARRAY_VALUE_LIST_END, ParserRuleContext.ARRAY_VALUE_START};
    private static final ParserRuleContext[] NUMERICAL_LITERAL = new ParserRuleContext[]{ParserRuleContext.DECIMAL_INTEGER_LITERAL, ParserRuleContext.DECIMAL_FLOATING_POINT_LITERAL};
    private static final ParserRuleContext[] VALUE = new ParserRuleContext[]{ParserRuleContext.STRING_START, ParserRuleContext.SIGN_TOKEN, ParserRuleContext.BOOLEAN_LITERAL, ParserRuleContext.NUMERICAL_LITERAL};
    private static final ParserRuleContext[] ARRAY_VALUE_START = VALUE;
    private static final ParserRuleContext[] KEY_START = new ParserRuleContext[]{ParserRuleContext.IDENTIFIER_LITERAL, ParserRuleContext.NUMERICAL_LITERAL, ParserRuleContext.BOOLEAN_LITERAL, ParserRuleContext.STRING_START};
    private static final ParserRuleContext[] KEY_END = new ParserRuleContext[]{ParserRuleContext.DOT, ParserRuleContext.KEY_LIST_END};
    private static final ParserRuleContext[] KEY_LIST_END = new ParserRuleContext[]{ParserRuleContext.ASSIGN_OP, ParserRuleContext.TABLE_END, ParserRuleContext.ARRAY_TABLE_FIRST_END};

    public TomlParserErrorHandler(AbstractTokenReader tokenReader) {
        super(tokenReader);
    }

    @Override
    protected boolean isProductionWithAlternatives(ParserRuleContext currentCtx) {
        switch (currentCtx) {
            case TOP_LEVEL_NODE: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected AbstractParserErrorHandler.Result seekMatch(ParserRuleContext currentCtx, int lookahead, int currentDepth, boolean isEntryPoint) {
        int matchingRulesCount = 0;
        while (currentDepth < 5) {
            boolean hasMatch = true;
            boolean skipRule = false;
            STToken nextToken = this.tokenReader.peek(lookahead);
            switch (currentCtx) {
                case EOF: {
                    hasMatch = nextToken.kind == SyntaxKind.EOF_TOKEN;
                    break;
                }
                case ASSIGN_OP: {
                    hasMatch = nextToken.kind == SyntaxKind.EQUAL_TOKEN;
                    break;
                }
                case ARRAY_TABLE_FIRST_START: 
                case ARRAY_TABLE_SECOND_START: 
                case TABLE_START: 
                case ARRAY_VALUE_LIST_START: {
                    hasMatch = nextToken.kind == SyntaxKind.OPEN_BRACKET_TOKEN;
                    break;
                }
                case ARRAY_TABLE_FIRST_END: 
                case ARRAY_TABLE_SECOND_END: 
                case TABLE_END: 
                case ARRAY_VALUE_LIST_END: {
                    hasMatch = nextToken.kind == SyntaxKind.CLOSE_BRACKET_TOKEN;
                    break;
                }
                case STRING_START: 
                case STRING_END: {
                    hasMatch = nextToken.kind == SyntaxKind.DOUBLE_QUOTE_TOKEN;
                    break;
                }
                case COMMA: {
                    hasMatch = nextToken.kind == SyntaxKind.COMMA_TOKEN;
                    break;
                }
                case DOT: {
                    hasMatch = nextToken.kind == SyntaxKind.DOT_TOKEN;
                    break;
                }
                case DECIMAL_INTEGER_LITERAL: {
                    hasMatch = nextToken.kind == SyntaxKind.DECIMAL_INT_TOKEN;
                    break;
                }
                case DECIMAL_FLOATING_POINT_LITERAL: {
                    hasMatch = nextToken.kind == SyntaxKind.DECIMAL_FLOAT_TOKEN;
                    break;
                }
                case BOOLEAN_LITERAL: {
                    hasMatch = nextToken.kind == SyntaxKind.TRUE_KEYWORD || nextToken.kind == SyntaxKind.FALSE_KEYWORD;
                    break;
                }
                case STRING_CONTENT: {
                    hasMatch = nextToken.kind == SyntaxKind.STRING_LITERAL_TOKEN || nextToken.kind == SyntaxKind.ML_STRING_LITERAL || nextToken.kind == SyntaxKind.IDENTIFIER_LITERAL;
                    break;
                }
                case IDENTIFIER_LITERAL: {
                    hasMatch = nextToken.kind == SyntaxKind.IDENTIFIER_LITERAL;
                    break;
                }
                case NEWLINE: {
                    hasMatch = nextToken.kind == SyntaxKind.NEWLINE;
                    break;
                }
                case SIGN_TOKEN: {
                    hasMatch = nextToken.kind == SyntaxKind.PLUS_TOKEN || nextToken.kind == SyntaxKind.MINUS_TOKEN;
                    break;
                }
                case NUMERICAL_LITERAL: {
                    ParserRuleContext[] alternativeRules = NUMERICAL_LITERAL;
                    return this.seekInAlternativesPaths(lookahead, currentDepth, matchingRulesCount, alternativeRules, isEntryPoint);
                }
                case VALUE: {
                    ParserRuleContext[] alternativeRules = VALUE;
                    return this.seekInAlternativesPaths(lookahead, currentDepth, matchingRulesCount, alternativeRules, isEntryPoint);
                }
                case TOP_LEVEL_NODE: {
                    ParserRuleContext[] alternativeRules = TOP_LEVEL_NODE;
                    return this.seekInAlternativesPaths(lookahead, currentDepth, matchingRulesCount, alternativeRules, isEntryPoint);
                }
                case ARRAY_VALUE_END: {
                    ParserRuleContext[] alternativeRules = ARRAY_VALUE_END;
                    return this.seekInAlternativesPaths(lookahead, currentDepth, matchingRulesCount, alternativeRules, isEntryPoint);
                }
                case ARRAY_VALUE_START: {
                    ParserRuleContext[] alternativeRules = ARRAY_VALUE_START;
                    return this.seekInAlternativesPaths(lookahead, currentDepth, matchingRulesCount, alternativeRules, isEntryPoint);
                }
                case ARRAY_VALUE_START_OR_VALUE_LIST_END: {
                    ParserRuleContext[] alternativeRules = ARRAY_VALUE_START_OR_VALUE_LIST_END;
                    return this.seekInAlternativesPaths(lookahead, currentDepth, matchingRulesCount, alternativeRules, isEntryPoint);
                }
                case KEY_START: {
                    ParserRuleContext[] alternativeRules = KEY_START;
                    return this.seekInAlternativesPaths(lookahead, currentDepth, matchingRulesCount, alternativeRules, isEntryPoint);
                }
                case KEY_END: {
                    ParserRuleContext[] alternativeRules = KEY_END;
                    return this.seekInAlternativesPaths(lookahead, currentDepth, matchingRulesCount, alternativeRules, isEntryPoint);
                }
                case KEY_LIST_END: {
                    ParserRuleContext[] alternativeRules = KEY_LIST_END;
                    return this.seekInAlternativesPaths(lookahead, currentDepth, matchingRulesCount, alternativeRules, isEntryPoint);
                }
                default: {
                    skipRule = true;
                    hasMatch = true;
                }
            }
            if (!hasMatch) {
                return this.fixAndContinue(currentCtx, lookahead, currentDepth, matchingRulesCount, isEntryPoint);
            }
            currentCtx = this.getNextRule(currentCtx, lookahead + 1);
            if (skipRule) continue;
            ++currentDepth;
            ++matchingRulesCount;
            ++lookahead;
            isEntryPoint = false;
        }
        AbstractParserErrorHandler.Result result = new AbstractParserErrorHandler.Result(new ArrayDeque<AbstractParserErrorHandler.Solution>(), matchingRulesCount);
        result.solution = new AbstractParserErrorHandler.Solution(AbstractParserErrorHandler.Action.KEEP, currentCtx, SyntaxKind.NONE, currentCtx.toString());
        return result;
    }

    private void startContextIfRequired(ParserRuleContext currentCtx) {
        switch (currentCtx) {
            case TOML_TABLE_ARRAY: 
            case TOML_TABLE: 
            case KEY_VALUE_PAIR: 
            case ARRAY_VALUE_LIST: 
            case KEY_LIST: {
                this.startContext(currentCtx);
                break;
            }
        }
    }

    @Override
    protected ParserRuleContext getNextRule(ParserRuleContext currentCtx, int nextLookahead) {
        this.startContextIfRequired(currentCtx);
        switch (currentCtx) {
            case EOF: {
                return ParserRuleContext.EOF;
            }
            case ARRAY_TABLE_SECOND_END: 
            case TABLE_END: 
            case ARRAY_VALUE_LIST_END: {
                this.endContext();
                return ParserRuleContext.NEWLINE;
            }
            case ASSIGN_OP: {
                this.endContext();
                return ParserRuleContext.VALUE;
            }
            case NEWLINE: {
                return ParserRuleContext.TOP_LEVEL_NODE;
            }
            case ARRAY_TABLE_SECOND_START: 
            case TABLE_START: 
            case KEY_VALUE_PAIR: {
                return ParserRuleContext.KEY_LIST;
            }
            case ARRAY_TABLE_FIRST_START: {
                return ParserRuleContext.ARRAY_TABLE_SECOND_START;
            }
            case ARRAY_TABLE_FIRST_END: {
                return ParserRuleContext.ARRAY_TABLE_SECOND_END;
            }
            case TOML_TABLE: {
                return ParserRuleContext.TABLE_START;
            }
            case TOML_TABLE_ARRAY: {
                return ParserRuleContext.ARRAY_TABLE_FIRST_START;
            }
            case COMMA: {
                return ParserRuleContext.ARRAY_VALUE_START;
            }
            case SIGN_TOKEN: {
                return ParserRuleContext.NUMERICAL_LITERAL;
            }
            case DOT: 
            case KEY_LIST: {
                return ParserRuleContext.KEY_START;
            }
            case ARRAY_VALUE_LIST_START: {
                return ParserRuleContext.ARRAY_VALUE_LIST;
            }
            case ARRAY_VALUE_LIST: {
                return ParserRuleContext.ARRAY_VALUE_START_OR_VALUE_LIST_END;
            }
            case STRING_START: {
                return ParserRuleContext.STRING_CONTENT;
            }
            case STRING_CONTENT: {
                return ParserRuleContext.STRING_END;
            }
            case STRING_END: 
            case DECIMAL_INTEGER_LITERAL: 
            case DECIMAL_FLOATING_POINT_LITERAL: 
            case BOOLEAN_LITERAL: {
                ParserRuleContext parentCtx = this.getParentContext();
                if (parentCtx == ParserRuleContext.ARRAY_VALUE_LIST) {
                    return ParserRuleContext.ARRAY_VALUE_END;
                }
                if (parentCtx == ParserRuleContext.KEY_LIST) {
                    return ParserRuleContext.KEY_END;
                }
                return ParserRuleContext.NEWLINE;
            }
            case IDENTIFIER_LITERAL: {
                return ParserRuleContext.KEY_END;
            }
        }
        throw new IllegalStateException("Next rule is not handled " + currentCtx);
    }

    @Override
    protected SyntaxKind getExpectedTokenKind(ParserRuleContext ctx) {
        switch (ctx) {
            case TOML_TABLE: {
                return SyntaxKind.TABLE;
            }
            case TOML_TABLE_ARRAY: {
                return SyntaxKind.TABLE_ARRAY;
            }
            case KEY_VALUE_PAIR: {
                return SyntaxKind.KEY_VALUE;
            }
            case ASSIGN_OP: {
                return SyntaxKind.EQUAL_TOKEN;
            }
            case IDENTIFIER_LITERAL: {
                return SyntaxKind.IDENTIFIER_LITERAL;
            }
            case EOF: {
                return SyntaxKind.EOF_TOKEN;
            }
            case COMMA: {
                return SyntaxKind.COMMA_TOKEN;
            }
            case STRING_START: 
            case STRING_END: {
                return SyntaxKind.DOUBLE_QUOTE_TOKEN;
            }
            case STRING_CONTENT: {
                return SyntaxKind.IDENTIFIER_LITERAL;
            }
            case TABLE_START: 
            case ARRAY_VALUE_LIST_START: {
                return SyntaxKind.OPEN_BRACKET_TOKEN;
            }
            case TABLE_END: 
            case ARRAY_VALUE_LIST_END: {
                return SyntaxKind.CLOSE_BRACKET_TOKEN;
            }
            case DECIMAL_INTEGER_LITERAL: {
                return SyntaxKind.DECIMAL_INT_TOKEN;
            }
            case DECIMAL_FLOATING_POINT_LITERAL: {
                return SyntaxKind.DECIMAL_FLOAT_TOKEN;
            }
            case BOOLEAN_LITERAL: {
                return SyntaxKind.FALSE_KEYWORD;
            }
            case NEWLINE: {
                return SyntaxKind.NEWLINE;
            }
            case DOT: {
                return SyntaxKind.DOT_TOKEN;
            }
            case ARRAY_TABLE_FIRST_END: 
            case ARRAY_TABLE_SECOND_END: {
                return SyntaxKind.CLOSE_BRACKET_TOKEN;
            }
            case ARRAY_TABLE_FIRST_START: 
            case ARRAY_TABLE_SECOND_START: {
                return SyntaxKind.OPEN_BRACKET_TOKEN;
            }
            case SIGN_TOKEN: {
                return SyntaxKind.PLUS_TOKEN;
            }
        }
        return SyntaxKind.NONE;
    }
}

