/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.internal.parser.tree;

import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.toml.internal.parser.tree.STNodeTransformer;
import io.ballerina.toml.internal.parser.tree.STNodeVisitor;
import io.ballerina.toml.internal.parser.tree.STValueNode;
import io.ballerina.toml.syntax.tree.ArrayNode;
import io.ballerina.toml.syntax.tree.Node;
import io.ballerina.toml.syntax.tree.NonTerminalNode;
import io.ballerina.toml.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STArrayNode
extends STValueNode {
    public final STNode openBracket;
    public final STNode values;
    public final STNode closeBracket;

    STArrayNode(STNode openBracket, STNode values, STNode closeBracket) {
        this(openBracket, values, closeBracket, Collections.emptyList());
    }

    STArrayNode(STNode openBracket, STNode values, STNode closeBracket, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.ARRAY, diagnostics);
        this.openBracket = openBracket;
        this.values = values;
        this.closeBracket = closeBracket;
        this.addChildren(openBracket, values, closeBracket);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STArrayNode(this.openBracket, this.values, this.closeBracket, diagnostics);
    }

    public STArrayNode modify(STNode openBracket, STNode values, STNode closeBracket) {
        if (this.checkForReferenceEquality(openBracket, values, closeBracket)) {
            return this;
        }
        return new STArrayNode(openBracket, values, closeBracket, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ArrayNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

