/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.internal.parser.tree;

import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.toml.internal.parser.tree.STNodeTransformer;
import io.ballerina.toml.internal.parser.tree.STNodeVisitor;
import io.ballerina.toml.internal.parser.tree.STValueNode;
import io.ballerina.toml.syntax.tree.Node;
import io.ballerina.toml.syntax.tree.NonTerminalNode;
import io.ballerina.toml.syntax.tree.StringLiteralNode;
import io.ballerina.toml.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STStringLiteralNode
extends STValueNode {
    public final STNode startDoubleQuote;
    public final STNode content;
    public final STNode endDoubleQuote;

    STStringLiteralNode(STNode startDoubleQuote, STNode content, STNode endDoubleQuote) {
        this(startDoubleQuote, content, endDoubleQuote, Collections.emptyList());
    }

    STStringLiteralNode(STNode startDoubleQuote, STNode content, STNode endDoubleQuote, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.STRING_LITERAL, diagnostics);
        this.startDoubleQuote = startDoubleQuote;
        this.content = content;
        this.endDoubleQuote = endDoubleQuote;
        this.addChildren(startDoubleQuote, content, endDoubleQuote);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STStringLiteralNode(this.startDoubleQuote, this.content, this.endDoubleQuote, diagnostics);
    }

    public STStringLiteralNode modify(STNode startDoubleQuote, STNode content, STNode endDoubleQuote) {
        if (this.checkForReferenceEquality(startDoubleQuote, content, endDoubleQuote)) {
            return this;
        }
        return new STStringLiteralNode(startDoubleQuote, content, endDoubleQuote, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new StringLiteralNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

