/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.internal.syntax;

import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.syntax.tree.SyntaxKind;

public class NodeListUtils {
    private NodeListUtils() {
    }

    public static boolean isSTNodeList(STNode node) {
        return node.kind == SyntaxKind.LIST;
    }

    public static void rangeCheck(int index, int size) {
        if (index >= size || index < 0) {
            throw new IndexOutOfBoundsException(NodeListUtils.getOutOfBoundsMessage(index, size));
        }
    }

    public static void rangeCheckForAdd(int index, int size) {
        if (index > size || index < 0) {
            throw new IndexOutOfBoundsException(NodeListUtils.getOutOfBoundsMessage(index, size));
        }
    }

    private static String getOutOfBoundsMessage(int index, int size) {
        return "Index: '" + index + "', Size: '" + size + "'";
    }
}

