/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.semantic.ast;

import io.ballerina.toml.semantic.TomlType;
import io.ballerina.toml.semantic.ast.TomlKeyNode;
import io.ballerina.toml.semantic.ast.TomlNodeVisitor;
import io.ballerina.toml.semantic.ast.TomlValueNode;
import io.ballerina.toml.semantic.ast.TopLevelNode;
import io.ballerina.toml.semantic.diagnostics.TomlNodeLocation;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.Set;

public class TomlKeyValueNode
extends TopLevelNode {
    private final TomlValueNode value;

    public TomlKeyValueNode(TomlKeyNode key, TomlValueNode value, TomlNodeLocation location) {
        super(key, TomlType.KEY_VALUE, location);
        this.value = value;
    }

    public TomlValueNode value() {
        return this.value;
    }

    @Override
    public Set<Diagnostic> diagnostics() {
        Set tomlDiagnostics = this.diagnostics;
        tomlDiagnostics.addAll(this.value.diagnostics());
        return tomlDiagnostics;
    }

    public String toString() {
        return "TomlKeyValue{key=" + this.key().name() + ", value=" + this.value + "}";
    }

    @Override
    public void accept(TomlNodeVisitor visitor) {
        visitor.visit(this);
    }
}

