/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.semantic.ast;

import io.ballerina.toml.internal.diagnostics.DiagnosticErrorCode;
import io.ballerina.toml.semantic.TomlType;
import io.ballerina.toml.semantic.ast.TomlArrayValueNode;
import io.ballerina.toml.semantic.ast.TomlBasicValueNode;
import io.ballerina.toml.semantic.ast.TomlBooleanValueNode;
import io.ballerina.toml.semantic.ast.TomlDoubleValueNodeNode;
import io.ballerina.toml.semantic.ast.TomlKeyEntryNode;
import io.ballerina.toml.semantic.ast.TomlKeyNode;
import io.ballerina.toml.semantic.ast.TomlKeyValueNode;
import io.ballerina.toml.semantic.ast.TomlLongValueNode;
import io.ballerina.toml.semantic.ast.TomlNode;
import io.ballerina.toml.semantic.ast.TomlStringValueNode;
import io.ballerina.toml.semantic.ast.TomlTableArrayNode;
import io.ballerina.toml.semantic.ast.TomlTableNode;
import io.ballerina.toml.semantic.ast.TomlUnquotedKeyNode;
import io.ballerina.toml.semantic.ast.TomlValueNode;
import io.ballerina.toml.semantic.ast.TopLevelNode;
import io.ballerina.toml.semantic.diagnostics.DiagnosticLog;
import io.ballerina.toml.semantic.diagnostics.TomlDiagnostic;
import io.ballerina.toml.semantic.diagnostics.TomlNodeLocation;
import io.ballerina.toml.syntax.tree.ArrayNode;
import io.ballerina.toml.syntax.tree.BoolLiteralNode;
import io.ballerina.toml.syntax.tree.DocumentMemberDeclarationNode;
import io.ballerina.toml.syntax.tree.DocumentNode;
import io.ballerina.toml.syntax.tree.IdentifierLiteralNode;
import io.ballerina.toml.syntax.tree.KeyValueNode;
import io.ballerina.toml.syntax.tree.Node;
import io.ballerina.toml.syntax.tree.NodeList;
import io.ballerina.toml.syntax.tree.NodeTransformer;
import io.ballerina.toml.syntax.tree.NumericLiteralNode;
import io.ballerina.toml.syntax.tree.SeparatedNodeList;
import io.ballerina.toml.syntax.tree.StringLiteralNode;
import io.ballerina.toml.syntax.tree.SyntaxKind;
import io.ballerina.toml.syntax.tree.TableArrayNode;
import io.ballerina.toml.syntax.tree.TableNode;
import io.ballerina.toml.syntax.tree.Token;
import io.ballerina.toml.syntax.tree.ValueNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.text.StringEscapeUtils;

public class TomlTransformer
extends NodeTransformer<TomlNode> {
    private DiagnosticLog dlog = DiagnosticLog.getInstance();

    @Override
    public TomlNode transform(DocumentNode modulePartNode) {
        TomlTableNode rootTable = this.createRootTable();
        NodeList<DocumentMemberDeclarationNode> members = modulePartNode.members();
        for (DocumentMemberDeclarationNode rootNode : members) {
            TomlNode transformedChild = rootNode.apply(this);
            this.addChildNodeToParent(rootTable, transformedChild);
        }
        return rootTable;
    }

    private TomlTableNode createRootTable() {
        TomlKeyNode tomlKeyNode = new TomlKeyNode(null);
        return new TomlTableNode(tomlKeyNode, null);
    }

    private void addChildNodeToParent(TomlTableNode rootTable, TomlNode transformedChild) {
        if (transformedChild.kind() == TomlType.TABLE) {
            TomlTableNode tableChild = (TomlTableNode)transformedChild;
            this.addChildTableToParent(rootTable, tableChild);
        } else if (transformedChild.kind() == TomlType.TABLE_ARRAY) {
            TomlTableArrayNode transformedArray = (TomlTableArrayNode)transformedChild;
            this.addChildParentArrayToParent(rootTable, transformedArray);
        } else if (transformedChild.kind() == TomlType.KEY_VALUE) {
            TomlKeyValueNode transformedKeyValuePair = (TomlKeyValueNode)transformedChild;
            this.addChildKeyValueToParent(rootTable, transformedKeyValuePair);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private void addChildKeyValueToParent(TomlTableNode rootTable, TomlKeyValueNode transformedKeyValuePair) {
        List<TomlKeyEntryNode> keys = transformedKeyValuePair.key().keys();
        ArrayList<String> parentTables = new ArrayList<String>();
        for (int i = 0; i < keys.size() - 1; ++i) {
            parentTables.add(keys.get(i).name().toString());
        }
        TomlTableNode parentTable = rootTable;
        for (int i = 0; i < parentTables.size(); ++i) {
            String newTable = (String)parentTables.get(i);
            TopLevelNode dottedParentNode = parentTable.entries().get(newTable);
            if (dottedParentNode != null) continue;
            TomlKeyEntryNode tomlKeyEntryNode = keys.get(i);
            parentTable = this.createDottedKeyParentTable(parentTable, tomlKeyEntryNode);
        }
        if (keys.size() > 1) {
            ArrayList<TomlKeyEntryNode> list = new ArrayList<TomlKeyEntryNode>();
            list.add(keys.get(keys.size() - 1));
            TomlKeyNode newKey = new TomlKeyNode(list);
            transformedKeyValuePair = new TomlKeyValueNode(newKey, transformedKeyValuePair.value(), transformedKeyValuePair.location());
        }
        parentTable.entries().put(transformedKeyValuePair.key().name(), transformedKeyValuePair);
    }

    private TomlTableNode createDottedKeyParentTable(TomlTableNode parentTable, TomlKeyEntryNode dottedKey) {
        ArrayList<TomlKeyEntryNode> list = new ArrayList<TomlKeyEntryNode>();
        list.add(dottedKey);
        TomlKeyNode newTableKey = new TomlKeyNode(list);
        TomlTableNode newTomlTableNode = new TomlTableNode(newTableKey, null);
        parentTable.entries().put(dottedKey.name().toString(), newTomlTableNode);
        return newTomlTableNode;
    }

    private void addChildParentArrayToParent(TomlTableNode rootTable, TomlTableArrayNode tableArrayChild) {
        TomlTableNode parentTable = this.getParentTable(rootTable, tableArrayChild);
        List<TomlKeyEntryNode> keys = tableArrayChild.key().keys();
        TomlKeyEntryNode tomlKeyEntryNode = keys.get(keys.size() - 1);
        ArrayList<TomlKeyEntryNode> list = new ArrayList<TomlKeyEntryNode>();
        list.add(tomlKeyEntryNode);
        TomlTableArrayNode newTomlTableArray = new TomlTableArrayNode(new TomlKeyNode(list), tableArrayChild.location(), tableArrayChild.children());
        TopLevelNode topLevelNode = parentTable.entries().get(newTomlTableArray.key().name());
        if (topLevelNode == null) {
            parentTable.entries().put(newTomlTableArray.key().name(), newTomlTableArray);
        } else if (topLevelNode instanceof TomlTableArrayNode) {
            ((TomlTableArrayNode)topLevelNode).addChild(newTomlTableArray.children().get(0));
        } else if (topLevelNode instanceof TomlKeyValueNode) {
            TomlDiagnostic nodeExists = this.dlog.error(newTomlTableArray.location(), DiagnosticErrorCode.ERROR_EXISTING_NODE);
            parentTable.addDiagnostic(nodeExists);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private TomlKeyEntryNode getLastKeyEntry(TopLevelNode childNode) {
        return childNode.key().keys().get(childNode.key().keys().size() - 1);
    }

    private TomlTableNode getParentTable(TomlTableNode rootTable, TopLevelNode childNode) {
        String tableLeadName = this.getLastKeyEntry(childNode).name().toString();
        ArrayList<String> parentTables = new ArrayList<String>();
        for (int i = 0; i < childNode.key().keys().size() - 1; ++i) {
            parentTables.add(childNode.key().keys().get(i).name().toString());
        }
        TomlTableNode parentTable = rootTable;
        for (int i = 0; i < parentTables.size(); ++i) {
            String parentString = (String)parentTables.get(i);
            TopLevelNode rootTableNode = parentTable.entries().get(parentString);
            if (rootTableNode != null) {
                parentTable = (TomlTableNode)rootTableNode;
                continue;
            }
            TomlKeyEntryNode tomlKeyEntryNode = childNode.key().keys().get(i);
            parentTable = childNode instanceof TomlTableArrayNode ? this.generateTable(parentTable.entries(), tomlKeyEntryNode, false) : this.generateTable(parentTable.entries(), tomlKeyEntryNode, true);
        }
        TopLevelNode lastNode = parentTable.entries().get(tableLeadName);
        if (lastNode instanceof TomlKeyValueNode) {
            TomlDiagnostic nodeExists = this.dlog.error(childNode.location(), DiagnosticErrorCode.ERROR_EXISTING_NODE);
            parentTable.addDiagnostic(nodeExists);
        }
        return parentTable;
    }

    private void addChildTableToParent(TomlTableNode rootTable, TomlTableNode tableChild) {
        TomlTableNode parentTable = this.getParentTable(rootTable, tableChild);
        TopLevelNode topLevelNode = parentTable.entries().get(tableChild.key().name());
        TomlKeyEntryNode lastKeyEntry = this.getLastKeyEntry(tableChild);
        ArrayList<TomlKeyEntryNode> entries = new ArrayList<TomlKeyEntryNode>();
        entries.add(lastKeyEntry);
        TomlTableNode newTableNode = new TomlTableNode(new TomlKeyNode(entries), tableChild.generated(), tableChild.location(), tableChild.entries());
        if (topLevelNode == null) {
            parentTable.entries().put(newTableNode.key().name(), newTableNode);
        } else if (topLevelNode instanceof TomlTableNode) {
            if (((TomlTableNode)topLevelNode).generated()) {
                parentTable.replaceGeneratedTable(newTableNode);
            } else {
                TomlDiagnostic nodeExist = this.dlog.error(newTableNode.location(), DiagnosticErrorCode.ERROR_EXISTING_NODE);
                parentTable.addDiagnostic(nodeExist);
            }
        } else if (topLevelNode instanceof TomlKeyValueNode) {
            TomlDiagnostic nodeExist = this.dlog.error(newTableNode.location(), DiagnosticErrorCode.ERROR_EXISTING_NODE);
            parentTable.addDiagnostic(nodeExist);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private TomlTableNode generateTable(Map<String, TopLevelNode> childs, TomlKeyEntryNode parentString, boolean isGenerated) {
        ArrayList<TomlKeyEntryNode> list = new ArrayList<TomlKeyEntryNode>();
        list.add(parentString);
        TomlKeyNode newTableKey = new TomlKeyNode(list);
        TomlTableNode newTomlTableNode = new TomlTableNode(newTableKey, isGenerated, null);
        childs.put(parentString.name().toString(), newTomlTableNode);
        return newTomlTableNode;
    }

    @Override
    public TomlNode transform(TableNode tableNode) {
        SeparatedNodeList<ValueNode> identifierList = tableNode.identifier();
        TomlKeyNode tomlKeyNode = this.getTomlKeyNode(identifierList);
        TomlTableNode tomlTableNode = new TomlTableNode(tomlKeyNode, this.getPosition(tableNode));
        this.addChildToTable(tableNode, tomlTableNode);
        return tomlTableNode;
    }

    private void addChildToTable(TableNode tableNode, TomlTableNode tomlTableNode) {
        NodeList<KeyValueNode> children = tableNode.fields();
        for (KeyValueNode child : children) {
            TomlNode transformedChild = child.apply(this);
            if (transformedChild instanceof TopLevelNode) {
                TopLevelNode topLevelChild = (TopLevelNode)transformedChild;
                this.checkExistingNodes(tomlTableNode, topLevelChild);
                tomlTableNode.entries().put(topLevelChild.key().name(), topLevelChild);
                continue;
            }
            throw new UnsupportedOperationException();
        }
    }

    private void checkExistingNodes(TomlTableNode tomlTableNode, TopLevelNode topLevelChild) {
        String childName;
        Map<String, TopLevelNode> childs = tomlTableNode.entries();
        if (childs.get(childName = topLevelChild.key().name()) != null) {
            TomlDiagnostic nodeExists = this.dlog.error(topLevelChild.location(), DiagnosticErrorCode.ERROR_EXISTING_NODE);
            tomlTableNode.addDiagnostic(nodeExists);
        }
    }

    @Override
    public TomlNode transform(TableArrayNode tableArrayNode) {
        SeparatedNodeList<ValueNode> identifierList = tableArrayNode.identifier();
        TomlKeyNode tomlKeyNode = this.getTomlKeyNode(identifierList);
        TomlTableArrayNode tomlTableArrayNode = new TomlTableArrayNode(tomlKeyNode, this.getPosition(tableArrayNode));
        TomlTableNode anonTable = this.addChildsToTableArray(tableArrayNode);
        tomlTableArrayNode.addChild(anonTable);
        return tomlTableArrayNode;
    }

    private TomlTableNode addChildsToTableArray(TableArrayNode tableArrayNode) {
        NodeList<KeyValueNode> children = tableArrayNode.fields();
        TomlNodeLocation position = this.getPosition(tableArrayNode);
        TomlKeyNode anonKey = new TomlKeyNode(null);
        TomlTableNode anonTable = new TomlTableNode(anonKey, position);
        for (KeyValueNode child : children) {
            TomlNode transformedChild = child.apply(this);
            if (transformedChild instanceof TopLevelNode) {
                TopLevelNode topLevelChild = (TopLevelNode)transformedChild;
                anonTable.entries().put(topLevelChild.key().name(), topLevelChild);
                continue;
            }
            throw new UnsupportedOperationException();
        }
        return anonTable;
    }

    @Override
    public TomlNode transform(KeyValueNode keyValue) {
        SeparatedNodeList<ValueNode> identifierList = keyValue.identifier();
        TomlKeyNode tomlKeyNode = this.getTomlKeyNode(identifierList);
        ValueNode value = keyValue.value();
        TomlValueNode tomlValue = this.transformValue(value);
        return new TomlKeyValueNode(tomlKeyNode, tomlValue, this.getPosition(keyValue));
    }

    private TomlKeyNode getTomlKeyNode(SeparatedNodeList<ValueNode> identifierList) {
        ArrayList<TomlKeyEntryNode> nodeList = new ArrayList<TomlKeyEntryNode>();
        for (Node node : identifierList) {
            TomlBasicValueNode transformedNode = (TomlBasicValueNode)node.apply(this);
            nodeList.add(new TomlKeyEntryNode(transformedNode));
        }
        return new TomlKeyNode(nodeList);
    }

    private TomlValueNode transformValue(ValueNode valueToken) {
        return (TomlValueNode)valueToken.apply(this);
    }

    @Override
    public TomlNode transform(ArrayNode array) {
        SeparatedNodeList<ValueNode> values = array.values();
        ArrayList<TomlValueNode> elements = new ArrayList<TomlValueNode>();
        for (ValueNode value : values) {
            TomlValueNode transformedValue = (TomlValueNode)value.apply(this);
            elements.add(transformedValue);
        }
        return new TomlArrayValueNode(elements, this.getPosition(array));
    }

    @Override
    protected TomlNode transformSyntaxNode(Node node) {
        return null;
    }

    private TomlNodeLocation getPosition(Node node) {
        return new TomlNodeLocation(node.lineRange(), node.textRange());
    }

    @Override
    public TomlNode transform(StringLiteralNode stringLiteralNode) {
        String valueString = stringLiteralNode.content().text();
        String unescapedJava = StringEscapeUtils.unescapeJava(valueString);
        TomlNodeLocation position = this.getPosition(stringLiteralNode);
        return new TomlStringValueNode(unescapedJava, position);
    }

    @Override
    public TomlNode transform(NumericLiteralNode numericLiteralNode) {
        String sign = "";
        if (numericLiteralNode.sign().isPresent()) {
            sign = numericLiteralNode.sign().get().text();
        }
        Token valueToken = numericLiteralNode.value();
        String value = sign + valueToken.text();
        if (numericLiteralNode.kind() == SyntaxKind.DEC_INT) {
            return new TomlLongValueNode(Long.parseLong(value), this.getPosition(numericLiteralNode));
        }
        return new TomlDoubleValueNodeNode(Double.parseDouble(value), this.getPosition(numericLiteralNode));
    }

    @Override
    public TomlNode transform(BoolLiteralNode boolLiteralNode) {
        if (boolLiteralNode.value().kind() == SyntaxKind.TRUE_KEYWORD) {
            return new TomlBooleanValueNode(true, this.getPosition(boolLiteralNode));
        }
        return new TomlBooleanValueNode(false, this.getPosition(boolLiteralNode));
    }

    @Override
    public TomlNode transform(IdentifierLiteralNode identifierLiteralNode) {
        return new TomlUnquotedKeyNode(identifierLiteralNode.value().text(), this.getPosition(identifierLiteralNode));
    }
}

