/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.syntax.tree;

import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.syntax.tree.NodeFactory;
import io.ballerina.toml.syntax.tree.NodeTransformer;
import io.ballerina.toml.syntax.tree.NodeVisitor;
import io.ballerina.toml.syntax.tree.NonTerminalNode;
import io.ballerina.toml.syntax.tree.SeparatedNodeList;
import io.ballerina.toml.syntax.tree.Token;
import io.ballerina.toml.syntax.tree.ValueNode;
import java.util.Objects;

public class ArrayNode
extends ValueNode {
    public ArrayNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token openBracket() {
        return (Token)this.childInBucket(0);
    }

    public SeparatedNodeList<ValueNode> values() {
        return new SeparatedNodeList<ValueNode>((NonTerminalNode)this.childInBucket(1));
    }

    public Token closeBracket() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"openBracket", "values", "closeBracket"};
    }

    public ArrayNode modify(Token openBracket, SeparatedNodeList<ValueNode> values, Token closeBracket) {
        if (this.checkForReferenceEquality(openBracket, values.underlyingListNode(), closeBracket)) {
            return this;
        }
        return NodeFactory.createArrayNode(openBracket, values, closeBracket);
    }

    public ArrayNodeModifier modify() {
        return new ArrayNodeModifier(this);
    }

    public static class ArrayNodeModifier {
        private final ArrayNode oldNode;
        private Token openBracket;
        private SeparatedNodeList<ValueNode> values;
        private Token closeBracket;

        public ArrayNodeModifier(ArrayNode oldNode) {
            this.oldNode = oldNode;
            this.openBracket = oldNode.openBracket();
            this.values = oldNode.values();
            this.closeBracket = oldNode.closeBracket();
        }

        public ArrayNodeModifier withOpenBracket(Token openBracket) {
            Objects.requireNonNull(openBracket, "openBracket must not be null");
            this.openBracket = openBracket;
            return this;
        }

        public ArrayNodeModifier withValues(SeparatedNodeList<ValueNode> values) {
            Objects.requireNonNull(values, "values must not be null");
            this.values = values;
            return this;
        }

        public ArrayNodeModifier withCloseBracket(Token closeBracket) {
            Objects.requireNonNull(closeBracket, "closeBracket must not be null");
            this.closeBracket = closeBracket;
            return this;
        }

        public ArrayNode apply() {
            return this.oldNode.modify(this.openBracket, this.values, this.closeBracket);
        }
    }
}

