/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.syntax.tree;

import io.ballerina.toml.internal.parser.tree.STMinutiae;
import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.syntax.tree.SyntaxKind;
import io.ballerina.toml.syntax.tree.SyntaxTree;
import io.ballerina.toml.syntax.tree.Token;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextRange;

public final class Minutiae {
    private final STMinutiae internalMinutiae;
    private final Token token;
    private final int position;
    private TextRange textRange;
    private LineRange lineRange;

    Minutiae(STMinutiae internalMinutiae, Token token, int position) {
        this.internalMinutiae = internalMinutiae;
        this.token = token;
        this.position = position;
    }

    static Minutiae createUnlinked(STMinutiae internalMinutiae) {
        return new Minutiae(internalMinutiae, null, -1);
    }

    public String text() {
        return this.internalMinutiae.text();
    }

    public SyntaxKind kind() {
        return this.internalMinutiae.kind;
    }

    public TextRange textRange() {
        if (this.textRange != null) {
            return this.textRange;
        }
        this.textRange = TextRange.from(this.position, this.internalMinutiae.width());
        return this.textRange;
    }

    public LineRange lineRange() {
        if (this.lineRange != null) {
            return this.lineRange;
        }
        SyntaxTree syntaxTree = this.token.syntaxTree();
        TextDocument textDocument = syntaxTree.textDocument();
        this.lineRange = LineRange.from(syntaxTree.filePath(), textDocument.linePositionFrom(this.textRange().startOffset()), textDocument.linePositionFrom(this.textRange().endOffset()));
        return this.lineRange;
    }

    STNode internalNode() {
        return this.internalMinutiae;
    }
}

