/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.syntax.tree;

import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.syntax.tree.NodeFactory;
import io.ballerina.toml.syntax.tree.NodeTransformer;
import io.ballerina.toml.syntax.tree.NodeVisitor;
import io.ballerina.toml.syntax.tree.NonTerminalNode;
import io.ballerina.toml.syntax.tree.Token;
import io.ballerina.toml.syntax.tree.ValueNode;
import java.util.Objects;

public class StringLiteralNode
extends ValueNode {
    public StringLiteralNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token startDoubleQuote() {
        return (Token)this.childInBucket(0);
    }

    public Token content() {
        return (Token)this.childInBucket(1);
    }

    public Token endDoubleQuote() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"startDoubleQuote", "content", "endDoubleQuote"};
    }

    public StringLiteralNode modify(Token startDoubleQuote, Token content, Token endDoubleQuote) {
        if (this.checkForReferenceEquality(startDoubleQuote, content, endDoubleQuote)) {
            return this;
        }
        return NodeFactory.createStringLiteralNode(startDoubleQuote, content, endDoubleQuote);
    }

    public StringLiteralNodeModifier modify() {
        return new StringLiteralNodeModifier(this);
    }

    public static class StringLiteralNodeModifier {
        private final StringLiteralNode oldNode;
        private Token startDoubleQuote;
        private Token content;
        private Token endDoubleQuote;

        public StringLiteralNodeModifier(StringLiteralNode oldNode) {
            this.oldNode = oldNode;
            this.startDoubleQuote = oldNode.startDoubleQuote();
            this.content = oldNode.content();
            this.endDoubleQuote = oldNode.endDoubleQuote();
        }

        public StringLiteralNodeModifier withStartDoubleQuote(Token startDoubleQuote) {
            Objects.requireNonNull(startDoubleQuote, "startDoubleQuote must not be null");
            this.startDoubleQuote = startDoubleQuote;
            return this;
        }

        public StringLiteralNodeModifier withContent(Token content) {
            Objects.requireNonNull(content, "content must not be null");
            this.content = content;
            return this;
        }

        public StringLiteralNodeModifier withEndDoubleQuote(Token endDoubleQuote) {
            Objects.requireNonNull(endDoubleQuote, "endDoubleQuote must not be null");
            this.endDoubleQuote = endDoubleQuote;
            return this;
        }

        public StringLiteralNode apply() {
            return this.oldNode.modify(this.startDoubleQuote, this.content, this.endDoubleQuote);
        }
    }
}

