/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.syntax.tree;

public enum SyntaxKind {
    NEWLINE(100, "\n"),
    HASH_TOKEN(101, "#"),
    TRUE_KEYWORD(200, "true"),
    FALSE_KEYWORD(201, "false"),
    STRING_LITERAL_TOKEN(203),
    DECIMAL_INT_TOKEN(204),
    DECIMAL_FLOAT_TOKEN(205),
    OPEN_BRACKET_TOKEN(500, "["),
    CLOSE_BRACKET_TOKEN(501, "]"),
    DOUBLE_QUOTE_TOKEN(502, "\""),
    SINGLE_QUOTE_TOKEN(503, "'"),
    TRIPLE_DOUBLE_QUOTE_TOKEN(504, "\"\"\""),
    TRIPLE_SINGLE_QUOTE_TOKEN(505, "'''"),
    DOT_TOKEN(520, "."),
    COMMA_TOKEN(521, ","),
    EQUAL_TOKEN(522, "="),
    PLUS_TOKEN(523, "+"),
    MINUS_TOKEN(524, "-"),
    IDENTIFIER_LITERAL(1000),
    STRING_LITERAL(1001),
    WHITESPACE_MINUTIAE(1500),
    END_OF_LINE_MINUTIAE(1501),
    COMMENT_MINUTIAE(1502),
    INVALID_NODE_MINUTIAE(1503),
    INVALID_TOKEN(1600),
    MISSING_VALUE(1601),
    MARKDOWN_DOCUMENTATION_LINE(1504),
    KEY(2000),
    KEY_VALUE(2001),
    TABLE(2002),
    TABLE_ARRAY(2003),
    DEC_INT(2010),
    FLOAT(2020),
    INF_TOKEN(2021, "inf"),
    NAN_TOKEN(2022, "nan"),
    ML_STRING_LITERAL(2030),
    BOOLEAN(2040),
    OFFSET_DATE_TIME(2050),
    LOCAL_DATE_TIME(2051),
    LOCAL_DATE(2052),
    LOCAL_TIME(2053),
    ARRAY(2060),
    INVALID(4),
    MODULE_PART(3),
    EOF_TOKEN(2),
    LIST(1),
    NONE(0);

    final int tag;
    final String strValue;

    private SyntaxKind(int tag, String strValue) {
        this.tag = tag;
        this.strValue = strValue;
    }

    private SyntaxKind(int tag) {
        this.tag = tag;
        this.strValue = "";
    }

    public String stringValue() {
        return this.strValue;
    }
}

