/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.syntax.tree;

import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.syntax.tree.DocumentMemberDeclarationNode;
import io.ballerina.toml.syntax.tree.KeyValueNode;
import io.ballerina.toml.syntax.tree.NodeFactory;
import io.ballerina.toml.syntax.tree.NodeList;
import io.ballerina.toml.syntax.tree.NodeTransformer;
import io.ballerina.toml.syntax.tree.NodeVisitor;
import io.ballerina.toml.syntax.tree.NonTerminalNode;
import io.ballerina.toml.syntax.tree.SeparatedNodeList;
import io.ballerina.toml.syntax.tree.Token;
import io.ballerina.toml.syntax.tree.ValueNode;
import java.util.Objects;

public class TableNode
extends DocumentMemberDeclarationNode {
    public TableNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token openBracket() {
        return (Token)this.childInBucket(0);
    }

    public SeparatedNodeList<ValueNode> identifier() {
        return new SeparatedNodeList<ValueNode>((NonTerminalNode)this.childInBucket(1));
    }

    public Token closeBracket() {
        return (Token)this.childInBucket(2);
    }

    public NodeList<KeyValueNode> fields() {
        return new NodeList<KeyValueNode>((NonTerminalNode)this.childInBucket(3));
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"openBracket", "identifier", "closeBracket", "fields"};
    }

    public TableNode modify(Token openBracket, SeparatedNodeList<ValueNode> identifier, Token closeBracket, NodeList<KeyValueNode> fields) {
        if (this.checkForReferenceEquality(openBracket, identifier.underlyingListNode(), closeBracket, fields.underlyingListNode())) {
            return this;
        }
        return NodeFactory.createTableNode(openBracket, identifier, closeBracket, fields);
    }

    public TableNodeModifier modify() {
        return new TableNodeModifier(this);
    }

    public static class TableNodeModifier {
        private final TableNode oldNode;
        private Token openBracket;
        private SeparatedNodeList<ValueNode> identifier;
        private Token closeBracket;
        private NodeList<KeyValueNode> fields;

        public TableNodeModifier(TableNode oldNode) {
            this.oldNode = oldNode;
            this.openBracket = oldNode.openBracket();
            this.identifier = oldNode.identifier();
            this.closeBracket = oldNode.closeBracket();
            this.fields = oldNode.fields();
        }

        public TableNodeModifier withOpenBracket(Token openBracket) {
            Objects.requireNonNull(openBracket, "openBracket must not be null");
            this.openBracket = openBracket;
            return this;
        }

        public TableNodeModifier withIdentifier(SeparatedNodeList<ValueNode> identifier) {
            Objects.requireNonNull(identifier, "identifier must not be null");
            this.identifier = identifier;
            return this;
        }

        public TableNodeModifier withCloseBracket(Token closeBracket) {
            Objects.requireNonNull(closeBracket, "closeBracket must not be null");
            this.closeBracket = closeBracket;
            return this;
        }

        public TableNodeModifier withFields(NodeList<KeyValueNode> fields) {
            Objects.requireNonNull(fields, "fields must not be null");
            this.fields = fields;
            return this;
        }

        public TableNode apply() {
            return this.oldNode.modify(this.openBracket, this.identifier, this.closeBracket, this.fields);
        }
    }
}

