/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.validator.schema;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import io.ballerina.toml.validator.schema.AbstractSchema;
import io.ballerina.toml.validator.schema.ObjectSchema;
import io.ballerina.toml.validator.schema.SchemaDeserializer;
import io.ballerina.toml.validator.schema.Type;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;

public class Schema
extends ObjectSchema {
    @SerializedName(value="$schema")
    private String schema;
    private String title;

    public Schema(String description, boolean additionalProperties, Map<String, AbstractSchema> properties, String schema, String title) {
        super(Type.OBJECT, description, additionalProperties, properties);
        this.schema = schema;
        this.title = title;
    }

    public static Schema from(Path jsonPath) throws IOException {
        Gson gson = new GsonBuilder().registerTypeAdapter((java.lang.reflect.Type)((Object)AbstractSchema.class), new SchemaDeserializer()).create();
        BufferedReader reader = Files.newBufferedReader(jsonPath);
        Schema rootSchema = gson.fromJson((Reader)reader, Schema.class);
        rootSchema.setType(Type.OBJECT);
        return rootSchema;
    }

    public static Schema from(String jsonContent) {
        Gson gson = new Gson();
        Schema rootSchema = gson.fromJson(jsonContent, Schema.class);
        rootSchema.setType(Type.OBJECT);
        return rootSchema;
    }
}

