/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.attachments.lifecycle.impl;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import org.apache.axiom.attachments.lifecycle.LifecycleManager;
import org.apache.axiom.attachments.lifecycle.impl.FileAccessor;
import org.apache.axiom.attachments.lifecycle.impl.VMShutdownHook;
import org.apache.axiom.util.UIDGenerator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LifecycleManagerImpl
implements LifecycleManager {
    private static final Log log = LogFactory.getLog(LifecycleManagerImpl.class);
    private static Hashtable table = new Hashtable();
    private VMShutdownHook hook = null;

    public FileAccessor create(String attachmentDir) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Start Create()");
        }
        File file = null;
        File dir2 = null;
        if (attachmentDir != null && !(dir2 = new File(attachmentDir)).exists()) {
            dir2.mkdirs();
        }
        if (!dir2.isDirectory()) {
            throw new IllegalArgumentException("Given Attachment File Cache Location " + dir2 + " should be a directory.");
        }
        String id = UIDGenerator.generateUID();
        String fileString = "axiom" + id + ".att";
        file = new File(dir2, fileString);
        FileAccessor fa = new FileAccessor(this, file);
        table.put(fileString, fa);
        this.deleteOnExit(file);
        if (log.isDebugEnabled()) {
            log.debug("End Create()");
        }
        return fa;
    }

    public void delete(File file) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Start delete()");
        }
        if (file != null && file.exists()) {
            table.remove(file.getName());
            if (log.isDebugEnabled()) {
                log.debug("invoking file.delete()");
            }
            if (file.delete()) {
                VMShutdownHook hook;
                if (log.isDebugEnabled()) {
                    log.debug("delete() successful");
                }
                if ((hook = VMShutdownHook.hook()).isRegistered()) {
                    hook.remove(file);
                }
                if (log.isDebugEnabled()) {
                    log.debug("File Purged and removed from Shutdown Hook Collection");
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Cannot delete file, set to delete on VM shutdown");
                }
                this.deleteOnExit(file);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("End delete()");
        }
    }

    public void deleteOnExit(File file) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Start deleteOnExit()");
        }
        if (this.hook == null) {
            this.hook = this.RegisterVMShutdownHook();
        }
        if (file != null) {
            if (log.isDebugEnabled()) {
                log.debug("Invoking deleteOnExit() for file = " + file.getAbsolutePath());
            }
            this.hook.add(file);
            table.remove(file.getName());
        }
        if (log.isDebugEnabled()) {
            log.debug("End deleteOnExit()");
        }
    }

    public void deleteOnTimeInterval(int interval, File file) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Start deleteOnTimeInterval()");
        }
        Thread t = new Thread(new FileDeletor(interval, file));
        t.setDaemon(true);
        t.start();
        if (log.isDebugEnabled()) {
            log.debug("End deleteOnTimeInterval()");
        }
    }

    private VMShutdownHook RegisterVMShutdownHook() throws RuntimeException {
        if (log.isDebugEnabled()) {
            log.debug("Start RegisterVMShutdownHook()");
        }
        try {
            this.hook = (VMShutdownHook)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws SecurityException, IllegalStateException, IllegalArgumentException {
                    VMShutdownHook hook = VMShutdownHook.hook();
                    if (!hook.isRegistered()) {
                        Runtime.getRuntime().addShutdownHook(hook);
                        hook.setRegistered(true);
                    }
                    return hook;
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (log.isDebugEnabled()) {
                log.debug("Exception thrown from AccessController: " + e);
                log.debug("VM Shutdown Hook not registered.");
            }
            throw new RuntimeException(e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit RegisterVMShutdownHook()");
        }
        return this.hook;
    }

    public FileAccessor getFileAccessor(String fileName) throws IOException {
        return (FileAccessor)table.get(fileName);
    }

    public class FileDeletor
    implements Runnable {
        int interval;
        File _file;

        public FileDeletor(int interval, File file) {
            this.interval = interval;
            this._file = file;
        }

        public void run() {
            block3: {
                try {
                    Thread.sleep(this.interval * 1000);
                    if (this._file.exists()) {
                        table.remove(this._file.getName());
                        this._file.delete();
                    }
                }
                catch (InterruptedException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.warn("InterruptedException occured " + e.getMessage());
                }
            }
        }
    }
}

