/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.mime;

import java.text.ParseException;
import org.apache.axiom.mime.ContentTypeTokenizer;

public final class MediaType {
    public static final MediaType TEXT_XML = new MediaType("text", "xml");
    public static final MediaType APPLICATION_XML = new MediaType("application", "xml");
    public static final MediaType APPLICATION_SOAP_XML = new MediaType("application", "soap+xml");
    public static final MediaType APPLICATION_XOP_XML = new MediaType("application", "xop+xml");
    public static final MediaType MULTIPART_RELATED = new MediaType("multipart", "related");
    private final String primaryType;
    private final String subType;

    public MediaType(String primaryType, String subType) {
        this.primaryType = primaryType;
        this.subType = subType;
    }

    public MediaType(String type) throws ParseException {
        ContentTypeTokenizer tokenizer = new ContentTypeTokenizer(type);
        this.primaryType = tokenizer.requireToken();
        tokenizer.require('/');
        this.subType = tokenizer.requireToken();
        tokenizer.requireEndOfString();
    }

    public String getPrimaryType() {
        return this.primaryType;
    }

    public String getSubType() {
        return this.subType;
    }

    public int hashCode() {
        int i;
        int hash = 0;
        int l = this.primaryType.length();
        for (i = 0; i < l; ++i) {
            hash = 31 * hash + Character.toLowerCase(this.primaryType.charAt(i));
        }
        hash *= 31;
        l = this.subType.length();
        for (i = 0; i < l; ++i) {
            hash = 31 * hash + Character.toLowerCase(this.subType.charAt(i));
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MediaType) {
            MediaType other = (MediaType)obj;
            return this.primaryType.equalsIgnoreCase(other.primaryType) && this.subType.equalsIgnoreCase(other.subType);
        }
        return false;
    }

    public String toString() {
        return this.primaryType + "/" + this.subType;
    }
}

