/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.central.client;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import me.tongfei.progressbar.ProgressBar;
import me.tongfei.progressbar.ProgressBarStyle;
import org.ballerinalang.central.client.LogFormatter;
import org.ballerinalang.central.client.exceptions.CentralClientException;
import org.ballerinalang.central.client.exceptions.ConnectionErrorException;
import org.ballerinalang.central.client.exceptions.PackageAlreadyExistsException;

public class Utils {
    private static TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }};

    private Utils() {
    }

    public static void createBaloInHomeRepo(HttpURLConnection conn, Path pkgPathInBaloCache, String pkgNameWithOrg, boolean isNightlyBuild, String newUrl, String contentDisposition, PrintStream outStream, LogFormatter logFormatter) throws CentralClientException {
        long responseContentLength = conn.getContentLengthLong();
        if (responseContentLength <= 0L) {
            throw new CentralClientException(logFormatter.formatLog("invalid response from the server, please try again"));
        }
        String resolvedURI = conn.getHeaderField("RESOLVED_REQUESTED_URI");
        if (resolvedURI == null || resolvedURI.equals("")) {
            resolvedURI = newUrl;
        }
        String[] uriParts = resolvedURI.split("/");
        String pkgVersion = uriParts[uriParts.length - 2];
        Utils.validatePackageVersion(pkgVersion, logFormatter);
        String baloFile = Utils.getBaloFileName(contentDisposition, uriParts[uriParts.length - 1]);
        Path baloCacheWithPkgPath = pkgPathInBaloCache.resolve(pkgVersion);
        Path baloPath = Paths.get(baloCacheWithPkgPath.toString(), baloFile);
        if (baloPath.toFile().exists()) {
            throw new PackageAlreadyExistsException(logFormatter.formatLog("package already exists in the home repository: " + baloPath.toString()));
        }
        Utils.createBaloFileDirectory(baloCacheWithPkgPath, logFormatter);
        Utils.writeBaloFile(conn, baloPath, pkgNameWithOrg + ":" + pkgVersion, responseContentLength, outStream, logFormatter);
        Utils.handleNightlyBuild(isNightlyBuild, baloCacheWithPkgPath, logFormatter);
    }

    static void validatePackageVersion(String pkgVersion, LogFormatter logFormatter) throws CentralClientException {
        if (!pkgVersion.matches("(\\d+\\.)(\\d+\\.)(\\d+)")) {
            throw new CentralClientException(logFormatter.formatLog("package version could not be detected"));
        }
    }

    private static String getBaloFileName(String contentDisposition, String baloFile) {
        if (contentDisposition != null && !contentDisposition.equals("")) {
            return contentDisposition.substring("attachment; filename=".length());
        }
        return baloFile;
    }

    private static void createBaloFileDirectory(Path fullPathToStoreBalo, LogFormatter logFormatter) throws CentralClientException {
        try {
            Files.createDirectories(fullPathToStoreBalo, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new CentralClientException(logFormatter.formatLog("error creating directory for balo file"));
        }
    }

    static void writeBaloFile(HttpURLConnection conn, Path baloPath, String fullPkgName, long resContentLength, PrintStream outStream, LogFormatter logFormatter) throws CentralClientException {
        try (InputStream inputStream = conn.getInputStream();
             FileOutputStream outputStream = new FileOutputStream(baloPath.toString());){
            Utils.writeAndHandleProgress(inputStream, outputStream, resContentLength / 1024L, fullPkgName, outStream, logFormatter);
        }
        catch (IOException e) {
            throw new CentralClientException(logFormatter.formatLog("error occurred copying the balo file: " + e.getMessage()));
        }
    }

    private static void handleNightlyBuild(boolean isNightlyBuild, Path baloCacheWithPkgPath, LogFormatter logFormatter) throws CentralClientException {
        Path nightlyBuildMetaFile;
        if (isNightlyBuild && !(nightlyBuildMetaFile = Paths.get(baloCacheWithPkgPath.toString(), "nightly.build")).toFile().exists()) {
            Utils.createNightlyBuildMetaFile(nightlyBuildMetaFile, logFormatter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeAndHandleProgress(InputStream inputStream, FileOutputStream outputStream, long totalSizeInKB, String fullPkgName, PrintStream outStream, LogFormatter logFormatter) {
        byte[] buffer = new byte[1024];
        try (ProgressBar progressBar = new ProgressBar(fullPkgName + " [central.ballerina.io -> home repo] ", totalSizeInKB, 1000, outStream, ProgressBarStyle.ASCII, " KB", 1L);){
            int count;
            while ((count = inputStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, count);
                progressBar.step();
            }
        }
        catch (IOException e) {
            outStream.println(logFormatter.formatLog(fullPkgName + "pulling the package from central failed"));
        }
        finally {
            outStream.println(logFormatter.formatLog(fullPkgName + " pulled from central successfully"));
        }
    }

    private static void createNightlyBuildMetaFile(Path nightlyBuildMetaFilePath, LogFormatter logFormatter) throws CentralClientException {
        try {
            Files.createFile(nightlyBuildMetaFilePath, new FileAttribute[0]);
        }
        catch (Exception e) {
            throw new CentralClientException(logFormatter.formatLog("error occurred while creating nightly.build file."));
        }
    }

    static URL convertToUrl(String url) throws ConnectionErrorException {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new ConnectionErrorException("malformed url:" + url, e);
        }
    }

    static void initializeSsl() throws CentralClientException {
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new CentralClientException("initializing SSL failed: " + e.getMessage());
        }
    }

    static void setRequestMethod(HttpURLConnection conn, RequestMethod method) throws CentralClientException {
        try {
            conn.setRequestMethod(method.name());
        }
        catch (ProtocolException e) {
            throw new CentralClientException(e.getMessage());
        }
    }

    static int getStatusCode(HttpURLConnection conn) throws ConnectionErrorException {
        try {
            return conn.getResponseCode();
        }
        catch (IOException e) {
            throw new ConnectionErrorException("connection to the remote repository host failed: " + e.getMessage());
        }
    }

    static long getTotalFileSizeInKB(Path filePath) throws CentralClientException {
        try {
            byte[] baloContent = Files.readAllBytes(filePath);
            return baloContent.length / 1024;
        }
        catch (IOException e) {
            throw new CentralClientException("cannot read the balo content");
        }
    }

    static List<String> getAsList(String arrayString) {
        return (List)new Gson().fromJson(arrayString, new TypeToken<List<String>>(){}.getType());
    }

    public static enum RequestMethod {
        GET,
        POST;

    }
}

