/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.cli.module;

import io.ballerina.runtime.api.utils.JsonUtils;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BMap;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import me.tongfei.progressbar.ProgressBar;
import me.tongfei.progressbar.ProgressBarStyle;
import org.ballerinalang.cli.module.BuildLogFormatter;
import org.ballerinalang.cli.module.DefaultLogFormatter;
import org.ballerinalang.cli.module.util.ErrorUtil;
import org.ballerinalang.cli.module.util.Utils;

public class Pull {
    private static final String VERSION_REGEX = "(\\d+\\.)(\\d+\\.)(\\d+)";
    private static PrintStream outStream = System.out;
    private static DefaultLogFormatter logFormatter = new DefaultLogFormatter();

    private Pull() {
    }

    public static void execute(String url, String modulePathInBaloCache, String moduleNameWithOrg, String proxyHost, int proxyPort, String proxyUsername, String proxyPassword, String supportedVersionRange, boolean isBuild, boolean isNightlyBuild, String langSpecVersion, String platform, String clientId) {
        if (isBuild) {
            logFormatter = new BuildLogFormatter();
        }
        HttpURLConnection conn = null;
        try {
            Utils.initializeSsl();
            conn = Utils.createHttpUrlConnection(Utils.convertToUrl(url + supportedVersionRange), proxyHost, proxyPort, proxyUsername, proxyPassword);
            conn.setInstanceFollowRedirects(false);
            Utils.setRequestMethod(conn, Utils.RequestMethod.GET);
            conn.setRequestProperty("Ballerina-Platform", platform);
            conn.setRequestProperty("Ballerina-Language-Specification-Version", langSpecVersion);
            conn.setRequestProperty("Accept-Encoding", "identity");
            conn.setRequestProperty("User-Agent", clientId);
            boolean redirect = false;
            if (Utils.getStatusCode(conn) == 302) {
                redirect = true;
            } else {
                Pull.handleErrorResponse(conn, url, moduleNameWithOrg);
            }
            if (redirect) {
                String newUrl = conn.getHeaderField("Location");
                String contentDisposition = conn.getHeaderField("Content-Disposition");
                conn = Utils.createHttpUrlConnection(Utils.convertToUrl(newUrl), proxyHost, proxyPort, proxyUsername, proxyPassword);
                conn.setRequestProperty("Content-Disposition", contentDisposition);
                Pull.createBaloInHomeRepo(conn, modulePathInBaloCache, moduleNameWithOrg, isNightlyBuild, newUrl, contentDisposition);
            }
        }
        catch (Exception e) {
            throw ErrorUtil.createCommandException(e.getMessage());
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
            Authenticator.setDefault(null);
        }
    }

    private static void createBaloInHomeRepo(HttpURLConnection conn, String modulePathInBaloCache, String moduleNameWithOrg, boolean isNightlyBuild, String newUrl, String contentDisposition) {
        String resolvedURI;
        long responseContentLength = conn.getContentLengthLong();
        if (responseContentLength <= 0L) {
            Pull.createError("invalid response from the server, please try again");
        }
        if ((resolvedURI = conn.getHeaderField("RESOLVED_REQUESTED_URI")) == null || resolvedURI.equals("")) {
            resolvedURI = newUrl;
        }
        String[] uriParts = resolvedURI.split("/");
        String moduleVersion = uriParts[uriParts.length - 3];
        Pull.validateModuleVersion(moduleVersion);
        String baloFile = Pull.getBaloFileName(contentDisposition, uriParts[uriParts.length - 1]);
        Path baloCacheWithModulePath = Paths.get(modulePathInBaloCache, moduleVersion);
        Path baloPath = Paths.get(baloCacheWithModulePath.toString(), baloFile);
        if (baloPath.toFile().exists()) {
            Pull.createError("module already exists in the home repository: " + baloPath.toString());
        }
        Pull.createBaloFileDirectory(baloCacheWithModulePath);
        Pull.writeBaloFile(conn, baloPath, moduleNameWithOrg + ":" + moduleVersion, responseContentLength);
        Pull.handleNightlyBuild(isNightlyBuild, baloCacheWithModulePath);
    }

    private static void writeBaloFile(HttpURLConnection conn, Path baloPath, String fullModuleName, long resContentLength) {
        try (InputStream inputStream = conn.getInputStream();
             FileOutputStream outputStream = new FileOutputStream(baloPath.toString());){
            Pull.writeAndHandleProgress(inputStream, outputStream, resContentLength / 1024L, fullModuleName);
        }
        catch (IOException e) {
            Pull.createError("error occurred copying the balo file: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeAndHandleProgress(InputStream inputStream, FileOutputStream outputStream, long totalSizeInKB, String fullModuleName) {
        byte[] buffer = new byte[1024];
        try (ProgressBar progressBar = new ProgressBar(fullModuleName + " [central.ballerina.io -> home repo] ", totalSizeInKB, 1000, outStream, ProgressBarStyle.ASCII, " KB", 1L);){
            int count;
            while ((count = inputStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, count);
                progressBar.step();
            }
        }
        catch (IOException e) {
            outStream.println(logFormatter.formatLog(fullModuleName + "pulling the module from central failed"));
        }
        finally {
            outStream.println(logFormatter.formatLog(fullModuleName + " pulled from central successfully"));
        }
    }

    private static void handleNightlyBuild(boolean isNightlyBuild, Path baloCacheWithModulePath) {
        Path nightlyBuildMetaFile;
        if (isNightlyBuild && !(nightlyBuildMetaFile = Paths.get(baloCacheWithModulePath.toString(), "nightly.build")).toFile().exists()) {
            Pull.createNightlyBuildMetaFile(nightlyBuildMetaFile);
        }
    }

    private static void validateModuleVersion(String moduleVersion) {
        if (!moduleVersion.matches(VERSION_REGEX)) {
            Pull.createError("module version could not be detected");
        }
    }

    private static void createNightlyBuildMetaFile(Path nightlyBuildMetaFilePath) {
        try {
            Files.createFile(nightlyBuildMetaFilePath, new FileAttribute[0]);
        }
        catch (Exception e) {
            Pull.createError("error occurred while creating nightly.build file.");
        }
    }

    private static void createBaloFileDirectory(Path fullPathToStoreBalo) {
        try {
            Files.createDirectory(fullPathToStoreBalo, new FileAttribute[0]);
        }
        catch (IOException e) {
            Pull.createError("error creating directory for balo file");
        }
    }

    private static void handleErrorResponse(HttpURLConnection conn, String url, String moduleFullName) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getErrorStream(), Charset.defaultCharset()));){
            String line;
            StringBuilder result = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
            BMap payload = (BMap)JsonUtils.parse(result.toString());
            Pull.createError("error: " + payload.getStringValue(StringUtils.fromString("message")));
        }
        catch (IOException e) {
            Pull.createError("failed to pull the module '" + moduleFullName + "' from the remote repository '" + url + "'");
        }
    }

    private static void createError(String errMessage) {
        throw ErrorUtil.createCommandException(logFormatter.formatLog(errMessage));
    }

    private static String getBaloFileName(String contentDisposition, String baloFile) {
        if (contentDisposition != null && !contentDisposition.equals("")) {
            return contentDisposition.substring("attachment; filename=".length());
        }
        return baloFile;
    }
}

