/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.compiler;

public enum CompilerPhase {
    DEFINE("define"),
    TYPE_CHECK("typeCheck"),
    CODE_ANALYZE("codeAnalyze"),
    DATAFLOW_ANALYZE("dataflowAnalyze"),
    ISOLATION_ANALYZE("isolationAnalyze"),
    DOCUMENTATION_ANALYZE("documentationAnalyze"),
    TAINT_ANALYZE("taintAnalyze"),
    CONSTANT_PROPAGATION("constantPropagation"),
    COMPILER_PLUGIN("compilerPlugin"),
    DESUGAR("desugar"),
    BIR_GEN("birGen"),
    CODE_GEN("codeGen");

    private String value;

    private CompilerPhase(String value) {
        this.value = value;
    }

    public static CompilerPhase fromValue(String value) {
        switch (value) {
            case "define": {
                return DEFINE;
            }
            case "typeCheck": {
                return TYPE_CHECK;
            }
            case "codeAnalyze": {
                return CODE_ANALYZE;
            }
            case "documentationAnalyze": {
                return DOCUMENTATION_ANALYZE;
            }
            case "taintAnalyze": {
                return TAINT_ANALYZE;
            }
            case "constantPropagation": {
                return CONSTANT_PROPAGATION;
            }
            case "compilerPlugin": {
                return COMPILER_PLUGIN;
            }
            case "desugar": {
                return DESUGAR;
            }
            case "codeGen": {
                return CODE_GEN;
            }
            case "birGen": {
                return BIR_GEN;
            }
        }
        throw new IllegalArgumentException("invalid compiler phase: " + value);
    }

    public String toString() {
        return this.value;
    }
}

