/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.core.model.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.Map;
import org.ballerinalang.core.model.values.BBoolean;
import org.ballerinalang.core.model.values.BDecimal;
import org.ballerinalang.core.model.values.BFloat;
import org.ballerinalang.core.model.values.BInteger;
import org.ballerinalang.core.model.values.BMap;
import org.ballerinalang.core.model.values.BStreamingJSON;
import org.ballerinalang.core.model.values.BValue;
import org.ballerinalang.core.model.values.BValueArray;

public class JsonGenerator {
    private static final int DEFAULT_DEPTH = 10;
    private Writer writer;
    private boolean[] levelInit = new boolean[10];
    private int currentLevel;
    private boolean fieldActive;
    private static boolean[] escChars = new boolean[93];

    public JsonGenerator(OutputStream out) {
        this(out, Charset.defaultCharset());
    }

    public JsonGenerator(OutputStream out, Charset charset) {
        this(new BufferedWriter(new OutputStreamWriter(out, charset)));
    }

    public JsonGenerator(Writer writer) {
        this.writer = writer;
    }

    private void setLevelInit(int index, boolean init) {
        this.checkAndResizeLevels(index);
        this.levelInit[index] = init;
    }

    private boolean getLevelInit(int index) {
        this.checkAndResizeLevels(index);
        return this.levelInit[index];
    }

    private void checkAndResizeLevels(int index) {
        if (index >= this.levelInit.length) {
            boolean[] oldLI = this.levelInit;
            this.levelInit = new boolean[(int)Math.ceil((double)oldLI.length * 1.5)];
            System.arraycopy(oldLI, 0, this.levelInit, 0, oldLI.length);
        }
    }

    private void processStartLevel() throws IOException {
        if (!this.fieldActive) {
            if (this.getLevelInit(this.currentLevel)) {
                this.writer.write(", ");
            } else {
                this.setLevelInit(this.currentLevel, true);
            }
        } else {
            this.fieldActive = false;
        }
        ++this.currentLevel;
    }

    private void processEndLevel() {
        this.setLevelInit(this.currentLevel - 1, true);
        this.setLevelInit(this.currentLevel, false);
        --this.currentLevel;
    }

    private void processFieldInit() throws IOException {
        if (this.getLevelInit(this.currentLevel)) {
            this.writer.write(", ");
        } else {
            this.setLevelInit(this.currentLevel, true);
        }
        this.fieldActive = true;
    }

    private void processValueInit() throws IOException {
        if (this.fieldActive) {
            this.fieldActive = false;
            return;
        }
        if (this.getLevelInit(this.currentLevel)) {
            this.writer.write(", ");
        } else {
            this.setLevelInit(this.currentLevel, true);
        }
    }

    public void startObject() throws IOException {
        this.processStartLevel();
        this.writer.write(123);
    }

    public void endObject() throws IOException {
        this.writer.write(125);
        this.processEndLevel();
    }

    public void writeFieldName(String fieldName) throws IOException {
        this.processFieldInit();
        this.writeStringValue(fieldName);
        this.writer.write(":");
    }

    private void writeStringValue(String value) throws IOException {
        this.writer.write("\"");
        int count = value.length();
        boolean escaped = false;
        char[] chs = value.toCharArray();
        for (int i = 0; i < count; ++i) {
            char ch = chs[i];
            if (ch >= escChars.length || !escChars[ch]) continue;
            escaped = true;
            break;
        }
        if (escaped) {
            this.writeStringEsc(chs);
        } else {
            this.writer.write(chs);
        }
        this.writer.write("\"");
    }

    public void writeString(String value) throws IOException {
        this.processValueInit();
        this.writeStringValue(value);
    }

    public void writeStringEsc(char[] chs) throws IOException {
        int count = chs.length;
        int index = 0;
        block10: for (int i = 0; i < count; ++i) {
            char ch = chs[i];
            switch (ch) {
                case '\"': {
                    this.writer.write(chs, index, i - index);
                    this.writer.write("\\\"");
                    index = i + 1;
                    continue block10;
                }
                case '\\': {
                    this.writer.write(chs, index, i - index);
                    this.writer.write("\\\\");
                    index = i + 1;
                    continue block10;
                }
                case '/': {
                    this.writer.write(chs, index, i - index);
                    this.writer.write("\\/");
                    index = i + 1;
                    continue block10;
                }
                case '\b': {
                    this.writer.write(chs, index, i - index);
                    this.writer.write("\\b");
                    index = i + 1;
                    continue block10;
                }
                case '\n': {
                    this.writer.write(chs, index, i - index);
                    this.writer.write("\\n");
                    index = i + 1;
                    continue block10;
                }
                case '\r': {
                    this.writer.write(chs, index, i - index);
                    this.writer.write("\\r");
                    index = i + 1;
                    continue block10;
                }
                case '\f': {
                    this.writer.write(chs, index, i - index);
                    this.writer.write("\\f");
                    index = i + 1;
                    continue block10;
                }
                case '\t': {
                    this.writer.write(chs, index, i - index);
                    this.writer.write("\\t");
                    index = i + 1;
                    continue block10;
                }
            }
        }
        if (count - index > 0) {
            this.writer.write(chs, index, count - index);
        }
    }

    public void writeNumber(long value) throws IOException {
        this.processValueInit();
        this.writer.write(Long.toString(value));
    }

    public void writeNumber(double value) throws IOException {
        this.processValueInit();
        this.writer.write(Double.toString(value));
    }

    public void writeNumber(BigDecimal value) throws IOException {
        this.processValueInit();
        this.writer.write(value.toString());
    }

    public void writeBoolean(boolean value) throws IOException {
        this.processValueInit();
        this.writer.write(Boolean.toString(value));
    }

    public void writeNull() throws IOException {
        this.processValueInit();
        this.writer.write("null");
    }

    public void writeStartArray() throws IOException {
        this.processStartLevel();
        this.writer.write("[");
    }

    public void writeEndArray() throws IOException {
        this.writer.write("]");
        this.processEndLevel();
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void serialize(BValue json) throws IOException {
        if (json == null) {
            this.writeNull();
            return;
        }
        switch (json.getType().getTag()) {
            case 19: {
                if (json instanceof BStreamingJSON) {
                    ((BStreamingJSON)json).serialize(this);
                    break;
                }
                this.writeStartArray();
                BValueArray jsonArray = (BValueArray)json;
                int i = 0;
                while ((long)i < jsonArray.size()) {
                    this.serialize(jsonArray.getBValue(i));
                    ++i;
                }
                this.writeEndArray();
                break;
            }
            case 6: {
                this.writeBoolean(((BBoolean)json).booleanValue());
                break;
            }
            case 3: {
                this.writeNumber(((BFloat)json).floatValue());
                break;
            }
            case 4: {
                this.writeNumber(((BDecimal)json).decimalValue());
                break;
            }
            case 1: {
                this.writeNumber(((BInteger)json).intValue());
                break;
            }
            case 7: 
            case 15: {
                this.startObject();
                for (Map.Entry entry : ((BMap)json).getMap().entrySet()) {
                    this.writeFieldName(entry.getKey().toString());
                    this.serialize((BValue)entry.getValue());
                }
                this.endObject();
                break;
            }
            case 5: {
                this.writeString(json.stringValue());
                break;
            }
        }
    }

    static {
        JsonGenerator.escChars[34] = true;
        JsonGenerator.escChars[92] = true;
        JsonGenerator.escChars[8] = true;
        JsonGenerator.escChars[10] = true;
        JsonGenerator.escChars[13] = true;
        JsonGenerator.escChars[9] = true;
    }
}

