/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.core.model.util.serializer;

import org.ballerinalang.core.model.types.BArrayType;
import org.ballerinalang.core.model.types.BTypes;
import org.ballerinalang.core.model.util.serializer.BValueSerializer;
import org.ballerinalang.core.model.values.BRefType;
import org.ballerinalang.core.model.values.BValueArray;

class BValueArrays {
    private static final BArrayType B_INT_ARRAY_TYPE = new BArrayType(BTypes.typeInt);
    private static final BArrayType B_FLOAT_ARRAY_TYPE = new BArrayType(BTypes.typeFloat);
    private final BValueSerializer serializer;

    BValueArrays(BValueSerializer serializer) {
        this.serializer = serializer;
    }

    BValueArray from(int[] array) {
        BRefType[] backing = new BRefType[array.length];
        for (int i = 0; i < array.length; ++i) {
            backing[i] = (BRefType)this.serializer.toBValue(array[i], null);
        }
        return new BValueArray(backing, B_INT_ARRAY_TYPE);
    }

    BValueArray from(long[] array) {
        BRefType[] backing = new BRefType[array.length];
        for (int i = 0; i < array.length; ++i) {
            backing[i] = (BRefType)this.serializer.toBValue(array[i], null);
        }
        return new BValueArray(backing, B_INT_ARRAY_TYPE);
    }

    BValueArray from(double[] array) {
        BRefType[] backing = new BRefType[array.length];
        for (int i = 0; i < array.length; ++i) {
            backing[i] = (BRefType)this.serializer.toBValue(array[i], null);
        }
        return new BValueArray(backing, B_FLOAT_ARRAY_TYPE);
    }

    private <T> BRefType[] getBRefArray(T[] array) {
        BRefType[] backing = new BRefType[array.length];
        for (int i = 0; i < array.length; ++i) {
            backing[i] = (BRefType)this.serializer.toBValue(array[i], null);
        }
        return backing;
    }

    BValueArray from(Object[] array) {
        BRefType[] backing = this.getBRefArray(array);
        return new BValueArray(backing, new BArrayType(BTypes.typeAny));
    }

    public BRefType from(char[] array) {
        BRefType[] backing = new BRefType[array.length];
        for (int i = 0; i < array.length; ++i) {
            backing[i] = (BRefType)this.serializer.toBValue(Character.valueOf(array[i]), null);
        }
        return new BValueArray(backing, B_INT_ARRAY_TYPE);
    }

    public BRefType from(byte[] array) {
        BRefType[] backing = new BRefType[array.length];
        for (int i = 0; i < array.length; ++i) {
            backing[i] = (BRefType)this.serializer.toBValue(array[i], null);
        }
        return new BValueArray(backing, B_INT_ARRAY_TYPE);
    }

    public BRefType from(short[] array) {
        BRefType[] backing = new BRefType[array.length];
        for (int i = 0; i < array.length; ++i) {
            backing[i] = (BRefType)this.serializer.toBValue(array[i], null);
        }
        return new BValueArray(backing, B_INT_ARRAY_TYPE);
    }

    public BRefType from(float[] array) {
        BRefType[] backing = new BRefType[array.length];
        for (int i = 0; i < array.length; ++i) {
            backing[i] = (BRefType)this.serializer.toBValue(Float.valueOf(array[i]), null);
        }
        return new BValueArray(backing, B_FLOAT_ARRAY_TYPE);
    }
}

