/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.core.model.util.serializer;

import java.util.HashMap;
import org.ballerinalang.core.model.util.serializer.TypeInstanceProvider;
import org.ballerinalang.core.model.util.serializer.TypeInstanceProviderFactory;
import org.ballerinalang.core.util.exceptions.BallerinaException;

public class InstanceProviderRegistry {
    private static final InstanceProviderRegistry INSTANCE = new InstanceProviderRegistry();
    private final HashMap<String, TypeInstanceProvider> providerMap = new HashMap();

    private InstanceProviderRegistry() {
    }

    static InstanceProviderRegistry getInstance() {
        return INSTANCE;
    }

    TypeInstanceProvider findInstanceProvider(String type) {
        TypeInstanceProvider provider = this.providerMap.get(type);
        if (provider != null) {
            return provider;
        }
        TypeInstanceProvider instanceProvider = this.generateProvider(type);
        if (instanceProvider != null) {
            this.add(instanceProvider);
            return instanceProvider;
        }
        throw new BallerinaException(String.format("Can not find or create type instance provider for: %s", type));
    }

    private TypeInstanceProvider generateProvider(String type) {
        if (this.isClassLoadable(type)) {
            return new TypeInstanceProviderFactory().from(type);
        }
        return null;
    }

    private boolean isClassLoadable(String type) {
        try {
            Class<?> clazz = Class.forName(type, false, this.getClass().getClassLoader());
            return clazz != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void add(TypeInstanceProvider provider) {
        this.providerMap.put(provider.getTypeName(), provider);
    }
}

