/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.core.model.util.serializer;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import org.ballerinalang.core.model.util.JsonGenerator;
import org.ballerinalang.core.model.util.JsonParser;
import org.ballerinalang.core.model.util.serializer.BValueProvider;
import org.ballerinalang.core.model.util.serializer.BValueTree;
import org.ballerinalang.core.model.util.serializer.InstanceProviderRegistry;
import org.ballerinalang.core.model.util.serializer.JsonDeserializer;
import org.ballerinalang.core.model.util.serializer.ObjectToJsonSerializer;
import org.ballerinalang.core.model.util.serializer.providers.bvalue.ArrayListBValueProvider;
import org.ballerinalang.core.model.util.serializer.providers.bvalue.BBooleanBValueProvider;
import org.ballerinalang.core.model.util.serializer.providers.bvalue.BFloatBValueProvider;
import org.ballerinalang.core.model.util.serializer.providers.bvalue.BIntegerBValueProvider;
import org.ballerinalang.core.model.util.serializer.providers.bvalue.BMapBValueProvider;
import org.ballerinalang.core.model.util.serializer.providers.bvalue.BStringBValueProvider;
import org.ballerinalang.core.model.util.serializer.providers.bvalue.BTypeBValueProviders;
import org.ballerinalang.core.model.util.serializer.providers.bvalue.BValueArrayBValueProvider;
import org.ballerinalang.core.model.util.serializer.providers.bvalue.BXMLBValueProviders;
import org.ballerinalang.core.model.util.serializer.providers.bvalue.ClassBValueProvider;
import org.ballerinalang.core.model.util.serializer.providers.bvalue.ConcurrentHashMapBValueProvider;
import org.ballerinalang.core.model.util.serializer.providers.bvalue.DateTimeBValueProviders;
import org.ballerinalang.core.model.util.serializer.providers.bvalue.HashSetBValueProvider;
import org.ballerinalang.core.model.util.serializer.providers.bvalue.InetSocketAddressBValueProvider;
import org.ballerinalang.core.model.util.serializer.providers.bvalue.LinkedHashSetBValueProvider;
import org.ballerinalang.core.model.util.serializer.providers.bvalue.NumericBValueProviders;
import org.ballerinalang.core.model.values.BRefType;
import org.ballerinalang.core.util.exceptions.BallerinaException;

public class JsonSerializer
implements ObjectToJsonSerializer {
    private static final BValueProvider bValueProvider = BValueProvider.getInstance();

    public BValueProvider getBValueProviderRegistry() {
        return bValueProvider;
    }

    public InstanceProviderRegistry getInstanceProviderRegistry() {
        return InstanceProviderRegistry.getInstance();
    }

    @Override
    public String serialize(Object object) {
        if (object == null) {
            return null;
        }
        try {
            BValueTree treeMaker = new BValueTree();
            BRefType bValueTree = treeMaker.toBValueTree(object);
            return this.generateJson(bValueTree);
        }
        catch (Exception e) {
            throw new BallerinaException("Exception in JsonSerializer: ", e);
        }
    }

    private String generateJson(BRefType bValueTree) {
        StringWriter writer = new StringWriter();
        JsonGenerator generator = new JsonGenerator(writer);
        try {
            generator.serialize(bValueTree);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    @Override
    public <T> T deserialize(String serialized, Class<T> destinationType) {
        BRefType<?> objTree = JsonParser.parse(new StringReader(serialized));
        JsonDeserializer jsonDeserializer = new JsonDeserializer(objTree);
        return (T)jsonDeserializer.deserialize(destinationType);
    }

    static {
        bValueProvider.register(new NumericBValueProviders.BigIntegerBValueProvider());
        bValueProvider.register(new NumericBValueProviders.BigDecimalBValueProvider());
        bValueProvider.register(new BStringBValueProvider());
        bValueProvider.register(new BMapBValueProvider());
        bValueProvider.register(new ClassBValueProvider());
        bValueProvider.register(new ConcurrentHashMapBValueProvider());
        bValueProvider.register(new BIntegerBValueProvider());
        bValueProvider.register(new BFloatBValueProvider());
        bValueProvider.register(new BBooleanBValueProvider());
        bValueProvider.register(new ArrayListBValueProvider());
        bValueProvider.register(new HashSetBValueProvider());
        bValueProvider.register(new LinkedHashSetBValueProvider());
        bValueProvider.register(new BTypeBValueProviders.BObjectTypeBValueProvider());
        bValueProvider.register(new BTypeBValueProviders.BRecordTypeBValueProvider());
        bValueProvider.register(new BTypeBValueProviders.BAnyTypeBValueProvider());
        bValueProvider.register(new BTypeBValueProviders.BAnydataTypeBValueProvider());
        bValueProvider.register(new BTypeBValueProviders.BArrayTypeBValueProvider());
        bValueProvider.register(new BTypeBValueProviders.BMapTypeBValueProvider());
        bValueProvider.register(new DateTimeBValueProviders.DateBValueProvider());
        bValueProvider.register(new DateTimeBValueProviders.InstantBValueProvider());
        bValueProvider.register(new BXMLBValueProviders.BXMLItemBValueProvider());
        bValueProvider.register(new BXMLBValueProviders.BXMLSequenceBValueProvider());
        bValueProvider.register(new BXMLBValueProviders.BXMLQNameBValueProvider());
        bValueProvider.register(new InetSocketAddressBValueProvider());
        bValueProvider.register(new BValueArrayBValueProvider());
    }
}

