/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.core.model.util.serializer;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.ballerinalang.core.model.util.serializer.JsonSerializer;
import org.ballerinalang.core.model.util.serializer.ObjectHelper;
import org.ballerinalang.core.model.util.serializer.TypeInstanceProvider;
import org.ballerinalang.core.model.util.serializer.UnsafeObjectAllocator;
import org.ballerinalang.core.util.exceptions.BallerinaException;

public class TypeInstanceProviderFactory {
    public TypeInstanceProvider from(String fullClassName) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(fullClassName);
            this.assertInstantiable(clazz);
            Constructor<?> declaredConstructor = clazz.getDeclaredConstructor(new Class[0]);
            return this.createInstanceProvider(declaredConstructor, clazz);
        }
        catch (NoSuchMethodException e) {
            return this.createInstanceProvider(clazz);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private void assertInstantiable(Class<?> clazz) {
        if (!ObjectHelper.isInstantiable(clazz)) {
            throw new BallerinaException("Can not generate instance provider for un-instantiable class: " + clazz.getName());
        }
    }

    private TypeInstanceProvider createInstanceProvider(final Constructor<?> constructor, final Class<?> clazz) {
        return new TypeInstanceProvider(){

            @Override
            public String getTypeName() {
                return clazz.getSimpleName();
            }

            @Override
            public Object newInstance() {
                try {
                    constructor.setAccessible(true);
                    return constructor.newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    return null;
                }
            }

            @Override
            public Class getTypeClass() {
                return clazz;
            }
        };
    }

    private TypeInstanceProvider createInstanceProvider(final Class<?> clazz) {
        return new TypeInstanceProvider(){

            @Override
            public String getTypeName() {
                return clazz.getSimpleName();
            }

            @Override
            public Object newInstance() {
                try {
                    return UnsafeObjectAllocator.allocateFor(clazz);
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
                    throw new BallerinaException(String.format("%s cannot instantiate object of %s, maybe add a %s", JsonSerializer.class.getSimpleName(), clazz.getName(), TypeInstanceProvider.class.getSimpleName()));
                }
            }

            @Override
            public Class getTypeClass() {
                return clazz;
            }
        };
    }
}

