/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.core.model.util.serializer.providers.bvalue;

import org.ballerinalang.core.model.util.serializer.BPacket;
import org.ballerinalang.core.model.util.serializer.BValueDeserializer;
import org.ballerinalang.core.model.util.serializer.BValueSerializer;
import org.ballerinalang.core.model.util.serializer.SerializationBValueProvider;
import org.ballerinalang.core.model.values.BString;
import org.ballerinalang.core.util.exceptions.BallerinaException;

public class ClassBValueProvider
implements SerializationBValueProvider<Class> {
    private static final String INT = "int";
    private static final String FLOAT = "float";
    private static final String DOUBLE = "double";
    private static final String LONG = "long";
    private static final String BYTE = "byte";
    private static final String CHAR = "char";

    @Override
    public String typeName() {
        return this.getType().getName();
    }

    @Override
    public Class<?> getType() {
        return Class.class;
    }

    @Override
    public BPacket toBValue(Class clazz, BValueSerializer serializer) {
        return BPacket.from(this.typeName(), new BString(clazz.getName()));
    }

    @Override
    public Class toObject(BPacket packet, BValueDeserializer bValueDeserializer) {
        String className;
        switch (className = packet.getValue().stringValue()) {
            case "int": {
                return Integer.TYPE;
            }
            case "float": {
                return Float.TYPE;
            }
            case "double": {
                return Double.TYPE;
            }
            case "long": {
                return Long.TYPE;
            }
            case "byte": {
                return Byte.TYPE;
            }
            case "char": {
                return Character.TYPE;
            }
        }
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new BallerinaException("Cannot find serialized class: " + className);
        }
    }
}

