/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.core.model.util.serializer.providers.bvalue;

import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.ballerinalang.core.model.util.serializer.BPacket;
import org.ballerinalang.core.model.util.serializer.BValueDeserializer;
import org.ballerinalang.core.model.util.serializer.BValueSerializer;
import org.ballerinalang.core.model.util.serializer.SerializationBValueProvider;
import org.ballerinalang.core.model.values.BMap;
import org.ballerinalang.core.model.values.BValue;

public class ConcurrentHashMapBValueProvider
implements SerializationBValueProvider<ConcurrentHashMap> {
    @Override
    public String typeName() {
        return this.getType().getName();
    }

    @Override
    public Class<?> getType() {
        return ConcurrentHashMap.class;
    }

    @Override
    public BPacket toBValue(ConcurrentHashMap map, BValueSerializer serializer) {
        HashMap hashMap = new HashMap(map);
        BValue payload = serializer.toBValue(hashMap, null);
        return BPacket.from(this.typeName(), payload);
    }

    @Override
    public ConcurrentHashMap toObject(BPacket packet, BValueDeserializer bValueDeserializer) {
        BMap payload = (BMap)packet.getValue();
        HashMap hashMap = (HashMap)bValueDeserializer.deserialize(payload, HashMap.class);
        return new ConcurrentHashMap(hashMap);
    }
}

